/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policies;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;

public class RevertAction
extends ProfileModificationAction {
    public RevertAction(ISelectionProvider selectionProvider, String profileId, IProfileChooser chooser, Policies policies, Shell shell) {
        super(ProvUI.REVERT_COMMAND_LABEL, selectionProvider, profileId, chooser, policies, shell);
        this.setToolTipText(ProvUI.REVERT_COMMAND_TOOLTIP);
    }

    protected ProvisioningPlan getProvisioningPlan(IInstallableUnit[] toRevert, String targetProfileId, IProgressMonitor monitor) throws ProvisionException {
        if (toRevert.length == 1) {
            return ProvisioningUtil.getRevertPlan(toRevert[0], monitor);
        }
        return null;
    }

    protected void performOperation(IInstallableUnit[] toBecome, String targetProfileId, ProvisioningPlan plan) {
        ProfileModificationOperation op = new ProfileModificationOperation(ProvUIMessages.RevertIUOperationLabel, targetProfileId, plan);
        ProvisioningOperationRunner.schedule(op, this.getShell(), 3);
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        IInstallableUnit iu;
        if (selectionArray.length == 1 && (iu = this.getIU(selectionArray[0])) != null) {
            return Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.type.profile"));
        }
        return false;
    }

    protected String getTaskName() {
        return ProvUIMessages.RevertIUProgress;
    }
}

