/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.License;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.LicenseManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SimpleLicenseManager
extends LicenseManager {
    Set accepted = new HashSet();

    public boolean accept(IInstallableUnit iu) {
        License license = iu.getLicense();
        if (license != null) {
            this.accepted.add(license.getDigest());
        }
        return true;
    }

    public boolean reject(IInstallableUnit iu) {
        License license = iu.getLicense();
        if (license != null) {
            this.accepted.remove(license.getDigest());
        }
        return true;
    }

    public boolean isAccepted(IInstallableUnit iu) {
        License license = iu.getLicense();
        if (license == null) {
            return true;
        }
        return this.accepted.contains(license.getDigest());
    }

    public boolean hasAcceptedLicenses() {
        return !this.accepted.isEmpty();
    }

    public void read(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(stream);
            Element root = doc.getDocumentElement();
            this.processRoot(root, this.accepted);
        }
        catch (ParserConfigurationException e) {
            ProvUI.handleException(e, ProvUIMessages.ProvUILicenseManager_ParsingError, 1);
        }
        catch (SAXException e) {
            ProvUI.handleException(e, ProvUIMessages.ProvUILicenseManager_ParsingError, 1);
        }
    }

    public void write(OutputStream stream) throws IOException {
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            osw = new OutputStreamWriter(stream, "UTF8");
            writer = new PrintWriter(osw);
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<licenses>");
            Iterator i = this.accepted.iterator();
            while (i.hasNext()) {
                BigInteger digest = (BigInteger)i.next();
                writer.print("    <license digest=\"" + digest.toString(16) + "\"/>");
            }
        }
        finally {
            writer.println("</licenses>");
            writer.flush();
            writer.close();
            if (osw != null) {
                osw.close();
            }
        }
    }

    private void processRoot(Node root, Set licenses) {
        if (root.getNodeName().equals("licenses")) {
            NodeList children = root.getChildNodes();
            this.processChildren(children, licenses);
        }
    }

    private void processChildren(NodeList children, Set licenses) {
        int i = 0;
        while (i < children.getLength()) {
            NamedNodeMap atts;
            Node digestAtt;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("license") && (digestAtt = (atts = child.getAttributes()).getNamedItem("digest")) != null) {
                BigInteger digest = new BigInteger(digestAtt.getNodeValue(), 16);
                licenses.add(digest);
            }
            ++i;
        }
    }
}

