/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ApplyProfileChangesDialog;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.BundleContext;

public class ProvisioningOperationRunner {
    private static final String PROPERTY_PREFIX = "org.eclipse.equinox.p2.ui";
    private static final QualifiedName OPERATION_KEY = new QualifiedName("org.eclipse.equinox.p2.ui", "operationKey");
    static HashSet scheduledJobs = new HashSet();
    static boolean restartRequested = false;
    static boolean restartRequired = false;
    static ListenerList jobListeners = new ListenerList();
    static /* synthetic */ Class class$0;

    public static void run(ProvisioningOperation op, Shell shell, int errorStyle) {
        try {
            if (op instanceof IUndoableOperation) {
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, ProvUI.getUIInfoAdapter(shell));
            } else {
                op.execute(null, ProvUI.getUIInfoAdapter(shell));
            }
        }
        catch (ExecutionException e) {
            ProvUI.handleException(e.getCause(), NLS.bind((String)ProvUIMessages.ProvisioningOperationRunner_ErrorExecutingOperation, (Object)op.getLabel()), errorStyle);
        }
    }

    public static Job schedule(final ProvisioningOperation op, final Shell shell, int errorStyle) {
        Object job;
        boolean noPrompt;
        boolean bl = noPrompt = (errorStyle & 6) == 0;
        if (op.runInBackground()) {
            job = new Job(op.getLabel()){

                protected IStatus run(IProgressMonitor monitor) {
                    1 thisJob = this;
                    try {
                        IStatus status = op instanceof IUndoableOperation ? PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, ProvUI.getUIInfoAdapter(shell)) : op.execute(monitor, ProvUI.getUIInfoAdapter(shell));
                        if (status != Status.OK_STATUS && noPrompt) {
                            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                            this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                        }
                        return status;
                    }
                    catch (ExecutionException e) {
                        String message;
                        if (noPrompt) {
                            thisJob.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                            thisJob.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                        }
                        if ((message = e.getCause().getLocalizedMessage()) == null) {
                            message = NLS.bind((String)ProvUIMessages.ProvisioningOperationRunner_ErrorExecutingOperation, (Object)op.getLabel());
                        }
                        return new Status(4, ProvisioningOperationRunner.PROPERTY_PREFIX, 0, message, e.getCause());
                    }
                }
            };
            job.setPriority(30);
        } else {
            job = new WorkbenchJob(op.getLabel()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        IStatus status = op instanceof IUndoableOperation ? PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, ProvUI.getUIInfoAdapter(shell)) : op.execute(monitor, ProvUI.getUIInfoAdapter(shell));
                        if (status != Status.OK_STATUS && noPrompt) {
                            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                            this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                        }
                        return status;
                    }
                    catch (ExecutionException e) {
                        if (noPrompt) {
                            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                            this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                        }
                        return new Status(4, ProvisioningOperationRunner.PROPERTY_PREFIX, 0, NLS.bind((String)ProvUIMessages.ProvisioningOperationRunner_ErrorExecutingOperation, (Object)op.getLabel()), e.getCause());
                    }
                }
            };
            job.setPriority(20);
        }
        job.setUser(op.isUser());
        job.setProperty(OPERATION_KEY, (Object)op);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ProvUIImages.getImageDescriptor("obj/profile_obj.gif"));
        scheduledJobs.add(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                scheduledJobs.remove(event.getJob());
                if (restartRequested) {
                    ProvisioningOperationRunner.requestRestart(restartRequired);
                }
            }
        });
        Object[] listeners = jobListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            job.addJobChangeListener((IJobChangeListener)listeners[i]);
            ++i;
        }
        job.schedule();
        return job;
    }

    public static void requestRestart(boolean force) {
        if (ProvisioningOperationRunner.hasScheduledOperations()) {
            restartRequested = true;
            restartRequired = restartRequired || force;
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null || window.getShell() == null || window.getShell().isDisposed()) {
                    return;
                }
                int retCode = ApplyProfileChangesDialog.promptForRestart(window.getShell(), restartRequired);
                if (retCode == 1) {
                    BundleContext bundleContext = ProvUIActivator.getContext();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.configurator.Configurator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Configurator configurator = (Configurator)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
                    try {
                        configurator.applyConfiguration();
                    }
                    catch (IOException e) {
                        ProvUI.handleException(e, ProvUIMessages.ProvUI_ErrorDuringApplyConfig, 5);
                    }
                } else if (retCode == 2) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        });
    }

    public static boolean hasScheduledOperations() {
        return !scheduledJobs.isEmpty();
    }

    public static boolean hasScheduledOperationsFor(String profileId) {
        Job[] jobs = ProvisioningOperationRunner.getScheduledJobs();
        int i = 0;
        while (i < jobs.length) {
            String id;
            Object op = jobs[i].getProperty(OPERATION_KEY);
            if (op instanceof ProfileModificationOperation && profileId.equals(id = ((ProfileModificationOperation)op).getProfileId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addJobChangeListener(IJobChangeListener listener) {
        jobListeners.add((Object)listener);
        Job[] jobs = ProvisioningOperationRunner.getScheduledJobs();
        int i = 0;
        while (i < jobs.length) {
            jobs[i].addJobChangeListener(listener);
            ++i;
        }
    }

    public static void removeJobChangeListener(IJobChangeListener listener) {
        jobListeners.remove((Object)listener);
        Job[] jobs = ProvisioningOperationRunner.getScheduledJobs();
        int i = 0;
        while (i < jobs.length) {
            jobs[i].removeJobChangeListener(listener);
            ++i;
        }
    }

    private static Job[] getScheduledJobs() {
        return scheduledJobs.toArray(new Job[scheduledJobs.size()]);
    }
}

