/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProvUI {
    public static final String INSTALL_COMMAND_LABEL = ProvUIMessages.InstallIUCommandLabel;
    public static final String INSTALL_COMMAND_TOOLTIP = ProvUIMessages.InstallIUCommandTooltip;
    public static final String UNINSTALL_COMMAND_LABEL = ProvUIMessages.UninstallIUCommandLabel;
    public static final String UNINSTALL_COMMAND_TOOLTIP = ProvUIMessages.UninstallIUCommandTooltip;
    public static final String UPDATE_COMMAND_LABEL = ProvUIMessages.UpdateIUCommandLabel;
    public static final String UPDATE_COMMAND_TOOLTIP = ProvUIMessages.UpdateIUCommandTooltip;
    public static final String REVERT_COMMAND_LABEL = ProvUIMessages.RevertIUCommandLabel;
    public static final String REVERT_COMMAND_TOOLTIP = ProvUIMessages.RevertIUCommandTooltip;
    static ObjectUndoContext provisioningUndoContext;
    private static final int DEFAULT_COLUMN_WIDTH = 200;
    private static IUColumnConfig[] iuColumnConfig;
    static /* synthetic */ Class class$0;

    static {
        iuColumnConfig = new IUColumnConfig[]{new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 200), new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 200)};
    }

    public static Shell getShell(IAdaptable uiInfo) {
        IWorkbenchWindow window;
        if (uiInfo != null) {
            Shell shell;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((shell = (Shell)uiInfo.getAdapter((Class)clazz)) != null) {
                return shell;
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display.getActiveShell();
    }

    public static IStatus handleException(Throwable t, String message, int style) {
        if (message == null && t != null) {
            message = t.getMessage();
        }
        Status status = new Status(4, "org.eclipse.equinox.p2.ui", 0, message, t);
        StatusManager.getManager().handle((IStatus)status, style);
        return status;
    }

    public static void reportStatus(IStatus status, int style) {
        if ((style & 4) == 4) {
            if (status.getSeverity() == 1) {
                MessageDialog.openInformation(null, (String)ProvUIMessages.ProvUI_InformationTitle, (String)status.getMessage());
                style &= 0xFFFFFFFB;
            } else if (status.getSeverity() == 2) {
                MessageDialog.openWarning(null, (String)ProvUIMessages.ProvUI_WarningTitle, (String)status.getMessage());
                style &= 0xFFFFFFFB;
            }
        }
        if (style != 0) {
            StatusManager.getManager().handle(status, style);
        }
    }

    public static IUColumnConfig[] getIUColumnConfig() {
        return iuColumnConfig;
    }

    public static void setIUColumnConfig(IUColumnConfig[] columnConfig) {
        iuColumnConfig = columnConfig;
    }

    public static IUndoContext getProvisioningUndoContext() {
        if (provisioningUndoContext == null) {
            provisioningUndoContext = new ObjectUndoContext(new Object(), "Provisioning Undo Context");
            IOperationHistory opHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
            opHistory.addOperationApprover(ProvUI.getOperationApprover());
        }
        return provisioningUndoContext;
    }

    public static Object getAdapter(Object object, Class adapterType) {
        if (object == null) {
            return null;
        }
        if (adapterType.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable) {
            return ((IAdaptable)object).getAdapter(adapterType);
        }
        return null;
    }

    public static Shell getDefaultParentShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        int i = 0;
        while (i < shells.length) {
            int style;
            if (shells[i].isVisible() && ((style = shells[i].getStyle()) & modal) != 0) {
                return shells[i];
            }
            ++i;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    static IOperationApprover getOperationApprover() {
        return new IOperationApprover(){

            public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
                IStatus[] status = new IStatus[]{Status.OK_STATUS};
                if (operation.hasContext((IUndoContext)provisioningUndoContext) && operation instanceof IAdvancedUndoableOperation) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(this, status, operation){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IStatus[] val$status;
                        private final /* synthetic */ IUndoableOperation val$operation;
                        {
                            this.this$1 = var1_1;
                            this.val$status = iStatusArray;
                            this.val$operation = iUndoableOperation;
                        }

                        public void run(IProgressMonitor monitor) {
                            try {
                                this.val$status[0] = ((IAdvancedUndoableOperation)this.val$operation).computeUndoableStatus(monitor);
                                if (!this.val$status[0].isOK()) {
                                    ProvUI.reportStatus(this.val$status[0], 3);
                                }
                            }
                            catch (ExecutionException e) {
                                this.val$status[0] = new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e);
                                ProvUI.handleException(e.getCause(), null, 3);
                            }
                        }
                    };
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this, runnable, status){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IRunnableWithProgress val$runnable;
                        private final /* synthetic */ IStatus[] val$status;
                        {
                            this.this$1 = var1_1;
                            this.val$runnable = iRunnableWithProgress;
                            this.val$status = iStatusArray;
                        }

                        public void run() {
                            try {
                                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, this.val$runnable);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException e) {
                                this.val$status[0] = new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e);
                                ProvUI.handleException(e.getCause(), null, 3);
                            }
                        }
                    });
                }
                return status[0];
            }

            public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
                IStatus[] status = new IStatus[]{Status.OK_STATUS};
                if (operation.hasContext((IUndoContext)provisioningUndoContext) && operation instanceof IAdvancedUndoableOperation) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(this, status, operation){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IStatus[] val$status;
                        private final /* synthetic */ IUndoableOperation val$operation;
                        {
                            this.this$1 = var1_1;
                            this.val$status = iStatusArray;
                            this.val$operation = iUndoableOperation;
                        }

                        public void run(IProgressMonitor monitor) {
                            try {
                                this.val$status[0] = ((IAdvancedUndoableOperation)this.val$operation).computeRedoableStatus(monitor);
                                if (!this.val$status[0].isOK()) {
                                    ProvUI.reportStatus(this.val$status[0], 2);
                                }
                            }
                            catch (ExecutionException e) {
                                this.val$status[0] = new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e);
                                ProvUI.handleException(e.getCause(), null, 3);
                            }
                        }
                    };
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this, runnable, status){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IRunnableWithProgress val$runnable;
                        private final /* synthetic */ IStatus[] val$status;
                        {
                            this.this$1 = var1_1;
                            this.val$runnable = iRunnableWithProgress;
                            this.val$status = iStatusArray;
                        }

                        public void run() {
                            try {
                                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, this.val$runnable);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException e) {
                                this.val$status[0] = new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e);
                                ProvUI.handleException(e.getCause(), null, 3);
                            }
                        }
                    });
                }
                return status[0];
            }
        };
    }

    static IAdaptable getUIInfoAdapter(final Shell shell) {
        return new IAdaptable(){

            public Object getAdapter(Class clazz) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    return shell;
                }
                return null;
            }
        };
    }

    public static void addProvisioningListener(StructuredViewerProvisioningListener listener) {
        ProvUIActivator.getDefault().addProvisioningListener(listener);
    }

    public static void removeProvisioningListener(StructuredViewerProvisioningListener listener) {
        ProvUIActivator.getDefault().removeProvisioningListener(listener);
    }

    public static void startBatchOperation() {
        ProvUIActivator.getDefault().signalBatchOperationStart();
    }

    public static void endBatchOperation() {
        ProvUIActivator.getDefault().signalBatchOperationComplete();
    }
}

