/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateOrInstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateOrInstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.model.AvailableUpdateElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;

public class UpdateWizardPage
extends UpdateOrInstallWizardPage {
    AvailableUpdateElement[] updateElements;
    IInstallableUnit[] suggestedReplacements;
    Object[] initialSelections = new Object[0];

    public UpdateWizardPage(IInstallableUnit[] iusToReplace, AvailableUpdateElement[] elements, Object[] initialSelections, String profileId, ProvisioningPlan plan, UpdateOrInstallWizard wizard) {
        super("UpdateWizardPage", iusToReplace, profileId, plan, wizard);
        this.updateElements = elements;
        this.initialSelections = initialSelections;
        this.setTitle(ProvUIMessages.UpdateAction_UpdatesAvailableTitle);
        this.setDescription(ProvUIMessages.UpdateAction_UpdatesAvailableMessage);
    }

    protected void makeElements(IInstallableUnit[] ius, List elements) {
        int i = 0;
        while (i < this.updateElements.length) {
            elements.add(this.updateElements[i]);
            ++i;
        }
    }

    private IInstallableUnit[] getIUsToReplace(Object[] replacementElements) {
        HashSet<IInstallableUnit> iusToReplace = new HashSet<IInstallableUnit>();
        int i = 0;
        while (i < replacementElements.length) {
            if (replacementElements[i] instanceof AvailableUpdateElement) {
                iusToReplace.add(((AvailableUpdateElement)replacementElements[i]).getIUToBeUpdated());
            }
            ++i;
        }
        return iusToReplace.toArray(new IInstallableUnit[iusToReplace.size()]);
    }

    protected String getOperationLabel() {
        return ProvUIMessages.UpdateIUOperationLabel;
    }

    protected ProvisioningPlan computeProvisioningPlan(Object[] selectedElements, IProgressMonitor monitor) throws ProvisionException {
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)this.getProfileId());
        request.removeInstallableUnits(this.getIUsToReplace(selectedElements));
        request.addInstallableUnits(this.elementsToIUs(selectedElements));
        ProvisioningPlan plan = ProvisioningUtil.getProvisioningPlan(request, this.getProvisioningContext(), monitor);
        this.computeSizing(plan, this.getProfileId());
        return plan;
    }

    protected void setInitialCheckState() {
        this.listViewer.setCheckedElements(this.initialSelections);
    }

    protected String getIUDescription(IInstallableUnit iu) {
        IUpdateDescriptor updateDescriptor;
        if (iu != null && (updateDescriptor = iu.getUpdateDescriptor()) != null && updateDescriptor.getDescription() != null && updateDescriptor.getDescription().length() > 0) {
            return updateDescriptor.getDescription();
        }
        return super.getIUDescription(iu);
    }
}

