/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProfileModificationWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateOrInstallWizard;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Sizing;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class UpdateOrInstallWizardPage
extends ProfileModificationWizardPage {
    protected UpdateOrInstallWizard wizard;
    protected Label sizeInfo;
    protected Sizing sizing;
    private Job sizingJob;

    protected UpdateOrInstallWizardPage(String id, IInstallableUnit[] ius, String profileId, ProvisioningPlan plan, UpdateOrInstallWizard wizard) {
        super(id, ius, profileId, plan);
        this.computeSizing(plan, profileId);
        this.wizard = wizard;
    }

    protected void computeSizing(final ProvisioningPlan plan, final String profileId) {
        this.sizing = null;
        if (this.sizeInfo != null && !this.getShell().isDisposed()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    UpdateOrInstallWizardPage.this.updateSizingInfo();
                }
            });
        }
        if (this.sizingJob != null) {
            this.sizingJob.cancel();
        }
        this.sizingJob = new Job("Computing size"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    UpdateOrInstallWizardPage.this.sizing = ProvisioningUtil.getSizeInfo(plan, profileId, monitor);
                }
                catch (ProvisionException e) {
                    return e.getStatus();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (UpdateOrInstallWizardPage.this.display != null) {
                    UpdateOrInstallWizardPage.this.display.asyncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            2.access$0(this.this$1).updateSizingInfo();
                        }
                    });
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ UpdateOrInstallWizardPage access$0(2 var0) {
                return var0.UpdateOrInstallWizardPage.this;
            }
        };
        this.sizingJob.schedule();
        this.sizingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UpdateOrInstallWizardPage.this.sizingJob = null;
            }
        });
    }

    protected void createSizingInfo(Composite parent) {
        this.sizeInfo = new Label(parent, 0);
        GridData data = new GridData(4, 4, true, false);
        this.sizeInfo.setLayoutData((Object)data);
        this.updateSizingInfo();
    }

    protected void checkedIUsChanged() {
        this.wizard.iusChanged(this.getCheckedIUs());
        super.checkedIUsChanged();
    }

    protected void updateSizingInfo() {
        long size = -2L;
        if (this.sizing != null && (size = this.sizing.getDiskSize()) == 0L) {
            size = -2L;
        }
        if (this.sizeInfo != null && !this.sizeInfo.isDisposed()) {
            this.sizeInfo.setText(NLS.bind((String)ProvUIMessages.UpdateOrInstallWizardPage_Size, (Object)this.getFormattedSize(size)));
        }
    }

    protected String getFormattedSize(long size) {
        if (size == -1L || size == -2L) {
            return ProvUIMessages.IUDetailsLabelProvider_Unknown;
        }
        if (size > 1000L) {
            long kb = size / 1000L;
            return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_KB, (Object)NumberFormat.getInstance().format(new Long(kb)));
        }
        return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_Bytes, (Object)NumberFormat.getInstance().format(new Long(size)));
    }

    public void dispose() {
        if (this.sizingJob != null) {
            this.sizingJob.cancel();
            this.sizingJob = null;
        }
    }
}

