/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.IViewMenuProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.DeferredQueryContentListener;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeferredFetchFilteredTree
extends FilteredTree {
    ToolBar toolBar;
    MenuManager menuManager;
    ToolItem viewMenuButton;
    Display display;
    PatternFilter patternFilter;
    IViewMenuProvider viewMenuProvider;
    DeferredQueryContentProvider contentProvider;
    boolean useCheckBoxTree = false;

    public DeferredFetchFilteredTree(Composite parent, int treeStyle, PatternFilter filter, IViewMenuProvider viewMenuProvider, Display display, boolean useCheckBoxViewer) {
        super(parent);
        this.display = display;
        this.viewMenuProvider = viewMenuProvider;
        this.patternFilter = filter;
        this.useCheckBoxTree = useCheckBoxViewer;
        this.init(treeStyle, filter);
    }

    protected void createControl(Composite composite, int treeStyle) {
        super.createControl(composite, treeStyle);
        if (!this.showFilterControls && this.viewMenuProvider != null) {
            this.createViewMenu(composite);
        }
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
        if (this.useCheckBoxTree) {
            return new ContainerCheckedTreeViewer(composite, style);
        }
        return super.doCreateTreeViewer(composite, style);
    }

    protected Composite createFilterControls(Composite filterParent) {
        super.createFilterControls(filterParent);
        Layout layout = filterParent.getLayout();
        if (layout instanceof GridLayout) {
            ++((GridLayout)layout).numColumns;
        }
        if (this.viewMenuProvider != null) {
            this.createViewMenu(filterParent);
        }
        return filterParent;
    }

    private void createViewMenu(Composite filterParent) {
        this.toolBar = new ToolBar(filterParent, 0x800000);
        this.viewMenuButton = new ToolItem(this.toolBar, 8, 0);
        this.viewMenuButton.setImage(JFaceResources.getImage((String)"popup_menu_image"));
        this.viewMenuButton.setToolTipText(ProvUIMessages.AvailableIUGroup_ViewByToolTipText);
        this.viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeferredFetchFilteredTree.this.showViewMenu();
            }
        });
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DeferredFetchFilteredTree.this.showViewMenu();
            }
        });
    }

    void showViewMenu() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            this.viewMenuProvider.fillViewMenu((IMenuManager)this.menuManager);
        }
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolBar.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.getParent().toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    public void contentProviderSet(DeferredQueryContentProvider deferredProvider) {
        this.contentProvider = deferredProvider;
        deferredProvider.addListener(new DeferredQueryContentListener(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
                if (newInput == null) {
                    return;
                }
                if (DeferredFetchFilteredTree.this.showFilterControls && DeferredFetchFilteredTree.this.filterText != null && !DeferredFetchFilteredTree.this.filterText.isDisposed()) {
                    DeferredFetchFilteredTree.this.filterText.setText(DeferredFetchFilteredTree.this.getInitialText());
                    DeferredFetchFilteredTree.this.filterText.selectAll();
                }
            }
        });
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob job = super.doCreateRefreshJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                DeferredFetchFilteredTree.this.display.syncExec(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        String text = DeferredFetchFilteredTree.access$3(4.access$0(this.this$1));
                        if (text == null || DeferredFetchFilteredTree.access$4(4.access$0(this.this$1)) != null && DeferredFetchFilteredTree.access$4(4.access$0(this.this$1)).equals(text)) {
                            return;
                        }
                        4.access$0(this.this$1).contentProvider.setSynchronous(true);
                    }
                });
            }

            static /* synthetic */ DeferredFetchFilteredTree access$0(4 var0) {
                return var0.DeferredFetchFilteredTree.this;
            }
        });
        return job;
    }

    static /* synthetic */ String access$3(DeferredFetchFilteredTree deferredFetchFilteredTree) {
        return deferredFetchFilteredTree.getFilterString();
    }

    static /* synthetic */ String access$4(DeferredFetchFilteredTree deferredFetchFilteredTree) {
        return deferredFetchFilteredTree.initialText;
    }
}

