/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.StaticContentProvider;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.License;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.LicenseManager;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class AcceptLicensesWizardPage
extends WizardPage {
    TableViewer iuViewer;
    Text licenseTextBox;
    Button acceptButton;
    Button declineButton;
    private IInstallableUnit[] ius;
    private LicenseManager licenseManager;
    private static final int DEFAULT_COLUMN_WIDTH = 40;

    public AcceptLicensesWizardPage(IInstallableUnit[] ius, LicenseManager licenseManager) {
        super("AcceptLicenses");
        this.setTitle(ProvUIMessages.AcceptLicensesWizardPage_Title);
        this.licenseManager = licenseManager;
        this.update(ius);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        if (this.ius.length == 0) {
            Label label = new Label(parent, 0);
            this.setControl((Control)label);
        } else if (this.ius.length == 1) {
            this.createLicenseSection(parent, true);
        } else {
            SashForm composite = new SashForm(parent, 256);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            this.createIUSection((Composite)composite);
            this.createLicenseSection((Composite)composite, false);
            this.setControl((Control)composite);
            Object element = this.iuViewer.getElementAt(0);
            if (element != null) {
                this.iuViewer.setSelection((ISelection)new StructuredSelection(element));
            }
        }
        Dialog.applyDialogFont((Control)this.getControl());
    }

    private void createIUSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.AcceptLicensesWizardPage_ItemsLabel);
        this.iuViewer = new TableViewer(composite, 68352);
        this.setTableColumns(this.iuViewer.getTable());
        this.iuViewer.setContentProvider((IContentProvider)new StaticContentProvider(new Object[0]));
        this.iuViewer.setInput((Object)this.ius);
        this.iuViewer.setLabelProvider((IBaseLabelProvider)new IUDetailsLabelProvider());
        this.iuViewer.setComparator(new ViewerComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o2).compareTo((String)o1);
            }
        }));
        this.iuViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AcceptLicensesWizardPage.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        gd = new GridData(1808);
        this.iuViewer.getControl().setLayoutData((Object)gd);
    }

    private void createLicenseAcceptSection(Composite parent, boolean multiple) {
        Composite buttonContainer = new Composite(parent, 0);
        GridData gd = new GridData(256);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)gd);
        this.acceptButton = new Button(buttonContainer, 16);
        if (multiple) {
            this.acceptButton.setText(ProvUIMessages.AcceptLicensesWizardPage_AcceptMultiple);
        } else {
            this.acceptButton.setText(ProvUIMessages.AcceptLicensesWizardPage_AcceptSingle);
        }
        this.acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceptLicensesWizardPage.this.setPageComplete(AcceptLicensesWizardPage.this.acceptButton.getSelection());
            }
        });
        this.declineButton = new Button(buttonContainer, 16);
        if (multiple) {
            this.declineButton.setText(ProvUIMessages.AcceptLicensesWizardPage_RejectMultiple);
        } else {
            this.declineButton.setText(ProvUIMessages.AcceptLicensesWizardPage_RejectSingle);
        }
        this.declineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceptLicensesWizardPage.this.setPageComplete(AcceptLicensesWizardPage.this.acceptButton.getSelection());
            }
        });
        this.acceptButton.setSelection(false);
        this.declineButton.setSelection(true);
    }

    private void createLicenseSection(Composite parent, boolean singleLicense) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.AcceptLicensesWizardPage_LicenseTextLabel);
        this.licenseTextBox = new Text(composite, 2890);
        this.licenseTextBox.setBackground(this.licenseTextBox.getDisplay().getSystemColor(25));
        this.initializeDialogUnits((Control)this.licenseTextBox);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        this.licenseTextBox.setLayoutData((Object)gd);
        this.createLicenseAcceptSection(composite, !singleLicense);
        if (singleLicense) {
            this.licenseTextBox.setText(this.getLicenseBody(this.ius[0]));
            this.setControl((Control)composite);
        }
    }

    void handleSelectionChanged(IStructuredSelection selection) {
        Object selected;
        if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof IInstallableUnit) {
            this.licenseTextBox.setText(this.getLicenseBody((IInstallableUnit)selected));
        }
    }

    private void setTableColumns(Table table) {
        table.setHeaderVisible(true);
        IUColumnConfig[] columns = ProvUI.getIUColumnConfig();
        this.initializeDialogUnits((Control)table);
        int i = 0;
        while (i < columns.length) {
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setText(columns[i].columnTitle);
            tc.setWidth(this.convertWidthInCharsToPixels(40));
            ++i;
        }
    }

    public boolean performFinish() {
        this.rememberAcceptedLicenses();
        return true;
    }

    public boolean hasLicensesToAccept() {
        return this.ius.length > 0;
    }

    public void update(IInstallableUnit[] theIUs) {
        this.ius = this.iusWithUnacceptedLicenses(theIUs);
        this.setDescription();
        this.setPageComplete(this.ius.length == 0);
        if (this.getControl() != null) {
            Composite parent = this.getControl().getParent();
            this.getControl().dispose();
            this.createControl(parent);
            parent.layout(true, true);
        }
    }

    private String getLicenseBody(IInstallableUnit iu) {
        License license = iu.getLicense();
        if (license != null && license.getBody() != null) {
            return license.getBody();
        }
        return "";
    }

    private IInstallableUnit[] iusWithUnacceptedLicenses(IInstallableUnit[] allIUs) {
        ArrayList<IInstallableUnit> unaccepted = new ArrayList<IInstallableUnit>();
        int i = 0;
        while (i < allIUs.length) {
            IInstallableUnit iu = allIUs[i];
            License license = iu.getLicense();
            if (!(license == null || this.licenseManager != null && this.licenseManager.isAccepted(iu))) {
                unaccepted.add(iu);
            }
            ++i;
        }
        return unaccepted.toArray(new IInstallableUnit[unaccepted.size()]);
    }

    private void rememberAcceptedLicenses() {
        int i = 0;
        while (i < this.ius.length) {
            if (this.licenseManager != null) {
                this.licenseManager.accept(this.ius[i]);
            }
            ++i;
        }
    }

    private void setDescription() {
        if (this.ius.length == 0) {
            this.setDescription(ProvUIMessages.AcceptLicensesWizardPage_NoLicensesDescription);
        } else {
            this.setDescription(ProvUIMessages.AcceptLicensesWizardPage_ReviewLicensesDescription);
        }
    }
}

