/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.sdk;

import java.util.ArrayList;
import org.eclipse.equinox.internal.p2.ui.sdk.AddColocatedRepositoryAction;
import org.eclipse.equinox.internal.p2.ui.sdk.AvailableIUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.p2.ui.sdk.RemoveColocatedRepositoryAction;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.ui.IRepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.UpdateManagerCompatibility;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.RepositoryManipulatorDropTarget;
import org.eclipse.equinox.internal.provisional.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.RepositoryContentProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class RepositoryManipulationDialog
extends TrayDialog {
    private static final int WIDTH_IN_DLUS = 480;
    private static final int HEIGHT_IN_DLUS = 240;
    protected static final String BUTTONACTION = "buttonAction";
    StructuredViewerProvisioningListener listener;
    private CheckboxTableViewer repositoryViewer;
    private IRepositoryManipulator manipulator;
    private RepositoryContentProvider contentProvider;
    private boolean changed = false;

    public RepositoryManipulationDialog(Shell shell, IRepositoryManipulator manipulator) {
        super(shell);
        this.manipulator = manipulator;
    }

    protected void configureShell(Shell shell) {
        shell.setText(ProvSDKMessages.RepositoryManipulationDialog_UpdateSitesDialogTitle);
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(ProvSDKMessages.RepositoryManipulationDialog_SelectMessage);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = this.convertHorizontalDLUsToPixels(4);
        label.setLayoutData((Object)data);
        Table table = new Table(composite, 68386);
        this.repositoryViewer = new CheckboxTableViewer(table);
        this.setTableColumns(table);
        this.contentProvider = new RepositoryContentProvider(ProvSDKUIActivator.getDefault().getQueryProvider());
        this.repositoryViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.repositoryViewer.setComparator(new ViewerComparator());
        this.repositoryViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new ProvElementLabelProvider());
        this.repositoryViewer.setInput((Object)this.getInput());
        this.setCheckState();
        this.repositoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof MetadataRepositoryElement) {
                    ((MetadataRepositoryElement)event.getElement()).setEnabled(event.getChecked());
                    RepositoryManipulationDialog.this.changed = true;
                }
            }
        });
        DropTarget target = new DropTarget(this.repositoryViewer.getControl(), 7);
        target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new RepositoryManipulatorDropTarget(this.manipulator, this.repositoryViewer.getControl()));
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = this.convertHorizontalDLUsToPixels(480);
        data.heightHint = this.convertVerticalDLUsToPixels(240);
        this.repositoryViewer.getControl().setLayoutData((Object)data);
        Composite verticalButtonBar = (Composite)this.createVerticalButtonBar(composite);
        data = new GridData(1040);
        data.verticalIndent = this.convertVerticalDLUsToPixels(25);
        verticalButtonBar.setLayoutData((Object)data);
        this.listener = this.getViewerProvisioningListener();
        ProvUI.addProvisioningListener((StructuredViewerProvisioningListener)this.listener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ProvUI.removeProvisioningListener((StructuredViewerProvisioningListener)RepositoryManipulationDialog.this.listener);
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    private Button createVerticalButton(Composite parent, String label, boolean defaultButton) {
        Shell shell;
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = this.setVerticalButtonLayoutData(button);
        data.horizontalAlignment = 4;
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManipulationDialog.this.verticalButtonPressed(event);
            }
        });
        button.setToolTipText(label);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        return button;
    }

    void verticalButtonPressed(Event event) {
        Object data = event.widget.getData(BUTTONACTION);
        if (data == null || !(data instanceof IAction)) {
            return;
        }
        IAction action = (IAction)data;
        action.runWithEvent(event);
    }

    private GridData setVerticalButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }

    private void setTableColumns(Table table) {
        table.setHeaderVisible(true);
        String[] columnHeaders = new String[]{ProvSDKMessages.RepositoryManipulationDialog_NameColumnHeader, ProvSDKMessages.RepositoryManipulationDialog_LocationColumnHeader};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setText(columnHeaders[i]);
            tc.setWidth(this.convertHorizontalDLUsToPixels(200));
            ++i;
        }
    }

    private Control createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.createVerticalButtons(composite);
        return composite;
    }

    private void createVerticalButtons(Composite parent) {
        Button button = this.createVerticalButton(parent, ProvSDKMessages.RepositoryManipulationDialog_PropertiesButton, false);
        button.setData(BUTTONACTION, (Object)new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)parent.getShell()), (ISelectionProvider)this.repositoryViewer));
        new Label(parent, 0);
        button = this.createVerticalButton(parent, ProvSDKMessages.RepositoryManipulationDialog_AddButton, false);
        button.setData(BUTTONACTION, (Object)new AddColocatedRepositoryAction((ISelectionProvider)this.repositoryViewer, this.getShell()));
        button = this.createVerticalButton(parent, ProvSDKMessages.RepositoryManipulationDialog_RemoveButton, false);
        button.setData(BUTTONACTION, (Object)new RemoveColocatedRepositoryAction((ISelectionProvider)this.repositoryViewer, this.getShell()));
        new Label(parent, 0);
        button = this.createVerticalButton(parent, ProvSDKMessages.RepositoryManipulationDialog_Import, false);
        button.setData(BUTTONACTION, (Object)new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)RepositoryManipulationDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        UpdateManagerCompatibility.importSites((Shell)4.access$0(this.this$1).getShell());
                    }
                });
            }

            static /* synthetic */ RepositoryManipulationDialog access$0(4 var0) {
                return var0.RepositoryManipulationDialog.this;
            }
        });
        button = this.createVerticalButton(parent, ProvSDKMessages.RepositoryManipulationDialog_Export, false);
        button.setData(BUTTONACTION, (Object)new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)RepositoryManipulationDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        UpdateManagerCompatibility.exportSites((Shell)6.access$0(this.this$1).getShell(), (MetadataRepositoryElement[])RepositoryManipulationDialog.access$1(6.access$0(this.this$1)));
                    }
                });
            }

            static /* synthetic */ RepositoryManipulationDialog access$0(6 var0) {
                return var0.RepositoryManipulationDialog.this;
            }
        });
    }

    private MetadataRepositories getInput() {
        MetadataRepositories input = new MetadataRepositories();
        input.setIncludeDisabledRepositories(true);
        input.setQueryProvider(ProvSDKUIActivator.getDefault().getQueryProvider());
        input.setQueryContext((QueryContext)new AvailableIUViewQueryContext(2));
        return input;
    }

    protected void okPressed() {
        if (this.changed) {
            ElementUtils.updateRepositoryUsingElements((MetadataRepositoryElement[])this.getElements(), (Shell)this.getShell());
        }
        super.okPressed();
    }

    private StructuredViewerProvisioningListener getViewerProvisioningListener() {
        return new StructuredViewerProvisioningListener((StructuredViewer)this.repositoryViewer, 1, ProvSDKUIActivator.getDefault().getQueryProvider()){

            protected void repositoryDiscovered(RepositoryEvent e) {
                this.asyncRefresh();
            }

            protected void repositoryChanged(RepositoryEvent e) {
                this.asyncRefresh();
            }

            protected void refreshAll() {
                super.refreshAll();
                RepositoryManipulationDialog.this.setCheckState();
            }
        };
    }

    private void setCheckState() {
        MetadataRepositoryElement[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            this.repositoryViewer.setChecked((Object)elements[i], elements[i].isEnabled());
            ++i;
        }
    }

    private MetadataRepositoryElement[] getElements() {
        TableItem[] items = this.repositoryViewer.getTable().getItems();
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof MetadataRepositoryElement) {
                list.add(items[i].getData());
            }
            ++i;
        }
        return list.toArray(new MetadataRepositoryElement[list.size()]);
    }

    static /* synthetic */ MetadataRepositoryElement[] access$1(RepositoryManipulationDialog repositoryManipulationDialog) {
        return repositoryManipulationDialog.getElements();
    }
}

