/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.prefs;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ProvisioningPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Group browsingGroup;
    private Group validateGroup;
    private Button showLatestRadio;
    private Button showAllRadio;
    private Button alwaysShowFailedPlan;
    private Button neverShowFailedPlan;
    private Button promptOnFailedPlan;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.browsingGroup = new Group(container, 0);
        this.browsingGroup.setText(ProvSDKMessages.ProvisioningPreferencePage_BrowsingPrefsGroup);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.browsingGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.browsingGroup.setLayoutData((Object)gd);
        this.showLatestRadio = new Button((Composite)this.browsingGroup, 16);
        this.showLatestRadio.setText(ProvSDKMessages.ProvisioningPreferencePage_ShowLatestVersions);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.showLatestRadio.setLayoutData((Object)gd);
        this.showAllRadio = new Button((Composite)this.browsingGroup, 16);
        this.showAllRadio.setText(ProvSDKMessages.ProvisioningPreferencePage_ShowAllVersions);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.showAllRadio.setLayoutData((Object)gd);
        this.validateGroup = new Group(container, 0);
        this.validateGroup.setText(ProvSDKMessages.ProvisioningPreferencePage_OpenWizardIfInvalid);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.validateGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        this.validateGroup.setLayoutData((Object)gd);
        this.alwaysShowFailedPlan = new Button((Composite)this.validateGroup, 16);
        this.alwaysShowFailedPlan.setText(ProvSDKMessages.ProvisioningPreferencePage_AlwaysOpenWizard);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.alwaysShowFailedPlan.setLayoutData((Object)gd);
        this.neverShowFailedPlan = new Button((Composite)this.validateGroup, 16);
        this.neverShowFailedPlan.setText(ProvSDKMessages.ProvisioningPreferencePage_NeverOpenWizard);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.neverShowFailedPlan.setLayoutData((Object)gd);
        this.promptOnFailedPlan = new Button((Composite)this.validateGroup, 16);
        this.promptOnFailedPlan.setText(ProvSDKMessages.ProvisioningPreferencePage_PromptToOpenWizard);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.promptOnFailedPlan.setLayoutData((Object)gd);
        this.initialize();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void initialize() {
        Preferences pref = ProvSDKUIActivator.getDefault().getPluginPreferences();
        this.showLatestRadio.setSelection(pref.getBoolean("showLatestVersion"));
        this.showAllRadio.setSelection(!pref.getBoolean("showLatestVersion"));
        String openWizard = pref.getString("allowNonOKPlan");
        this.alwaysShowFailedPlan.setSelection(openWizard.equals("always"));
        this.neverShowFailedPlan.setSelection(openWizard.equals("never"));
        this.promptOnFailedPlan.setSelection(openWizard.equals("prompt"));
    }

    protected void performDefaults() {
        super.performDefaults();
        Preferences pref = ProvSDKUIActivator.getDefault().getPluginPreferences();
        this.showLatestRadio.setSelection(pref.getDefaultBoolean("showLatestVersion"));
        this.showAllRadio.setSelection(!pref.getDefaultBoolean("showLatestVersion"));
        String openWizard = pref.getDefaultString("allowNonOKPlan");
        this.alwaysShowFailedPlan.setSelection(openWizard.equals("always"));
        this.neverShowFailedPlan.setSelection(openWizard.equals("never"));
        this.promptOnFailedPlan.setSelection(openWizard.equals("prompt"));
    }

    public boolean performOk() {
        Preferences pref = ProvSDKUIActivator.getDefault().getPluginPreferences();
        pref.setValue("showLatestVersion", this.showLatestRadio.getSelection());
        if (this.alwaysShowFailedPlan.getSelection()) {
            pref.setValue("allowNonOKPlan", "always");
        } else if (this.neverShowFailedPlan.getSelection()) {
            pref.setValue("allowNonOKPlan", "never");
        } else {
            pref.setValue("allowNonOKPlan", "prompt");
        }
        ProvSDKUIActivator.getDefault().savePluginPreferences();
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

