/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.externalFiles;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.sdk.externalFiles.ExternalFileHandler;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.DefaultMetadataURLValidator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MetadataGeneratingURLValidator
extends DefaultMetadataURLValidator {
    Shell shell;

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    protected IStatus validateRepositoryURL(URL location, boolean contactRepositories, IProgressMonitor monitor) {
        String path;
        IStatus status = super.validateRepositoryURL(location, contactRepositories, monitor);
        if (status.isOK() || status.getCode() == 3000) {
            return status;
        }
        if (this.shell == null) {
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if ((path = location.toExternalForm()).startsWith("jar:")) {
            path = path.substring("jar:".length());
        }
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        if (!path.startsWith("file:")) {
            return status;
        }
        File file = new File(path.substring("file:".length()));
        IStatus externalFileStatus = new ExternalFileHandler(file, this.shell).processFile(status);
        if (externalFileStatus.getCode() == 3001 || externalFileStatus.getCode() == 3002) {
            return Status.CANCEL_STATUS;
        }
        return externalFileStatus;
    }
}

