/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.externalFiles;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.BundleDescriptionFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.URLValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ExternalFileHandler {
    private static final String FILE = "file";
    File file;
    Shell shell;
    private static final String DROPINS_DIRECTORY = "org.eclipse.equinox.p2.reconciler.dropins.directory";
    private static final String OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    private static final String DROPINS = "dropins";
    static /* synthetic */ Class class$0;

    public ExternalFileHandler(File file, Shell shell) {
        this.file = file;
        this.shell = shell;
    }

    public IStatus processFile(IStatus originalStatus) {
        if (this.file == null) {
            return originalStatus;
        }
        if (this.isBundle()) {
            return this.autoInstallBundle(originalStatus);
        }
        if (this.isArchive()) {
            return this.generateRepoFromArchive(originalStatus);
        }
        return originalStatus;
    }

    IStatus generateRepoFromArchive(IStatus originalStatus) {
        String generateRepoFromArchive = ProvSDKUIActivator.getDefault().getPreferenceStore().getString("generateReposForArchive");
        if ("never".equals(generateRepoFromArchive)) {
            return originalStatus;
        }
        final File targetLocation = this.getDefaultUnzipFolder();
        if (targetLocation == null) {
            return originalStatus;
        }
        if ("always".equals(generateRepoFromArchive)) {
            final IMetadataRepository[] repository = new IMetadataRepository[1];
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    repository[0] = ExternalFileHandler.this.unzipAndGenerateRepository(ExternalFileHandler.this.file, targetLocation, null);
                }
            });
            if (repository[0] != null) {
                return this.generateOKStatus();
            }
            return originalStatus;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)this.shell, (String)ProvSDKMessages.ProvSDKUIActivator_Question, (String)NLS.bind((String)ProvSDKMessages.ExternalFileHandler_PromptForUnzip, (Object)this.file.getAbsolutePath()), null, (boolean)false, (IPreferenceStore)ProvSDKUIActivator.getDefault().getPreferenceStore(), (String)"generateReposForArchive");
        if (dialog.getReturnCode() == 2) {
            final IMetadataRepository[] repository = new IMetadataRepository[1];
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    repository[0] = ExternalFileHandler.this.unzipAndGenerateRepository(ExternalFileHandler.this.file, targetLocation, null);
                }
            });
            if (repository[0] != null) {
                return this.generateOKStatus();
            }
            return originalStatus;
        }
        if (dialog.getReturnCode() == 1) {
            return Status.CANCEL_STATUS;
        }
        return originalStatus;
    }

    IStatus autoInstallBundle(IStatus originalStatus) {
        try {
            String autoInstallBundle = ProvSDKUIActivator.getDefault().getPreferenceStore().getString("autoInstallBundles");
            if ("never".equals(autoInstallBundle)) {
                return originalStatus;
            }
            if ("always".equals(autoInstallBundle)) {
                if (this.copyToDropins(this.file)) {
                    return this.installOKStatus();
                }
                return originalStatus;
            }
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)this.shell, (String)ProvSDKMessages.ProvSDKUIActivator_Question, (String)NLS.bind((String)ProvSDKMessages.ExternalFileHandler_PromptForInstallBundle, (Object)this.file.getAbsolutePath()), null, (boolean)false, (IPreferenceStore)ProvSDKUIActivator.getDefault().getPreferenceStore(), (String)"autoInstallBundles");
            if (dialog.getReturnCode() == 2) {
                if (this.copyToDropins(this.file)) {
                    return this.installOKStatus();
                }
            } else if (dialog.getReturnCode() == 1) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (FileNotFoundException e) {
            ProvUI.handleException((Throwable)e, (String)NLS.bind((String)ProvSDKMessages.ExternalFileHandler_ErrorCopyingFile, (Object)this.file.getAbsolutePath()), (int)3);
        }
        catch (IOException e) {
            ProvUI.handleException((Throwable)e, (String)NLS.bind((String)ProvSDKMessages.ExternalFileHandler_ErrorCopyingFile, (Object)this.file.getAbsolutePath()), (int)3);
        }
        return originalStatus;
    }

    boolean copyToDropins(File source) throws IOException {
        File copiedBundle;
        boolean success = false;
        File dropinsFolder = this.getDropInsDirectory();
        if (!dropinsFolder.exists()) {
            dropinsFolder.mkdirs();
        }
        if (!(copiedBundle = new File(dropinsFolder, source.getName())).exists()) {
            copiedBundle.createNewFile();
        }
        boolean bl = success = FileUtils.copyStream((InputStream)new FileInputStream(this.file), (boolean)true, (OutputStream)new FileOutputStream(copiedBundle), (boolean)true) > 0;
        if (success) {
            ProvisioningOperationRunner.requestRestart((boolean)true);
        }
        return success;
    }

    IMetadataRepository unzipAndGenerateRepository(File source, File targetLocation, IProgressMonitor monitor) {
        IMetadataRepository repository = null;
        try {
            FileUtils.unzipFile((File)source, (File)targetLocation);
            URL repoLocation = new URL(URLValidator.makeFileURLString((String)targetLocation.getAbsolutePath()));
            repository = ProvisioningUtil.loadMetadataRepository((URL)repoLocation, (IProgressMonitor)monitor);
            if (repository != null) {
                ProvisioningUtil.addArtifactRepository((URL)repoLocation);
            }
        }
        catch (IOException e) {
            ProvUI.handleException((Throwable)e, (String)NLS.bind((String)ProvSDKMessages.ExternalFileHandler_ErrorExpandingArchive, (Object)source.getAbsolutePath()), (int)3);
        }
        catch (ProvisionException e) {
            ProvUI.handleException((Throwable)e, (String)NLS.bind((String)ProvSDKMessages.ExternalFileHandler_ErrorLoadingFromZipDirectory, (Object)targetLocation.getAbsolutePath()), (int)3);
        }
        return repository;
    }

    boolean isBundle() {
        if (this.file == null) {
            return false;
        }
        BundleDescriptionFactory factory = this.getBundleDescriptionFactory();
        if (factory == null) {
            return false;
        }
        return factory.getBundleDescription(this.file) != null;
    }

    private BundleDescriptionFactory getBundleDescriptionFactory() {
        ServiceReference reference;
        BundleContext bundleContext = ProvSDKUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = bundleContext.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)ProvSDKUIActivator.getContext().getService(reference);
        if (platformAdmin == null) {
            return null;
        }
        try {
            StateObjectFactory stateObjectFactory = platformAdmin.getFactory();
            BundleDescriptionFactory bundleDescriptionFactory = new BundleDescriptionFactory(stateObjectFactory, null);
            return bundleDescriptionFactory;
        }
        finally {
            ProvSDKUIActivator.getContext().ungetService(reference);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isArchive() {
        ZipInputStream zipStream;
        FileInputStream in;
        block6: {
            if (this.file == null) {
                return false;
            }
            in = null;
            zipStream = null;
            try {
                in = new FileInputStream(this.file);
                zipStream = new ZipInputStream(new BufferedInputStream(in));
                ZipEntry ze = zipStream.getNextEntry();
                if (ze != null) break block6;
                ((InputStream)in).close();
                zipStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    catch (IOException iOException) {
                    }
                }
                catch (Throwable throwable) {
                    this.safeClose(in);
                    this.safeClose(zipStream);
                    throw throwable;
                }
            }
            this.safeClose(in);
            this.safeClose(zipStream);
            return false;
        }
        this.safeClose(in);
        this.safeClose(zipStream);
        return true;
    }

    void safeClose(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    File getDefaultUnzipFolder() {
        URL configURL;
        Location location;
        File unzipFolder;
        String dropInsParent = this.getDropInsDirectory().getParent();
        if (dropInsParent != null) {
            unzipFolder = new File(dropInsParent, this.file.getName());
            if ((unzipFolder = this.makeUnusedFolder(unzipFolder)) != null) {
                return unzipFolder;
            }
        }
        if ((location = Platform.getConfigurationLocation()) != null && (configURL = location.getURL()) != null && configURL.getProtocol().startsWith(FILE)) {
            unzipFolder = new File(configURL.getFile(), this.file.getName());
            if ((unzipFolder = this.makeUnusedFolder(unzipFolder)) != null) {
                return unzipFolder;
            }
        }
        return null;
    }

    File makeUnusedFolder(File suggestedFolder) {
        if (!suggestedFolder.exists()) {
            if (suggestedFolder.mkdir()) {
                return suggestedFolder;
            }
        } else {
            File generatedPath = new File(suggestedFolder.getParent(), String.valueOf(suggestedFolder.getName()) + new Long(System.currentTimeMillis()).toString());
            if (!generatedPath.exists() && generatedPath.mkdir()) {
                return generatedPath;
            }
        }
        return null;
    }

    IStatus generateOKStatus() {
        return new Status(0, "org.eclipse.equinox.p2.ui.sdk", 3001, NLS.bind((String)ProvSDKMessages.ExternalFileHandler_RepositoryGeneratedOK, (Object)this.file.getAbsolutePath()), null);
    }

    IStatus installOKStatus() {
        return new Status(0, "org.eclipse.equinox.p2.ui.sdk", 3002, NLS.bind((String)ProvSDKMessages.ExternalFileHandler_BundleInstalledOK, (Object)this.getDropInsDirectory().getAbsolutePath()), null);
    }

    File getDropInsDirectory() {
        String watchedDirectoryProperty = ProvSDKUIActivator.getContext().getProperty(DROPINS_DIRECTORY);
        if (watchedDirectoryProperty != null) {
            File folder = new File(watchedDirectoryProperty);
            return folder;
        }
        try {
            URL baseURL = new URL(ProvSDKUIActivator.getContext().getProperty(OSGI_CONFIGURATION_AREA));
            URL folderURL = new URL(baseURL, "../dropins");
            File folder = new File(folderURL.getPath());
            return folder;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

