/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.sdk.AddColocatedRepositoryAction;
import org.eclipse.equinox.internal.p2.ui.sdk.AvailableIUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.p2.ui.sdk.RemoveColocatedRepositoryAction;
import org.eclipse.equinox.internal.p2.ui.sdk.externalFiles.MetadataGeneratingURLValidator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.ui.IRepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.PropertyDialogAction;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.RefreshAction;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.UninstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.UpdateAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.AvailableIUGroup;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.AvailableIUPatternFilter;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.IViewMenuProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.InstalledIUGroup;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.RepositoryManipulatorDropTarget;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.RevertWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.URLValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.AddColocatedRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RemoveColocatedRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policies;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.sdk.ProvPolicies;
import org.eclipse.equinox.internal.provisional.p2.ui.sdk.RepositoryManipulationDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class UpdateAndInstallDialog
extends TrayDialog
implements IViewMenuProvider {
    private static final String BUTTONACTION = "buttonAction";
    private static final int DEFAULT_HEIGHT = 240;
    private static final int DEFAULT_WIDTH = 300;
    private static final int CHAR_INDENT = 5;
    private static final int SITE_COLUMN_WIDTH_IN_DLUS = 300;
    private static final int OTHER_COLUMN_WIDTH_IN_DLUS = 200;
    private static final int VERTICAL_MARGIN_DLU = 2;
    private static final int DEFAULT_VIEW_TYPE = 2;
    private static final int INDEX_INSTALLED = 0;
    private static final int INDEX_AVAILABLE = 1;
    private static final String DIALOG_SETTINGS_SECTION = "UpdateAndInstallDialog";
    private static final String SELECTED_TAB_SETTING = "SelectedTab";
    private static final String AVAILABLE_VIEW_TYPE = "AvailableViewType";
    private static final String SHOW_LATEST_VERSIONS_ONLY = "ShowLatestVersionsOnly";
    private static final String HIDE_INSTALLED_IUS = "HideInstalledContent";
    String profileId;
    Display display;
    AvailableIUViewQueryContext queryContext;
    TabFolder tabFolder;
    AvailableIUGroup availableIUGroup;
    InstalledIUGroup installedIUGroup;
    IRepositoryManipulator repositoryManipulator;
    ChangeViewAction viewByRepo;
    ChangeViewAction viewFlat;
    ChangeViewAction viewCategory;
    Button installedPropButton;
    Button availablePropButton;
    Button installButton;
    Button uninstallButton;
    Button updateButton;
    Button revertButton;
    Button manipulateRepoButton;
    Button addRepoButton;
    Button removeRepoButton;
    Button showInstalledCheckbox;
    Button showLatestVersionsCheckbox;
    ProgressIndicator progressIndicator;
    Label progressLabel;
    IPropertyChangeListener preferenceListener;
    IJobChangeListener progressListener;
    StructuredViewerProvisioningListener profileListener;

    public UpdateAndInstallDialog(Shell shell, String profileId) {
        super(shell);
        this.display = shell != null ? shell.getDisplay() : PlatformUI.getWorkbench().getDisplay();
        this.profileId = profileId;
    }

    protected void configureShell(Shell shell) {
        shell.setText(ProvSDKMessages.UpdateAndInstallDialog_Title);
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GC gc = new GC((Drawable)comp);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)gd);
        gc.setFont(JFaceResources.getDialogFont());
        gc.dispose();
        this.createTabFolder(comp);
        IPreferenceStore store = ProvSDKUIActivator.getDefault().getPreferenceStore();
        this.preferenceListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("showLatestVersion")) {
                    UpdateAndInstallDialog.this.availableIUGroup.getStructuredViewer().refresh();
                }
            }
        };
        store.addPropertyChangeListener(this.preferenceListener);
        comp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UpdateAndInstallDialog.this.handleDispose();
            }
        });
        Link updatePrefsLink = new Link(comp, 16448);
        updatePrefsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)UpdateAndInstallDialog.this.getShell(), (String)"org.eclipse.equinox.internal.p2.ui.sdk.AutomaticUpdatesPreferencePage", null, null);
                dialog.open();
            }
        });
        updatePrefsLink.setText(ProvSDKMessages.UpdateAndInstallDialog_PrefLink);
        this.createProgressArea(comp);
        this.initializeWidgetState();
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    private void initializeWidgetState() {
        this.showInstalledCheckbox.setSelection(!this.queryContext.getHideAlreadyInstalled());
        this.showLatestVersionsCheckbox.setSelection(this.queryContext.getShowLatestVersionsOnly());
        this.updateTreeColumns();
    }

    private void createTabFolder(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertVerticalDLUsToPixels(240);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.tabFolder.setLayoutData((Object)gd);
        TabItem installedTab = new TabItem(this.tabFolder, 0);
        installedTab.setText(ProvSDKMessages.UpdateAndInstallDialog_InstalledSoftware);
        TabItem availableTab = new TabItem(this.tabFolder, 0);
        availableTab.setText(ProvSDKMessages.UpdateAndInstallDialog_AvailableSoftware);
        this.readDialogSettings();
        installedTab.setControl(this.createInstalledIUsPage((Composite)this.tabFolder));
        availableTab.setControl(this.createAvailableIUsPage((Composite)this.tabFolder));
        this.setDropTarget((Control)this.tabFolder);
    }

    private void createProgressArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gd);
        this.progressLabel = new Label(composite, 0);
        this.progressIndicator = new ProgressIndicator(composite);
        gd = new GridData(4, 4, true, false);
        this.progressIndicator.setLayoutData((Object)gd);
        this.progressListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UpdateAndInstallDialog.this.display.asyncExec(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        4.access$0(this.this$1).checkProgressIndicator(null);
                    }
                });
            }

            public void scheduled(IJobChangeEvent event) {
                UpdateAndInstallDialog.this.display.asyncExec(new Runnable(this, event){
                    final /* synthetic */ 4 this$1;
                    private final /* synthetic */ IJobChangeEvent val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = iJobChangeEvent;
                    }

                    public void run() {
                        4.access$0(this.this$1).checkProgressIndicator(this.val$event.getJob().getName());
                    }
                });
            }

            static /* synthetic */ UpdateAndInstallDialog access$0(4 var0) {
                return var0.UpdateAndInstallDialog.this;
            }
        };
        ProvisioningOperationRunner.addJobChangeListener((IJobChangeListener)this.progressListener);
        this.checkProgressIndicator(null);
    }

    void checkProgressIndicator(String jobName) {
        if (this.progressIndicator.isDisposed()) {
            return;
        }
        if (ProvisioningOperationRunner.hasScheduledOperations()) {
            this.progressIndicator.beginAnimatedTask();
            if (jobName == null) {
                this.progressLabel.setText(ProvSDKMessages.UpdateAndInstallDialog_OperationInProgress);
            } else {
                this.progressLabel.setText(NLS.bind((String)ProvSDKMessages.UpdateAndInstallDialog_NamedOperationInProgress, (Object)jobName));
            }
        } else {
            this.progressIndicator.done();
            this.progressLabel.setText("");
        }
        this.progressLabel.getParent().layout(true);
        this.validateAvailableIUButtons();
        this.validateInstalledIUButtons();
    }

    protected boolean isResizable() {
        return true;
    }

    private IRepositoryManipulator getRepositoryManipulator() {
        if (this.repositoryManipulator == null) {
            this.repositoryManipulator = new IRepositoryManipulator(){

                public String getManipulatorLabel() {
                    return ProvSDKMessages.UpdateAndInstallDialog_ManageSites;
                }

                public boolean manipulateRepositories(Shell shell) {
                    new RepositoryManipulationDialog(shell, this).open();
                    return true;
                }

                public ProvisioningOperation getAddOperation(URL repoURL) {
                    return new AddColocatedRepositoryOperation(this.getAddOperationLabel(), repoURL);
                }

                public String getAddOperationLabel() {
                    return ProvSDKMessages.UpdateAndInstallDialog_AddSiteOperationlabel;
                }

                public URL[] getKnownRepositories() {
                    try {
                        return ProvisioningUtil.getMetadataRepositories((int)0);
                    }
                    catch (ProvisionException provisionException) {
                        return new URL[0];
                    }
                }

                public ProvisioningOperation getRemoveOperation(URL[] reposToRemove) {
                    return new RemoveColocatedRepositoryOperation(this.getRemoveOperationLabel(), reposToRemove);
                }

                public String getRemoveOperationLabel() {
                    return ProvSDKMessages.UpdateAndInstallDialog_RemoveSiteOperationLabel;
                }

                public URLValidator getURLValidator(Shell shell) {
                    MetadataGeneratingURLValidator validator = new MetadataGeneratingURLValidator();
                    validator.setShell(shell);
                    return validator;
                }
            };
        }
        return this.repositoryManipulator;
    }

    private Control createAvailableIUsPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        this.setDropTarget((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = this.convertVerticalDLUsToPixels(2);
        composite.setLayout((Layout)layout);
        this.availableIUGroup = new AvailableIUGroup(composite, ProvSDKUIActivator.getDefault().getQueryProvider(), JFaceResources.getDialogFont(), new ProvisioningContext(), (QueryContext)this.queryContext, new AvailableIUPatternFilter(ProvUI.getIUColumnConfig()), ProvUI.getIUColumnConfig(), (IViewMenuProvider)this, true);
        Composite vButtonBar = (Composite)this.createAvailableIUsVerticalButtonBar(composite);
        GridData data = new GridData(1040);
        data.verticalIndent = this.convertVerticalDLUsToPixels(25);
        vButtonBar.setLayoutData((Object)data);
        this.availableIUGroup.getStructuredViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UpdateAndInstallDialog.this.validateAvailableIUButtons();
            }
        });
        this.availableIUGroup.getCheckMappingSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UpdateAndInstallDialog.this.validateAvailableIUButtons();
            }
        });
        this.profileListener = new StructuredViewerProvisioningListener(this.availableIUGroup.getStructuredViewer(), 4, ProvSDKUIActivator.getDefault().getQueryProvider()){

            protected void profileAdded(String id) {
            }

            protected void profileRemoved(String id) {
            }

            protected void profileChanged(String id) {
                if (id.equals(UpdateAndInstallDialog.this.profileId)) {
                    UpdateAndInstallDialog.this.display.asyncExec(new Runnable(this){
                        final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (10.access$0(this.this$1)) {
                                return;
                            }
                            if (!10.access$2(this.this$1).showInstalledCheckbox.getSelection()) {
                                10.access$1(this.this$1);
                            }
                        }
                    });
                }
            }

            static /* synthetic */ boolean access$0(10 var0) {
                return var0.isClosing();
            }

            static /* synthetic */ void access$1(10 var0) {
                var0.refreshAll();
            }

            static /* synthetic */ UpdateAndInstallDialog access$2(10 var0) {
                return var0.UpdateAndInstallDialog.this;
            }
        };
        ProvUI.addProvisioningListener((StructuredViewerProvisioningListener)this.profileListener);
        this.availableIUGroup.setUseBoldFontForFilteredItems(this.queryContext.getViewType() != 3);
        this.setDropTarget(this.availableIUGroup.getStructuredViewer().getControl());
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = this.convertWidthInCharsToPixels(5);
        gd.verticalIndent = this.convertVerticalDLUsToPixels(2);
        this.showLatestVersionsCheckbox = new Button(composite, 32);
        this.showLatestVersionsCheckbox.setText(ProvSDKMessages.UpdateAndInstallDialog_ShowLatestVersionsOnly);
        this.showLatestVersionsCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                UpdateAndInstallDialog.this.updateAvailableViewState();
            }

            public void widgetSelected(SelectionEvent e) {
                UpdateAndInstallDialog.this.updateAvailableViewState();
            }
        });
        this.showLatestVersionsCheckbox.setLayoutData((Object)gd);
        this.showInstalledCheckbox = new Button(composite, 32);
        this.showInstalledCheckbox.setText(ProvSDKMessages.UpdateAndInstallDialog_ShowAlreadyInstalledItems);
        this.showInstalledCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                UpdateAndInstallDialog.this.updateAvailableViewState();
            }

            public void widgetSelected(SelectionEvent e) {
                UpdateAndInstallDialog.this.updateAvailableViewState();
            }
        });
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = this.convertWidthInCharsToPixels(5);
        this.showInstalledCheckbox.setLayoutData((Object)gd);
        this.validateAvailableIUButtons();
        return composite;
    }

    public void fillViewMenu(IMenuManager viewMenu) {
        this.viewByRepo = new ChangeViewAction(ProvSDKMessages.UpdateAndInstallDialog_ViewBySite, 2);
        viewMenu.add((IAction)this.viewByRepo);
        this.viewCategory = new ChangeViewAction(ProvSDKMessages.UpdateAndInstallDialog_ViewByCategory, 1);
        viewMenu.add((IAction)this.viewCategory);
        this.viewFlat = new ChangeViewAction(ProvSDKMessages.UpdateAndInstallDialog_ViewByName, 3);
        viewMenu.add((IAction)this.viewFlat);
    }

    private Control createAvailableIUsVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        InstallAction installAction = new InstallAction(this.availableIUGroup.getCheckMappingSelectionProvider(), this.profileId, null, (Policies)ProvPolicies.getDefault(), this.getShell());
        this.installButton = this.createVerticalButton(composite, (IAction)installAction, false);
        PropertyDialogAction propertiesAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)parent.getShell()), (ISelectionProvider)this.availableIUGroup.getStructuredViewer());
        propertiesAction.setText(ProvSDKMessages.UpdateAndInstallDialog_Properties);
        this.availablePropButton = this.createVerticalButton(composite, (IAction)propertiesAction, false);
        new Label(composite, 0);
        RefreshAction refreshAction = new RefreshAction((ISelectionProvider)this.availableIUGroup.getStructuredViewer(), this.availableIUGroup.getStructuredViewer().getControl()){

            protected void refresh() {
                UpdateAndInstallDialog.this.availableIUGroup.refresh();
            }
        };
        refreshAction.setToolTipText(ProvSDKMessages.UpdateAndInstallDialog_RefreshTooltip);
        this.createVerticalButton(composite, (IAction)refreshAction, false);
        new Label(composite, 0);
        Action manipulateRepos = new Action(){

            public void runWithEvent(Event event) {
                UpdateAndInstallDialog.this.getRepositoryManipulator().manipulateRepositories(UpdateAndInstallDialog.this.getShell());
            }
        };
        manipulateRepos.setText(ProvSDKMessages.UpdateAndInstallDialog_ManageSites);
        manipulateRepos.setToolTipText(ProvSDKMessages.UpdateAndInstallDialog_ManageSitesTooltip);
        this.manipulateRepoButton = this.createVerticalButton(composite, (IAction)manipulateRepos, false);
        AddColocatedRepositoryAction addSites = new AddColocatedRepositoryAction((ISelectionProvider)this.availableIUGroup.getStructuredViewer(), this.getShell());
        addSites.setText(ProvSDKMessages.UpdateAndInstallDialog_AddSiteButtonText);
        this.addRepoButton = this.createVerticalButton(composite, (IAction)addSites, false);
        RemoveColocatedRepositoryAction removeSites = new RemoveColocatedRepositoryAction((ISelectionProvider)this.availableIUGroup.getStructuredViewer(), this.getShell());
        this.removeRepoButton = this.createVerticalButton(composite, (IAction)removeSites, false);
        this.createMenu(this.availableIUGroup.getStructuredViewer().getControl(), new IAction[]{installAction, propertiesAction, refreshAction});
        return composite;
    }

    void updateAvailableViewState() {
        if (this.availableIUGroup.getTree() == null || this.availableIUGroup.getTree().isDisposed()) {
            return;
        }
        final Composite parent = this.availableIUGroup.getComposite().getParent();
        this.validateAvailableIUButtons();
        this.availableIUGroup.setUseBoldFontForFilteredItems(this.queryContext.getViewType() != 3);
        BusyIndicator.showWhile((Display)this.display, (Runnable)new Runnable(){

            public void run() {
                parent.setRedraw(false);
                UpdateAndInstallDialog.this.updateTreeColumns();
                UpdateAndInstallDialog.this.queryContext.setShowLatestVersionsOnly(UpdateAndInstallDialog.this.showLatestVersionsCheckbox.getSelection());
                if (UpdateAndInstallDialog.this.showInstalledCheckbox.getSelection()) {
                    UpdateAndInstallDialog.this.queryContext.showAlreadyInstalled();
                } else {
                    UpdateAndInstallDialog.this.queryContext.hideAlreadyInstalled(UpdateAndInstallDialog.this.profileId);
                }
                UpdateAndInstallDialog.this.availableIUGroup.setQueryContext((QueryContext)UpdateAndInstallDialog.this.queryContext);
                parent.layout(true);
                parent.setRedraw(true);
            }
        });
    }

    void updateTreeColumns() {
        if (this.availableIUGroup.getTree() == null || this.availableIUGroup.getTree().isDisposed()) {
            return;
        }
        TreeColumn[] columns = this.availableIUGroup.getTree().getColumns();
        if (columns.length > 0) {
            columns[0].setWidth(this.convertHorizontalDLUsToPixels(this.queryContext.getViewType() == 2 ? 300 : 200));
        }
    }

    void validateAvailableIUButtons() {
        this.updateEnablement(this.installButton);
        this.updateEnablement(this.availablePropButton);
        this.updateEnablement(this.manipulateRepoButton);
        this.updateEnablement(this.addRepoButton);
        this.updateEnablement(this.removeRepoButton);
        boolean showRepos = this.queryContext.getViewType() == 2;
        this.addRepoButton.setVisible(showRepos);
        this.removeRepoButton.setVisible(showRepos);
    }

    private Control createInstalledIUsPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.installedIUGroup = new InstalledIUGroup(composite, ProvSDKUIActivator.getDefault().getQueryProvider(), JFaceResources.getDialogFont(), new ProvisioningContext(), this.profileId);
        Composite vButtonBar = (Composite)this.createInstalledIUsVerticalButtonBar(composite, ProvSDKUIActivator.getDefault().getQueryProvider());
        GridData data = new GridData(1040);
        data.verticalIndent = this.convertVerticalDLUsToPixels(25);
        vButtonBar.setLayoutData((Object)data);
        this.installedIUGroup.getStructuredViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UpdateAndInstallDialog.this.validateInstalledIUButtons();
            }
        });
        this.setDropTarget(this.installedIUGroup.getStructuredViewer().getControl());
        this.validateInstalledIUButtons();
        return composite;
    }

    private Control createInstalledIUsVerticalButtonBar(Composite parent, IQueryProvider queryProvider) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        UpdateAction updateAction = new UpdateAction(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                UpdateAndInstallDialog.this.installedIUGroup.getStructuredViewer().addSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                StructuredViewer viewer = UpdateAndInstallDialog.this.installedIUGroup.getStructuredViewer();
                ISelection selection = viewer.getSelection();
                if (selection.isEmpty()) {
                    Object[] all = ((IStructuredContentProvider)UpdateAndInstallDialog.this.installedIUGroup.getStructuredViewer().getContentProvider()).getElements(viewer.getInput());
                    return new StructuredSelection(all);
                }
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                UpdateAndInstallDialog.this.installedIUGroup.getStructuredViewer().removeSelectionChangedListener(listener);
            }

            public void setSelection(ISelection selection) {
                UpdateAndInstallDialog.this.installedIUGroup.getStructuredViewer().setSelection(selection);
            }
        }, this.profileId, null, (Policies)ProvPolicies.getDefault(), parent.getShell());
        this.updateButton = this.createVerticalButton(composite, (IAction)updateAction, false);
        UninstallAction uninstallAction = new UninstallAction((ISelectionProvider)this.installedIUGroup.getStructuredViewer(), this.profileId, null, (Policies)ProvPolicies.getDefault(), parent.getShell());
        this.uninstallButton = this.createVerticalButton(composite, (IAction)uninstallAction, false);
        PropertyDialogAction propertiesAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)parent.getShell()), (ISelectionProvider)this.installedIUGroup.getStructuredViewer());
        propertiesAction.setText(ProvSDKMessages.UpdateAndInstallDialog_Properties);
        this.installedPropButton = this.createVerticalButton(composite, (IAction)propertiesAction, false);
        new Label(composite, 0);
        Action revertAction = new Action(){

            public void run() {
                RevertWizard wizard = new RevertWizard(UpdateAndInstallDialog.this.profileId, ProvSDKUIActivator.getDefault().getQueryProvider());
                WizardDialog dialog = new WizardDialog(UpdateAndInstallDialog.this.getShell(), (IWizard)wizard);
                dialog.create();
                dialog.getShell().setSize(600, 500);
                dialog.open();
            }
        };
        revertAction.setText(ProvSDKMessages.UpdateAndInstallDialog_RevertActionLabel);
        revertAction.setToolTipText(ProvSDKMessages.UpdateAndInstallDialog_RevertTooltip);
        this.revertButton = this.createVerticalButton(composite, (IAction)revertAction, false);
        this.createMenu(this.installedIUGroup.getStructuredViewer().getControl(), new IAction[]{updateAction, uninstallAction, propertiesAction});
        return composite;
    }

    private void createMenu(Control control, IAction[] actions) {
        MenuManager menuManager = new MenuManager();
        int i = 0;
        while (i < actions.length) {
            menuManager.add(actions[i]);
            ++i;
        }
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    void validateInstalledIUButtons() {
        this.updateEnablement(this.installedPropButton);
        this.updateEnablement(this.uninstallButton);
        this.updateEnablement(this.updateButton);
        this.revertButton.setEnabled(!ProvisioningOperationRunner.hasScheduledOperationsFor((String)this.profileId));
    }

    private void updateEnablement(Button button) {
        IAction action = this.getButtonAction((Widget)button);
        if (action != null) {
            if (action instanceof ProvisioningAction) {
                ((ProvisioningAction)action).checkEnablement();
            }
            button.setEnabled(action.isEnabled());
        }
    }

    private Button createVerticalButton(Composite parent, IAction action, boolean defaultButton) {
        Shell shell;
        Button button = new Button(parent, 8);
        button.setText(action.getText());
        this.setButtonLayoutData(button);
        Object data = button.getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).horizontalAlignment = 4;
        }
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UpdateAndInstallDialog.this.verticalButtonPressed(event);
            }
        });
        button.setToolTipText(action.getToolTipText());
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        button.setData(BUTTONACTION, (Object)action);
        return button;
    }

    void verticalButtonPressed(Event event) {
        IAction action = this.getButtonAction(event.widget);
        if (action != null) {
            action.runWithEvent(event);
        }
    }

    private IAction getButtonAction(Widget widget) {
        Object data = widget.getData(BUTTONACTION);
        if (data == null || !(data instanceof IAction)) {
            return null;
        }
        return (IAction)data;
    }

    private void readDialogSettings() {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        this.queryContext = new AvailableIUViewQueryContext(2);
        IPreferenceStore store = ProvSDKUIActivator.getDefault().getPreferenceStore();
        this.queryContext.setShowLatestVersionsOnly(store.getBoolean("showLatestVersion"));
        this.queryContext.hideAlreadyInstalled(this.profileId);
        IDialogSettings settings = ProvSDKUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section != null) {
            boolean hideContent;
            int tab = 0;
            if (section.get(SELECTED_TAB_SETTING) != null) {
                tab = section.getInt(SELECTED_TAB_SETTING);
            }
            this.tabFolder.setSelection(tab);
            try {
                if (section.get(AVAILABLE_VIEW_TYPE) != null) {
                    this.queryContext.setViewType(section.getInt(AVAILABLE_VIEW_TYPE));
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (section.get(SHOW_LATEST_VERSIONS_ONLY) != null) {
                this.queryContext.setShowLatestVersionsOnly(section.getBoolean(SHOW_LATEST_VERSIONS_ONLY));
            }
            if (hideContent = section.getBoolean(HIDE_INSTALLED_IUS)) {
                this.queryContext.hideAlreadyInstalled(this.profileId);
            } else {
                this.queryContext.showAlreadyInstalled();
            }
        }
    }

    private void saveDialogSettings() {
        if (!this.tabFolder.isDisposed()) {
            this.getDialogBoundsSettings().put(SELECTED_TAB_SETTING, this.tabFolder.getSelectionIndex());
            this.getDialogBoundsSettings().put(AVAILABLE_VIEW_TYPE, this.queryContext.getViewType());
            this.getDialogBoundsSettings().put(SHOW_LATEST_VERSIONS_ONLY, this.showLatestVersionsCheckbox.getSelection());
            this.getDialogBoundsSettings().put(HIDE_INSTALLED_IUS, !this.showInstalledCheckbox.getSelection());
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = ProvSDKUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.saveDialogSettings();
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    private void setDropTarget(Control control) {
        DropTarget target = new DropTarget(control, 7);
        target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new RepositoryManipulatorDropTarget(this.getRepositoryManipulator(), control){

            protected boolean dropTargetIsValid(DropTargetEvent event) {
                if (URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String path;
                    if (UpdateAndInstallDialog.this.tabFolder.getSelectionIndex() == 1) {
                        return super.dropTargetIsValid(event);
                    }
                    if (UpdateAndInstallDialog.this.tabFolder.getItem(1) == event.item) {
                        return super.dropTargetIsValid(event);
                    }
                    if (UpdateAndInstallDialog.this.tabFolder.getSelectionIndex() == 0 && (path = (String)URLTransfer.getInstance().nativeToJava(event.currentDataType)) != null) {
                        URL url = null;
                        try {
                            url = new URL(path);
                        }
                        catch (MalformedURLException malformedURLException) {
                            return false;
                        }
                        if (url != null && URLValidator.isFileURL((URL)url)) {
                            return true;
                        }
                    }
                }
                return super.dropTargetIsValid(event);
            }
        });
    }

    void handleDispose() {
        if (this.preferenceListener != null) {
            ProvSDKUIActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
            this.preferenceListener = null;
        }
        if (this.progressListener != null) {
            ProvisioningOperationRunner.removeJobChangeListener((IJobChangeListener)this.progressListener);
            this.progressListener = null;
        }
        if (this.profileListener != null) {
            ProvUI.removeProvisioningListener((StructuredViewerProvisioningListener)this.profileListener);
            this.profileListener = null;
        }
    }

    private class ChangeViewAction
    extends Action {
        int viewType;

        ChangeViewAction(String text, int viewType) {
            super(text, 8);
            this.viewType = viewType;
            this.setChecked(this.viewType == UpdateAndInstallDialog.this.queryContext.getViewType());
        }

        public void run() {
            if (this.viewType != UpdateAndInstallDialog.this.queryContext.getViewType()) {
                UpdateAndInstallDialog.this.queryContext.setViewType(this.viewType);
                UpdateAndInstallDialog.this.updateAvailableViewState();
            }
        }
    }
}

