/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;

public class ProcessTaskManager
implements Runnable {
    Compiler compiler;
    private int unitIndex;
    private Thread processingThread;
    volatile int currentIndex;
    volatile int availableIndex;
    volatile int size;
    volatile int sleepCount;
    CompilationUnitDeclaration[] units;
    public static int PROCESSED_QUEUE_SIZE = 12;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessTaskManager(Compiler compiler) {
        this.compiler = compiler;
        this.unitIndex = 0;
        this.currentIndex = 0;
        this.availableIndex = 0;
        this.size = PROCESSED_QUEUE_SIZE;
        this.sleepCount = 0;
        this.units = new CompilationUnitDeclaration[this.size];
        ProcessTaskManager processTaskManager = this;
        synchronized (processTaskManager) {
            this.processingThread = new Thread((Runnable)this, "Compiler Processing Task");
            this.processingThread.setDaemon(true);
            this.processingThread.start();
        }
    }

    private synchronized void addNextUnit(CompilationUnitDeclaration newElement) {
        while (this.units[this.availableIndex] != null) {
            this.sleepCount = 1;
            try {
                this.wait(250L);
            }
            catch (InterruptedException interruptedException) {}
            this.sleepCount = 0;
        }
        this.units[this.availableIndex++] = newElement;
        if (this.availableIndex >= this.size) {
            this.availableIndex = 0;
        }
        if (this.sleepCount <= -1) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnitDeclaration removeNextUnit() {
        CompilationUnitDeclaration next = null;
        boolean yield = false;
        ProcessTaskManager processTaskManager = this;
        synchronized (processTaskManager) {
            next = this.units[this.currentIndex];
            if (next == null) {
                do {
                    if (this.processingThread == null) {
                        return null;
                    }
                    this.sleepCount = -1;
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.sleepCount = 0;
                } while ((next = this.units[this.currentIndex]) == null);
            }
            this.units[this.currentIndex++] = null;
            if (this.currentIndex >= this.size) {
                this.currentIndex = 0;
            }
            if (this.sleepCount >= 1 && ++this.sleepCount > 4) {
                this.notify();
                yield = this.sleepCount > 8;
            }
        }
        if (yield) {
            Thread.yield();
        }
        return next;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            Thread t = null;
            ProcessTaskManager processTaskManager = this;
            synchronized (processTaskManager) {
                if (this.processingThread != null) {
                    t = this.processingThread;
                    this.processingThread = null;
                    this.notifyAll();
                }
            }
            if (t != null) {
                t.join(250L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }
}

