/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;

public final class CompletionContext
extends InternalCompletionContext {
    public static final int TL_MEMBER_START = 1;
    public static final int TL_STATEMENT_START = 2;
    public static final int TOKEN_KIND_UNKNOWN = 0;
    public static final int TOKEN_KIND_NAME = 1;
    public static final int TOKEN_KIND_STRING_LITERAL = 2;

    public boolean isInJavadoc() {
        return this.javadoc != 0;
    }

    public boolean isInJavadocText() {
        return (this.javadoc & 4) != 0;
    }

    public boolean isInJavadocFormalReference() {
        return (this.javadoc & 0x40) != 0;
    }

    public boolean isExtended() {
        return this.extendedContext != null;
    }

    public char[][] getExpectedTypesSignatures() {
        return this.expectedTypesSignatures;
    }

    public char[][] getExpectedTypesKeys() {
        return this.expectedTypesKeys;
    }

    public char[] getToken() {
        return this.token;
    }

    public int getTokenKind() {
        return this.tokenKind;
    }

    public int getTokenLocation() {
        return this.tokenLocation;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public int getOffset() {
        return this.offset;
    }

    public IJavaElement getEnclosingElement() {
        if (!this.isExtended()) {
            throw new UnsupportedOperationException("Operation only supported in extended context");
        }
        if (this.extendedContext == null) {
            return null;
        }
        return this.extendedContext.getEnclosingElement();
    }

    public IJavaElement[] getVisibleElements(String typeSignature) {
        if (!this.isExtended()) {
            throw new UnsupportedOperationException("Operation only supported in extended context");
        }
        if (this.extendedContext == null) {
            return new IJavaElement[0];
        }
        return this.extendedContext.getVisibleElements(typeSignature);
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("completion offset=");
        buffer.append(this.offset);
        buffer.append('\n');
        buffer.append("completion range=[");
        buffer.append(this.tokenStart);
        buffer.append(", ");
        buffer.append(this.tokenEnd);
        buffer.append("]\n");
        buffer.append("completion token=");
        String string = "null";
        if (this.token == null) {
            buffer.append(string);
        } else {
            buffer.append('\"');
            buffer.append(this.token);
            buffer.append('\"');
        }
        buffer.append('\n');
        buffer.append("expectedTypesSignatures=");
        if (this.expectedTypesSignatures == null) {
            buffer.append(string);
        } else {
            buffer.append('{');
            i = 0;
            while (i < this.expectedTypesSignatures.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.expectedTypesSignatures[i]);
                ++i;
            }
            buffer.append('}');
        }
        buffer.append('\n');
        buffer.append("expectedTypesKeys=");
        if (this.expectedTypesSignatures == null) {
            buffer.append(string);
        } else {
            buffer.append('{');
            i = 0;
            while (i < this.expectedTypesKeys.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.expectedTypesKeys[i]);
                ++i;
            }
            buffer.append('}');
        }
        buffer.append('\n');
        if (this.tokenLocation == 0) {
            buffer.append("tokenLocation=UNKNOWN");
        } else {
            buffer.append("tokenLocation={");
            boolean first = true;
            if ((this.tokenLocation & 1) != 0) {
                if (!first) {
                    buffer.append(',');
                }
                buffer.append("MEMBER_START");
                first = false;
            }
            if ((this.tokenLocation & 2) != 0) {
                if (!first) {
                    buffer.append(',');
                }
                buffer.append("STATEMENT_START");
                first = false;
            }
            buffer.append('}');
        }
        buffer.append('\n');
        return buffer.toString();
    }
}

