/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.IInstrumentation;
import com.mountainminds.eclemma.core.analysis.IJavaModelCoverage;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.analysis.ITypeVisitor;
import com.mountainminds.eclemma.internal.core.analysis.JavaElementCoverage;
import com.mountainminds.eclemma.internal.core.analysis.JavaModelCoverage;
import com.mountainminds.eclemma.internal.core.analysis.TypeCoverage;
import com.mountainminds.eclemma.internal.core.analysis.TypeTraverser;
import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.MethodDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.util.NLS;

public class SessionAnalyzer {
    private static final DebugOptions.ITracer TRACER = DebugOptions.ANALYSISTRACER;
    private static final DebugOptions.ITracer PERFORMANCE = DebugOptions.PERFORMANCETRACER;
    private JavaModelCoverage modelcoverage;

    public IJavaModelCoverage processSession(ICoverageSession session, IProgressMonitor monitor) throws CoreException {
        PERFORMANCE.startTimer();
        PERFORMANCE.startMemoryUsage();
        this.modelcoverage = new JavaModelCoverage();
        IPath[] coveragefiles = session.getCoverageDataFiles();
        IInstrumentation[] instrumentations = session.getInstrumentations();
        monitor.beginTask(NLS.bind((String)CoreMessages.AnalyzingCoverageSession_task, (Object)session.getDescription()), coveragefiles.length + instrumentations.length);
        ICoverageData coveragedata = null;
        int i = 0;
        while (i < coveragefiles.length && !monitor.isCanceled()) {
            coveragedata = this.processCoveragedataFile(coveragedata, coveragefiles[i]);
            monitor.worked(1);
            ++i;
        }
        i = 0;
        while (i < instrumentations.length && !monitor.isCanceled()) {
            this.processMetadataFile(coveragedata, instrumentations[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
        monitor.done();
        PERFORMANCE.stopTimer("loading " + session.getDescription());
        PERFORMANCE.stopMemoryUsage("loading " + session.getDescription());
        return this.modelcoverage;
    }

    private ICoverageData processCoveragedataFile(ICoverageData coveragedata, IPath path) throws CoreException {
        try {
            File f = path.toFile();
            if (f.exists()) {
                IMergeable data = DataFactory.load((File)f)[1];
                coveragedata = coveragedata == null ? (ICoverageData)data : (ICoverageData)coveragedata.merge(data);
            }
            return coveragedata;
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.COVERAGEDATA_FILE_READ_ERROR.getStatus(path, e));
        }
    }

    private void processMetadataFile(ICoverageData coveragedata, IInstrumentation instrumentation, IProgressMonitor monitor) throws CoreException {
        IPath metadatafile = instrumentation.getMetaDataFile();
        File f = metadatafile.toFile();
        if (f.exists()) {
            IMetaData metadata;
            try {
                metadata = (IMetaData)DataFactory.load((File)f)[0];
            }
            catch (IOException e) {
                throw new CoreException(EclEmmaStatus.METADATA_FILE_READ_ERROR.getStatus(metadatafile, e));
            }
            IPackageFragmentRoot[] roots = instrumentation.getClassFiles().getPackageFragmentRoots();
            TypeTraverser jep = new TypeTraverser(roots);
            jep.process(new TypeVisitor(metadata, coveragedata), monitor);
        }
    }

    private boolean isMethodCovered(boolean[] blocks) {
        int i = 0;
        while (blocks != null && i < blocks.length) {
            if (blocks[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private TypeCoverage.UnboundMethodCoverage processMethodCoverage(MethodDescriptor descriptor, boolean[] covered, JavaElementCoverage parentcoverage, IResource resource) {
        JavaElementCoverage coverage = new JavaElementCoverage(parentcoverage, descriptor.hasLineNumberInfo(), resource);
        coverage.addMethod(this.isMethodCovered(covered));
        int[] blocksizes = descriptor.getBlockSizes();
        if (blocksizes != null) {
            int blockcount = blocksizes.length;
            int[][] blocklines = descriptor.getBlockMap();
            int i = 0;
            while (i < blockcount) {
                coverage.addBlock(blocksizes[i], blocklines == null ? null : blocklines[i], covered == null ? false : covered[i]);
                ++i;
            }
        }
        return new TypeCoverage.UnboundMethodCoverage(descriptor.getName(), descriptor.getDescriptor(), coverage);
    }

    private JavaElementCoverage getCoverage(IJavaElement element, boolean haslines) {
        if (element == null) {
            return null;
        }
        JavaElementCoverage c = (JavaElementCoverage)this.modelcoverage.getCoverageFor(element);
        if (c == null) {
            switch (element.getElementType()) {
                case 1: {
                    c = this.modelcoverage;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    c = new JavaElementCoverage(this.getCoverage(element.getParent(), false), false, element.getResource());
                    break;
                }
                case 7: {
                    c = new TypeCoverage(this.getCoverage(element.getParent(), haslines), haslines, element.getResource());
                    break;
                }
                default: {
                    c = new JavaElementCoverage(this.getCoverage(element.getParent(), haslines), haslines, element.getResource());
                }
            }
            this.modelcoverage.put(element, c);
        }
        return c;
    }

    private class TypeVisitor
    implements ITypeVisitor {
        private final ICoverageData coveragedata;
        private final Map descriptors;

        TypeVisitor(IMetaData metadata, ICoverageData coveragedata) {
            this.coveragedata = coveragedata;
            this.descriptors = new HashMap();
            Iterator i = metadata.iterator();
            while (i.hasNext()) {
                ClassDescriptor cd = (ClassDescriptor)i.next();
                this.descriptors.put(cd.getClassVMName(), cd);
            }
        }

        public void visit(IType type, String vmname) {
            ClassDescriptor descriptor = (ClassDescriptor)this.descriptors.remove(vmname);
            if (descriptor != null) {
                ICoverageData.DataHolder data;
                ICoverageData.DataHolder dataHolder = data = this.coveragedata == null ? null : this.coveragedata.getCoverage(descriptor);
                if (data != null && data.m_stamp != descriptor.getStamp()) {
                    TRACER.trace("Invalid meta data signature for {0}.", descriptor.getClassVMName());
                } else {
                    TypeCoverage typecoverage = (TypeCoverage)SessionAnalyzer.this.getCoverage((IJavaElement)type, descriptor.hasCompleteLineNumberInfo());
                    IResource resource = type.getResource();
                    typecoverage.addType(data != null);
                    MethodDescriptor[] methods = descriptor.getMethods();
                    TypeCoverage.UnboundMethodCoverage[] ubcoverage = new TypeCoverage.UnboundMethodCoverage[methods.length];
                    boolean[][] covered = data == null ? null : data.m_coverage;
                    int i = 0;
                    while (i < methods.length) {
                        ubcoverage[i] = SessionAnalyzer.this.processMethodCoverage(methods[i], covered == null ? null : covered[i], typecoverage, resource);
                        ++i;
                    }
                    typecoverage.setUnboundMethods(ubcoverage);
                }
            }
        }

        public void done() {
            Iterator i = this.descriptors.keySet().iterator();
            while (i.hasNext()) {
                TRACER.trace("Instrumented type {0} has not been processed.", i.next());
            }
        }
    }
}

