/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.ui.launching;

import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class CoverageLaunchShortcut
implements ILaunchShortcut,
IExecutableExtension {
    private String delegateId;
    private ILaunchShortcut delegate;

    private ILaunchShortcut getDelegate() {
        if (this.delegate == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(IDebugUIConstants.PLUGIN_ID, "launchShortcuts");
            IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < configs.length) {
                if (this.delegateId.equals(configs[i].getAttribute("id"))) {
                    try {
                        this.delegate = (ILaunchShortcut)configs[i].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        EclEmmaUIPlugin.log(e);
                    }
                    break;
                }
                ++i;
            }
            if (this.delegate == null) {
                String msg = "ILaunchShortcut declaration not found: " + this.delegateId;
                EclEmmaUIPlugin.getInstance().getLog().log(EclEmmaUIPlugin.errorStatus(msg, null));
            }
        }
        return this.delegate;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.delegateId = String.valueOf(data);
    }

    public void launch(ISelection selection, String mode) {
        ILaunchShortcut delegate = this.getDelegate();
        if (delegate != null) {
            delegate.launch(selection, "coverage");
        }
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchShortcut delegate = this.getDelegate();
        if (delegate != null) {
            delegate.launch(editor, "coverage");
        }
    }
}

