/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.wizards;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.internal.ui.ContextHelp;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.viewers.ClassesViewer;
import com.mountainminds.eclemma.internal.ui.wizards.ComboHistory;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SessionImportPage1
extends WizardPage {
    private static final String ID = "SessionImportPage1";
    private static final String STORE_PREFIX = "SessionImportPage1.";
    private static final String STORE_FILES = "SessionImportPage1.files";
    private static final String STORE_CLASSES = "SessionImportPage1.classes";
    private static final String STORE_BINARIES = "SessionImportPage1.binaries";
    private static final String STORE_COPY = "SessionImportPage1.copy";
    private static final String STORE_IMPORTMETADATA = "SessionImportPage1.importmetadata";
    private Text descriptiontext;
    private Combo filecombo;
    private ClassesViewer classesviewer;
    private Button binariescheck;
    private Button referenceradio;
    private Button copyradio;
    private Button ideclassesradio;
    private Button importmetadataradio;

    protected SessionImportPage1() {
        super(ID);
        this.setTitle(UIMessages.ImportSessionPage1_title);
        this.setDescription(UIMessages.ImportSessionPage1_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(4, false));
        new Label(parent, 0).setText(UIMessages.ImportSessionPage1Description_label);
        this.descriptiontext = new Text(parent, 2048);
        this.descriptiontext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionImportPage1.this.update();
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.descriptiontext.setLayoutData((Object)gd);
        new Label(parent, 0).setText(UIMessages.ImportSessionPage1CoverageFile_label);
        this.filecombo = new Combo(parent, 2048);
        this.filecombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionImportPage1.this.update();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertHorizontalDLUsToPixels(100);
        this.filecombo.setLayoutData((Object)gd);
        Button browsebutton = new Button(parent, 0);
        browsebutton.setText(UIMessages.BrowseAction_label);
        this.setButtonLayoutData(browsebutton);
        browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage1.this.openBrowseDialog();
            }
        });
        this.classesviewer = new ClassesViewer(parent, 2048);
        try {
            this.classesviewer.setInput(CoverageTools.getClassFiles());
        }
        catch (CoreException e) {
            EclEmmaUIPlugin.log(e);
        }
        this.classesviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SessionImportPage1.this.update();
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 4;
        gd.widthHint = this.convertHorizontalDLUsToPixels(120);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.classesviewer.getTable().setLayoutData((Object)gd);
        this.binariescheck = new Button(parent, 32);
        this.binariescheck.setText(UIMessages.ImportSessionPage1Binaries_label);
        this.binariescheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage1.this.classesviewer.setIncludeBinaries(SessionImportPage1.this.binariescheck.getSelection());
                SessionImportPage1.this.update();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 4;
        this.binariescheck.setLayoutData((Object)gd);
        Group group = new Group(parent, 0);
        group.setText(UIMessages.ImportSessionPage1ModeGroup_label);
        gd = new GridData(272);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout());
        this.referenceradio = new Button((Composite)group, 16);
        this.referenceradio.setText(UIMessages.ImportSessionPage1Reference_label);
        this.copyradio = new Button((Composite)group, 16);
        this.copyradio.setText(UIMessages.ImportSessionPage1Copy_label);
        group = new Group(parent, 0);
        group.setText(UIMessages.ImportSessionPage1MetadataGroup_label);
        gd = new GridData(272);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout());
        this.ideclassesradio = new Button((Composite)group, 16);
        this.ideclassesradio.setText(UIMessages.ImportSessionPage1IDEClasses_label);
        this.importmetadataradio = new Button((Composite)group, 16);
        this.importmetadataradio.setText(UIMessages.ImportSessionPage1ImportMetaData_label);
        this.setControl((Control)parent);
        ContextHelp.setHelp((Control)parent, "com.mountainminds.eclemma.ui.session_import_context");
        this.restoreWidgetValues();
        this.update();
    }

    private void openBrowseDialog() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setText(UIMessages.ImportSessionPage1BrowseDialog_title);
        fd.setFileName(this.filecombo.getText());
        fd.setFilterExtensions(new String[]{"*.ec;*.es", "*.*"});
        String file = fd.open();
        if (file != null) {
            this.filecombo.setText(file);
        }
    }

    private void update() {
        if (this.getSessionDescription().length() == 0) {
            this.setMessage(UIMessages.ImportReportPage1NoDescription_message);
            this.setPageComplete(false);
            return;
        }
        File cf = new File(this.getCoverageFile());
        if (!cf.exists() || !cf.isFile()) {
            this.setMessage(UIMessages.ImportReportPage1NoCoverageFile_message);
            this.setPageComplete(false);
            return;
        }
        if (this.getClassFiles().length == 0) {
            this.setMessage(UIMessages.ImportReportPage1NoClassFiles_message);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void restoreWidgetValues() {
        boolean copy;
        String descr = UIMessages.ImportSessionPage1Description_value;
        Object[] arg = new Object[]{new Date()};
        this.descriptiontext.setText(MessageFormat.format(descr, arg));
        IDialogSettings settings = this.getDialogSettings();
        ComboHistory.restore(settings, STORE_FILES, this.filecombo);
        boolean binaries = settings.getBoolean(STORE_BINARIES);
        this.classesviewer.setIncludeBinaries(binaries);
        this.binariescheck.setSelection(binaries);
        String[] classes = settings.getArray(STORE_CLASSES);
        if (classes != null) {
            this.classesviewer.setSelectedClasses(classes);
        }
        this.referenceradio.setSelection(!(copy = settings.getBoolean(STORE_COPY)));
        this.copyradio.setSelection(copy);
        boolean importmetadata = settings.getBoolean(STORE_IMPORTMETADATA);
        this.ideclassesradio.setSelection(!importmetadata);
        this.importmetadataradio.setSelection(importmetadata);
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        ComboHistory.save(settings, STORE_FILES, this.filecombo);
        settings.put(STORE_CLASSES, this.classesviewer.getSelectedClassesLocations());
        settings.put(STORE_BINARIES, this.binariescheck.getSelection());
        settings.put(STORE_COPY, this.copyradio.getSelection());
        settings.put(STORE_IMPORTMETADATA, this.importmetadataradio.getSelection());
    }

    public String getSessionDescription() {
        return this.descriptiontext.getText().trim();
    }

    public String getCoverageFile() {
        return this.filecombo.getText();
    }

    public IClassFiles[] getClassFiles() {
        return this.classesviewer.getSelectedClasses();
    }

    public boolean getCreateCopy() {
        return this.copyradio.getSelection();
    }

    public boolean getUseImportedMetaData() {
        return this.importmetadataradio.getSelection();
    }
}

