/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.coverageview;

import com.mountainminds.eclemma.core.analysis.ICounter;
import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import org.eclipse.ui.IMemento;

public class ViewSettings {
    public static final int ENTRYMODE_PROJECTS = 1;
    public static final int ENTRYMODE_PACKAGEROOTS = 2;
    public static final int ENTRYMODE_PACKAGES = 3;
    public static final int ENTRYMODE_TYPES = 4;
    private static final String KEY_SORTCOLUMN = "sortcolumn";
    private static final String KEY_REVERSESORT = "reversesort";
    private static final String KEY_COUNTERMODE = "countermode";
    private static final String KEY_HIDEUNUSEDTYPES = "hideunusedtypes";
    private static final String KEY_ENTRYMODE = "entrymode";
    private static final String KEY_COLUMN0 = "column0";
    private static final String KEY_COLUMN1 = "column1";
    private static final String KEY_COLUMN2 = "column2";
    private static final String KEY_COLUMN3 = "column3";
    private static final String KEY_LINKED = "linked";
    public static final ICounterMode[] COUNTERMODES = new ICounterMode[]{new ICounterMode(){

        public int getIdx() {
            return 0;
        }

        public String getActionLabel() {
            return UIMessages.CoverageViewCounterModeInstructionsAction_label;
        }

        public ICounter getCounter(IJavaElementCoverage coverage) {
            return coverage.getInstructionCounter();
        }

        public String[] getColumnHeaders() {
            return new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredInstructions_label, UIMessages.CoverageViewColumnTotalInstructions_label};
        }
    }, new ICounterMode(){

        public int getIdx() {
            return 1;
        }

        public String getActionLabel() {
            return UIMessages.CoverageViewCounterModeBlocksAction_label;
        }

        public ICounter getCounter(IJavaElementCoverage coverage) {
            return coverage.getBlockCounter();
        }

        public String[] getColumnHeaders() {
            return new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredBlocks_label, UIMessages.CoverageViewColumnTotalBlocks_label};
        }
    }, new ICounterMode(){

        public int getIdx() {
            return 2;
        }

        public String getActionLabel() {
            return UIMessages.CoverageViewCounterModeLinesAction_label;
        }

        public ICounter getCounter(IJavaElementCoverage coverage) {
            return coverage.getLineCounter();
        }

        public String[] getColumnHeaders() {
            return new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredLines_label, UIMessages.CoverageViewColumnTotalLines_label};
        }
    }, new ICounterMode(){

        public int getIdx() {
            return 3;
        }

        public String getActionLabel() {
            return UIMessages.CoverageViewCounterModeMethodsAction_label;
        }

        public ICounter getCounter(IJavaElementCoverage coverage) {
            return coverage.getMethodCounter();
        }

        public String[] getColumnHeaders() {
            return new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredMethods_label, UIMessages.CoverageViewColumnTotalMethods_label};
        }
    }, new ICounterMode(){

        public int getIdx() {
            return 4;
        }

        public String getActionLabel() {
            return UIMessages.CoverageViewCounterModeTypesAction_label;
        }

        public ICounter getCounter(IJavaElementCoverage coverage) {
            return coverage.getTypeCounter();
        }

        public String[] getColumnHeaders() {
            return new String[]{UIMessages.CoverageViewColumnElement_label, UIMessages.CoverageViewColumnCoverage_label, UIMessages.CoverageViewColumnCoveredTypes_label, UIMessages.CoverageViewColumnTotalTypes_label};
        }
    }};
    private static final int[] DEFAULT_COLUMNWIDTH = new int[]{300, 80, 120, 120};
    private int sortcolumn;
    private boolean reversesort;
    private int countermode;
    private int entrymode;
    private boolean hideunusedtypes;
    private int[] columnwidths = new int[4];
    private boolean linked;

    public int getSortColumn() {
        return this.sortcolumn;
    }

    public boolean isReverseSort() {
        return this.reversesort;
    }

    public void toggleSortColumn(int column) {
        if (this.sortcolumn == column) {
            this.reversesort = !this.reversesort;
        } else {
            this.reversesort = false;
            this.sortcolumn = column;
        }
    }

    public ICounterMode getCounterMode() {
        return COUNTERMODES[this.countermode];
    }

    public void setCounterMode(int idx) {
        this.countermode = idx;
    }

    public int getEntryMode() {
        return this.entrymode;
    }

    public void setEntryMode(int mode) {
        this.entrymode = mode;
    }

    public boolean getHideUnusedTypes() {
        return this.hideunusedtypes;
    }

    public void setHideUnusedTypes(boolean flag) {
        this.hideunusedtypes = flag;
    }

    public int[] getColumnWidths() {
        return this.columnwidths;
    }

    public boolean getLinked() {
        return this.linked;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public void init(IMemento memento) {
        this.sortcolumn = this.getInt(memento, KEY_SORTCOLUMN, 0);
        this.reversesort = this.getBoolean(memento, KEY_REVERSESORT, false);
        this.countermode = this.getInt(memento, KEY_COUNTERMODE, 0);
        this.entrymode = this.getInt(memento, KEY_ENTRYMODE, 1);
        this.hideunusedtypes = this.getBoolean(memento, KEY_HIDEUNUSEDTYPES, false);
        this.columnwidths[0] = this.getInt(memento, KEY_COLUMN0, DEFAULT_COLUMNWIDTH[0]);
        this.columnwidths[1] = this.getInt(memento, KEY_COLUMN1, DEFAULT_COLUMNWIDTH[1]);
        this.columnwidths[2] = this.getInt(memento, KEY_COLUMN2, DEFAULT_COLUMNWIDTH[2]);
        this.columnwidths[3] = this.getInt(memento, KEY_COLUMN3, DEFAULT_COLUMNWIDTH[3]);
        this.linked = this.getBoolean(memento, KEY_LINKED, false);
    }

    public void save(IMemento memento) {
        memento.putInteger(KEY_SORTCOLUMN, this.sortcolumn);
        memento.putInteger(KEY_REVERSESORT, this.reversesort ? 1 : 0);
        memento.putInteger(KEY_COUNTERMODE, this.countermode);
        memento.putInteger(KEY_ENTRYMODE, this.entrymode);
        memento.putInteger(KEY_HIDEUNUSEDTYPES, this.hideunusedtypes ? 1 : 0);
        memento.putInteger(KEY_COLUMN0, this.columnwidths[0]);
        memento.putInteger(KEY_COLUMN1, this.columnwidths[1]);
        memento.putInteger(KEY_COLUMN2, this.columnwidths[2]);
        memento.putInteger(KEY_COLUMN3, this.columnwidths[3]);
        memento.putInteger(KEY_LINKED, this.linked ? 1 : 0);
    }

    private int getInt(IMemento memento, String key, int preset) {
        if (memento == null) {
            return preset;
        }
        Integer i = memento.getInteger(key);
        return i == null ? preset : i;
    }

    private boolean getBoolean(IMemento memento, String key, boolean preset) {
        return this.getInt(memento, key, preset ? 1 : 0) == 1;
    }

    public static interface ICounterMode {
        public int getIdx();

        public String[] getColumnHeaders();

        public String getActionLabel();

        public ICounter getCounter(IJavaElementCoverage var1);
    }
}

