/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.coverageview;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.analysis.ICounter;
import com.mountainminds.eclemma.internal.ui.coverageview.CoverageView;
import com.mountainminds.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeColumn;

class CoverageViewSorter
extends ViewerSorter {
    private final ViewSettings settings;
    private final CoverageView view;
    private final ViewerSorter elementsorter = new JavaElementSorter();

    public CoverageViewSorter(ViewSettings settings, CoverageView view) {
        this.settings = settings;
        this.view = view;
    }

    void addColumn(TreeColumn column, final int columnidx) {
        column.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CoverageViewSorter.this.settings.toggleSortColumn(columnidx);
                CoverageViewSorter.this.view.refreshViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        ViewSettings.ICounterMode mode = this.settings.getCounterMode();
        ICounter c1 = mode.getCounter(CoverageTools.getCoverageInfo((Object)e1));
        ICounter c2 = mode.getCounter(CoverageTools.getCoverageInfo((Object)e2));
        int res = 0;
        switch (this.settings.getSortColumn()) {
            case 0: {
                res = this.elementsorter.compare(viewer, e1, e2);
                break;
            }
            case 1: {
                res = Double.compare(c1.getRatio(), c2.getRatio());
                break;
            }
            case 2: {
                res = (int)(c1.getCoveredCount() - c2.getCoveredCount());
                break;
            }
            case 3: {
                res = (int)(c1.getTotalCount() - c2.getTotalCount());
            }
        }
        res = res == 0 ? this.elementsorter.compare(viewer, e1, e2) : (this.settings.isReverseSort() ? -res : res);
        return res;
    }
}

