/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.annotation;

import com.mountainminds.eclemma.internal.ui.annotation.CoverageAnnotationModel;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorTracker {
    private final IWorkbench workbench;
    private IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener(EditorTracker.this.partListener);
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.getPartService().removePartListener(EditorTracker.this.partListener);
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }
    };
    private IPartListener2 partListener = new IPartListener2(){

        public void partOpened(IWorkbenchPartReference partref) {
            EditorTracker.this.annotateEditor(partref);
        }

        public void partActivated(IWorkbenchPartReference partref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partref) {
        }

        public void partVisible(IWorkbenchPartReference partref) {
        }

        public void partInputChanged(IWorkbenchPartReference partref) {
        }

        public void partClosed(IWorkbenchPartReference partref) {
        }

        public void partDeactivated(IWorkbenchPartReference partref) {
        }

        public void partHidden(IWorkbenchPartReference partref) {
        }
    };

    public EditorTracker(IWorkbench workbench) {
        this.workbench = workbench;
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].getPartService().addPartListener(this.partListener);
            ++i;
        }
        workbench.addWindowListener(this.windowListener);
        this.annotateAllEditors();
    }

    public void dispose() {
        this.workbench.removeWindowListener(this.windowListener);
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].getPartService().removePartListener(this.partListener);
            ++i;
        }
    }

    private void annotateAllEditors() {
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] editors = pages[j].getEditorReferences();
                int k = 0;
                while (k < editors.length) {
                    this.annotateEditor((IWorkbenchPartReference)editors[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void annotateEditor(IWorkbenchPartReference partref) {
        IWorkbenchPart part = partref.getPart(false);
        if (part instanceof ITextEditor) {
            CoverageAnnotationModel.attach((ITextEditor)part);
        }
    }
}

