/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.actions;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionManager;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.dialogs.MergeSessionsDialog;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;

public class MergeSessionsAction
extends Action {
    private final IWorkbenchWindow window;

    public MergeSessionsAction(IWorkbenchWindow window) {
        this.window = window;
        this.setText(UIMessages.MergeSessionsAction_label);
        this.setToolTipText(UIMessages.MergeSessionsAction_tooltip);
        this.setImageDescriptor(EclEmmaUIPlugin.getImageDescriptor("icons/full/elcl16/mergesessions.gif"));
        this.setDisabledImageDescriptor(EclEmmaUIPlugin.getImageDescriptor("icons/full/dlcl16/mergesessions.gif"));
    }

    public void run() {
        ISessionManager sm = CoverageTools.getSessionManager();
        ICoverageSession[] sessions = sm.getSessions();
        String descr = UIMessages.MergeSessionsDialogDescriptionDefault_value;
        descr = MessageFormat.format(descr, new Date());
        MergeSessionsDialog d = new MergeSessionsDialog(this.window.getShell(), sessions, descr);
        if (d.open() == 0) {
            Object[] result = d.getResult();
            ICoverageSession merged = (ICoverageSession)result[0];
            int i = 1;
            while (i < result.length) {
                merged = merged.merge((ICoverageSession)result[i], d.getDescription());
                ++i;
            }
            sm.addSession(merged, true, null);
            i = 0;
            while (i < result.length) {
                sm.removeSession((ICoverageSession)result[i]);
                ++i;
            }
        }
    }
}

