/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.actions;

import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ContextualLaunchableTester
extends PropertyTester {
    private Map expressions = new HashMap();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String delegateShortcutID = (String)args[0];
        Expression expr = (Expression)this.expressions.get(delegateShortcutID);
        if (expr == null) {
            expr = this.createEnablementExpression(delegateShortcutID);
            this.expressions.put(delegateShortcutID, expr);
        }
        try {
            return expr.evaluate(this.createContext(receiver)) != EvaluationResult.FALSE;
        }
        catch (CoreException ce) {
            EclEmmaUIPlugin.log(ce);
            return false;
        }
    }

    private IEvaluationContext createContext(Object selection) {
        EvaluationContext context = new EvaluationContext(null, selection);
        context.addVariable("selection", selection);
        return context;
    }

    private Expression createEnablementExpression(String delegateShortcutID) {
        IConfigurationElement element = this.findEnablementConfiguration(delegateShortcutID);
        if (element != null) {
            try {
                return ExpressionConverter.getDefault().perform(element);
            }
            catch (CoreException ce) {
                EclEmmaUIPlugin.log(ce);
            }
        }
        return Expression.FALSE;
    }

    private IConfigurationElement findEnablementConfiguration(String delegateShortcutID) {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
        int i = 0;
        while (i < configs.length) {
            IConfigurationElement[] enablement;
            IConfigurationElement[] launch;
            String modes;
            if (delegateShortcutID.equals(configs[i].getAttribute("id")) && (modes = configs[i].getAttribute("modes")) != null && Arrays.asList(modes.split("\\W")).contains("run") && (launch = configs[i].getChildren("contextualLaunch")).length == 1 && (enablement = launch[0].getChildren("enablement")).length == 1) {
                return enablement[0];
            }
            ++i;
        }
        return null;
    }
}

