/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.rollback;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.IUTransformationHelper;
import org.eclipse.equinox.internal.p2.director.NewDependencyExpander;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.SimplePlanner;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.BeginOperationEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.RollbackOperationEvent;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class FormerState {
    public static final String IUPROP_PREFIX = "---IUPROPERTY---";
    public static final String IUPROP_POSTFIX = "---IUPROPERTYKEY---";
    private static long lastTimestamp;
    URL location = null;
    Hashtable generatedIUs = new Hashtable();
    static /* synthetic */ Class class$0;

    private static synchronized long uniqueTimestamp() {
        long timewaited = 0L;
        long timestamp = System.currentTimeMillis();
        while (timestamp == lastTimestamp) {
            if (timewaited > 1000L) {
                throw new IllegalStateException("uniquetimestamp failed");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            timewaited += 10L;
            timestamp = System.currentTimeMillis();
        }
        lastTimestamp = timestamp;
        return timestamp;
    }

    public FormerState(URL repoLocation) {
        if (repoLocation == null) {
            throw new IllegalArgumentException("Repository location can't be null");
        }
        IProvisioningEventBus eventBus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)IProvisioningEventBus.SERVICE_NAME);
        this.location = repoLocation;
        eventBus.addListener((ProvisioningListener)new SynchronousProvisioningListener(){

            public void notify(EventObject o) {
                if (o instanceof BeginOperationEvent) {
                    BeginOperationEvent event = (BeginOperationEvent)o;
                    IInstallableUnit iuForProfile = FormerState.profileToIU(event.getProfile());
                    FormerState.this.generatedIUs.put(event.getProfile().getProfileId(), iuForProfile);
                } else {
                    if (o instanceof ProfileEvent) {
                        ProfileEvent event = (ProfileEvent)o;
                        if (event.getReason() == 2) {
                            FormerState.this.getRepository().addInstallableUnits(new IInstallableUnit[]{(IInstallableUnit)FormerState.this.generatedIUs.get(event.getProfileId())});
                        }
                        return;
                    }
                    if (o instanceof RollbackOperationEvent) {
                        RollbackOperationEvent event = (RollbackOperationEvent)o;
                        FormerState.this.generatedIUs.remove(event.getProfile().getProfileId());
                        return;
                    }
                }
            }
        });
    }

    IMetadataRepository getRepository() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName());
        try {
            return manager.loadRepository(this.location, null);
        }
        catch (ProvisionException provisionException) {
            try {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("p2.system", Boolean.TRUE.toString());
                IMetadataRepository repository = manager.createRepository(this.location, "Agent rollback repository", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
                manager.addRepository(repository.getLocation());
                return repository;
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalStateException("Unable to open or create Agent's rollback repository");
            }
        }
    }

    public static IInstallableUnit profileToIU(IProfile profile) {
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        result.setProperty("org.eclipse.equinox.p2.type.profile", Boolean.TRUE.toString());
        result.setId(profile.getProfileId());
        result.setVersion(new Version(0, 0, 0, Long.toString(FormerState.uniqueTimestamp())));
        result.setRequiredCapabilities(IUTransformationHelper.toRequirements(profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null).iterator(), false));
        Map properties = profile.getProperties();
        Iterator iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            result.setProperty(key, (String)properties.get(key));
        }
        Iterator allIUs = profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null).iterator();
        while (allIUs.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)allIUs.next();
            properties = profile.getInstallableUnitProperties(iu);
            iter = properties.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                result.setProperty(IUPROP_PREFIX + iu.getId() + IUPROP_POSTFIX + key, (String)properties.get(key));
            }
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result);
    }

    public static IProfile IUToProfile(IInstallableUnit profileIU, IProfile profile, ProvisioningContext context, IProgressMonitor monitor) throws ProvisionException {
        try {
            FormerStateProfile formerStateProfile = new FormerStateProfile(profileIU, profile, context);
            return formerStateProfile;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static ProfileChangeRequest generateProfileDeltaChangeRequest(IProfile current, IProfile target) {
        ProfileChangeRequest request = new ProfileChangeRequest(current);
        FormerState.synchronizeProfileProperties(request, current, target);
        FormerState.synchronizeMarkedIUs(request, current, target);
        FormerState.synchronizeAllIUProperties(request, current, target);
        return request;
    }

    private static void synchronizeAllIUProperties(ProfileChangeRequest request, IProfile current, IProfile target) {
        Collection currentIUs = current.query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection();
        Collection targetIUs = target.query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection();
        ArrayList iusToAdd = new ArrayList(targetIUs);
        iusToAdd.remove(currentIUs);
        Iterator iterator = iusToAdd.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            Iterator it = target.getInstallableUnitProperties(iu).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                request.setInstallableUnitProfileProperty(iu, key, value);
            }
        }
        ArrayList iusToUpdate = new ArrayList(targetIUs);
        iusToUpdate.remove(iusToAdd);
        Iterator iterator2 = iusToUpdate.iterator();
        while (iterator2.hasNext()) {
            String key;
            Map.Entry entry;
            IInstallableUnit iu = (IInstallableUnit)iterator2.next();
            HashMap propertiesToSet = new HashMap(target.getInstallableUnitProperties(iu));
            Iterator it = current.getInstallableUnitProperties(iu).entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                key = (String)entry.getKey();
                String newValue = (String)propertiesToSet.get(key);
                if (newValue == null) {
                    request.removeInstallableUnitProfileProperty(iu, key);
                    continue;
                }
                if (!newValue.equals(entry.getValue())) continue;
                propertiesToSet.remove(key);
            }
            it = propertiesToSet.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                key = (String)entry.getKey();
                String value = (String)entry.getValue();
                request.setInstallableUnitProfileProperty(iu, key, value);
            }
        }
    }

    private static void synchronizeMarkedIUs(ProfileChangeRequest request, IProfile current, IProfile target) {
        IInstallableUnit[] currentPlannerMarkedIUs = SimplePlanner.findPlannerMarkedIUs(current);
        IInstallableUnit[] targetPlannerMarkedIUs = SimplePlanner.findPlannerMarkedIUs(target);
        ArrayList<IInstallableUnit> markedIUsToAdd = new ArrayList<IInstallableUnit>(Arrays.asList(targetPlannerMarkedIUs));
        markedIUsToAdd.removeAll(Arrays.asList(currentPlannerMarkedIUs));
        request.addInstallableUnits(markedIUsToAdd.toArray(new IInstallableUnit[markedIUsToAdd.size()]));
        ArrayList<IInstallableUnit> markedIUsToRemove = new ArrayList<IInstallableUnit>(Arrays.asList(currentPlannerMarkedIUs));
        markedIUsToRemove.removeAll(Arrays.asList(targetPlannerMarkedIUs));
        request.removeInstallableUnits(markedIUsToRemove.toArray(new IInstallableUnit[markedIUsToRemove.size()]));
    }

    private static void synchronizeProfileProperties(ProfileChangeRequest request, IProfile current, IProfile target) {
        String key;
        Map.Entry entry;
        HashMap profilePropertiesToSet = new HashMap(target.getProperties());
        Iterator it = current.getProperties().entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = (String)entry.getKey();
            String newValue = (String)profilePropertiesToSet.get(key);
            if (newValue == null) {
                request.removeProfileProperty(key);
                continue;
            }
            if (!newValue.equals(entry.getValue())) continue;
            profilePropertiesToSet.remove(key);
        }
        it = profilePropertiesToSet.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = (String)entry.getKey();
            String value = (String)entry.getValue();
            request.setProfileProperty(key, value);
        }
    }

    public static class FormerStateProfile
    implements IProfile {
        private String profileId;
        private HashMap profileProperties = new HashMap();
        private HashMap iuProfileProperties = new HashMap();
        private Set ius = new HashSet();

        public FormerStateProfile(IInstallableUnit profileIU, IProfile profile, ProvisioningContext context) throws ProvisionException {
            String profileTypeProperty = profileIU.getProperty("org.eclipse.equinox.p2.type.profile");
            if (profileTypeProperty == null || !Boolean.valueOf(profileTypeProperty).booleanValue()) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.director", "Not a profile type IU"));
            }
            this.profileId = profileIU.getId();
            Iterator it = profileIU.getProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (key.startsWith(FormerState.IUPROP_PREFIX)) {
                    int postIndex = key.indexOf(FormerState.IUPROP_POSTFIX, FormerState.IUPROP_PREFIX.length());
                    String iuId = key.substring(FormerState.IUPROP_PREFIX.length(), postIndex);
                    HashMap iuProperties = (HashMap)this.iuProfileProperties.get(iuId);
                    if (iuProperties == null) {
                        iuProperties = new HashMap();
                        this.iuProfileProperties.put(iuId, iuProperties);
                    }
                    String iuPropertyKey = key.substring(postIndex + FormerState.IUPROP_POSTFIX.length());
                    iuProperties.put(iuPropertyKey, entry.getValue());
                    continue;
                }
                this.profileProperties.put(key, entry.getValue());
            }
            this.profileProperties.remove("org.eclipse.equinox.p2.type.profile");
            ArrayList<IInstallableUnit> extraIUs = new ArrayList<IInstallableUnit>(profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection());
            extraIUs.add(profileIU);
            IInstallableUnit[] availableIUs = SimplePlanner.gatherAvailableInstallableUnits(extraIUs.toArray(new IInstallableUnit[extraIUs.size()]), context.getMetadataRepositories(), context, (IProgressMonitor)new NullProgressMonitor());
            Dictionary snapshotSelectionContext = SimplePlanner.createSelectionContext(this.profileProperties);
            IInstallableUnit[] allIUs = new IInstallableUnit[]{profileIU};
            Slicer slicer = new Slicer(allIUs, availableIUs, snapshotSelectionContext);
            IQueryable slice = slicer.slice(allIUs, (IProgressMonitor)new NullProgressMonitor());
            if (slice == null) {
                throw new ProvisionException((IStatus)slicer.getStatus());
            }
            Projector projector = new Projector(slice, snapshotSelectionContext);
            projector.encode(allIUs, (IProgressMonitor)new NullProgressMonitor());
            IStatus s = projector.invokeSolver((IProgressMonitor)new NullProgressMonitor());
            if (s.getSeverity() == 4) {
                IStatus oldResolverStatus;
                LogHelper.log((IStatus)s);
                if (!"true".equalsIgnoreCase(context == null ? null : context.getProperty("org.eclipse.equinox.p2.disable.error.reporting")) && !(oldResolverStatus = new NewDependencyExpander(allIUs, null, availableIUs, snapshotSelectionContext, false).expand((IProgressMonitor)new NullProgressMonitor())).isOK()) {
                    s = oldResolverStatus;
                }
                throw new ProvisionException(s);
            }
            this.ius.addAll(projector.extractSolution());
            this.ius.remove(profileIU);
        }

        public Map getInstallableUnitProperties(IInstallableUnit iu) {
            Map iuProperties = (Map)this.iuProfileProperties.get(iu.getId());
            if (iuProperties == null) {
                return Collections.EMPTY_MAP;
            }
            return Collections.unmodifiableMap(iuProperties);
        }

        public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
            return (String)this.getInstallableUnitProperties(iu).get(key);
        }

        public Map getLocalProperties() {
            return Collections.unmodifiableMap(this.profileProperties);
        }

        public String getLocalProperty(String key) {
            return (String)this.profileProperties.get(key);
        }

        public IProfile getParentProfile() {
            return null;
        }

        public String getProfileId() {
            return this.profileId;
        }

        public Map getProperties() {
            return Collections.unmodifiableMap(this.profileProperties);
        }

        public String getProperty(String key) {
            return (String)this.profileProperties.get(key);
        }

        public String[] getSubProfileIds() {
            return null;
        }

        public long getTimestamp() {
            return 0L;
        }

        public boolean hasSubProfiles() {
            return false;
        }

        public boolean isRootProfile() {
            return true;
        }

        public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
            return query.perform(this.ius.iterator(), collector);
        }

        public Collector available(Query query, Collector collector, IProgressMonitor monitor) {
            return this.query(query, collector, monitor);
        }
    }
}

