/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.director.BasicIUFilter;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.HasMatchCollector;
import org.eclipse.equinox.internal.p2.director.IUFilter;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.Picker;
import org.eclipse.equinox.internal.p2.director.RecommendationDescriptor;
import org.eclipse.equinox.internal.p2.director.RequirementBasedFilter;
import org.eclipse.equinox.internal.p2.resolution.ResolutionHelper;
import org.eclipse.equinox.internal.p2.resolution.UnsatisfiedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.Copyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.License;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointType;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.CapabilityQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class NewDependencyExpander {
    static final int OperationWork = 100;
    private final Set alreadyInstalled = new HashSet();
    private boolean includeOptional;
    private Map must = new HashMap();
    private Picker picker;
    private Dictionary selectionContext;
    private RecommendationDescriptor recommendations;
    private ResolutionHelper resolver;
    private IInstallableUnit[] roots;
    private Collection solution;

    public NewDependencyExpander(IInstallableUnit[] r, IInstallableUnit[] alreadyInstalled, IInstallableUnit[] availableIUs, Dictionary selectionContext, boolean includeOptional) {
        this.roots = r == null ? new IInstallableUnit[]{} : r;
        this.includeOptional = includeOptional;
        alreadyInstalled = alreadyInstalled == null ? new IInstallableUnit[]{} : alreadyInstalled;
        this.alreadyInstalled.addAll(Arrays.asList(alreadyInstalled));
        this.selectionContext = selectionContext;
        IInstallableUnit[] result = new IInstallableUnit[this.roots.length + alreadyInstalled.length + availableIUs.length];
        System.arraycopy(this.roots, 0, result, 0, this.roots.length);
        System.arraycopy(alreadyInstalled, 0, result, this.roots.length, alreadyInstalled.length);
        System.arraycopy(availableIUs, 0, result, this.roots.length + alreadyInstalled.length, availableIUs.length);
        this.picker = new Picker(result, new RecommendationDescriptor(new HashSet()));
        ArrayList<IUFilter> filterForRoot = new ArrayList<IUFilter>();
        if (r != null && r.length > 0) {
            filterForRoot.add(new BasicIUFilter(r));
            filterForRoot.add(new RequirementBasedFilter(r[0].getRequiredCapabilities()));
        }
        this.picker.prefer(filterForRoot);
    }

    private void addUnsatisfied(RequiredCapability req, Collection toAdd, MultiStatus problems) {
        Iterator it = toAdd.iterator();
        while (it.hasNext()) {
            IInstallableUnit unit = (IInstallableUnit)it.next();
            RequiredCapability[] required = unit.getRequiredCapabilities();
            int i = 0;
            while (i < required.length) {
                if (required[i].equals((Object)req)) {
                    UnsatisfiedCapability unsatisfied = new UnsatisfiedCapability(req, unit);
                    String msg = NLS.bind((String)Messages.Director_Unsatisfied_Dependency, (Object)unsatisfied);
                    problems.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", msg));
                }
                ++i;
            }
        }
    }

    private void algo(SubMonitor p, MultiStatus problems) {
        Collection toAdd = this.asOptionalIUs(Arrays.asList(this.roots), false);
        toAdd.addAll(this.alreadyInstalled);
        do {
            p.setWorkRemaining(100);
            this.extractVisibilityData(toAdd);
            this.extractRequirements(toAdd);
            toAdd = this.collectMatches(toAdd, problems);
            p.worked(33);
        } while (toAdd.size() != 0);
        this.invokeResolver(problems);
        this.extractSolution();
    }

    private void extractVisibilityData(Collection ius) {
        ArrayList<RequirementBasedFilter> filters = new ArrayList<RequirementBasedFilter>();
        Iterator iterator = ius.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            if (!"true".equalsIgnoreCase(iu.getProperty("lineUp"))) continue;
            filters.add(new RequirementBasedFilter(iu.getRequiredCapabilities()));
        }
        this.picker.prefer(filters);
    }

    private Collection asOptionalIUs(Collection asList, boolean generateOptionalReqs) {
        ArrayList<OptionalInstallableUnit> result = new ArrayList<OptionalInstallableUnit>();
        Iterator iterator = asList.iterator();
        while (iterator.hasNext()) {
            result.add(new OptionalInstallableUnit((IInstallableUnit)iterator.next(), generateOptionalReqs));
        }
        return result;
    }

    private Collection collectFlavorProviders(Collection toSearchFor) {
        String flavor = (String)this.selectionContext.get("org.eclipse.equinox.p2.environments");
        if (flavor == null) {
            return new HashSet();
        }
        IInstallableUnit[][] picked = this.picker.findInstallableUnit(null, null, new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.flavor", (String)flavor, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}, true);
        IInstallableUnit[] ius = picked[0].length > 0 ? picked[0] : picked[1];
        HashSet<OptionalInstallableUnit> results = new HashSet<OptionalInstallableUnit>(ius.length);
        int i = 0;
        while (i < ius.length) {
            IInstallableUnit tmp = this.match(toSearchFor, ius[i]);
            if (tmp != null) {
                results.add(new OptionalInstallableUnit(tmp, false));
            }
            ++i;
        }
        return results;
    }

    private Collection collectInstallableUnitFragments(Collection ius) {
        HashSet<Object> picked = new HashSet<Object>();
        Iterator iterator = ius.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit[] matches;
            IInstallableUnit current = (IInstallableUnit)iterator.next();
            IInstallableUnit[][] candidates = this.picker.findInstallableUnit(null, null, new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"fragment", (String)current.getId(), (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false)}, false);
            IInstallableUnit[] iInstallableUnitArray = matches = candidates[0].length > 0 ? candidates[0] : candidates[1];
            if (matches.length <= 0) continue;
            if (matches.length == 1) {
                picked.add(matches[0]);
                continue;
            }
            ProvidedCapability capForCurrent = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)current.getId(), (Version)current.getVersion());
            HashMap<String, IInstallableUnit> toAdd = new HashMap<String, IInstallableUnit>();
            int i = 0;
            while (i < matches.length) {
                IInstallableUnit match;
                RequiredCapability[] reqs = matches[i].getRequiredCapabilities();
                boolean isReallyAFragment = false;
                int j = 0;
                while (j < reqs.length) {
                    isReallyAFragment = capForCurrent.isSatisfiedBy(reqs[j]);
                    ++j;
                }
                if (isReallyAFragment && ((match = (IInstallableUnit)toAdd.get(matches[i].getId())) == null || match.getVersion().compareTo((Object)matches[i].getVersion()) < 0)) {
                    toAdd.put(matches[i].getId(), matches[i]);
                }
                ++i;
            }
            picked.addAll(toAdd.values());
        }
        return picked;
    }

    private Collection collectMatches(Collection toAdd, MultiStatus problems) {
        HashSet thingsAdded = new HashSet();
        Iterator iterator = this.must.values().iterator();
        while (iterator.hasNext()) {
            List all = (List)iterator.next();
            Iterator matches = all.iterator();
            while (matches.hasNext()) {
                Collection found;
                Match current = (Match)matches.next();
                Collection[] picked = this.picker.findInstallableUnit(null, null, current.req);
                Collection collection = found = picked[0].size() > 0 ? picked[0] : picked[1];
                if (current.candidates.addAll(found)) {
                    thingsAdded.addAll(found);
                    thingsAdded.addAll(this.collectOptionalInstallableUnits(found));
                }
                if (current.candidates.size() != 0 || !this.requirementEnabled(current.req)) continue;
                this.addUnsatisfied(current.req, toAdd, problems);
            }
            if (all.size() > 2) {
                throw new IllegalStateException("Can't deal with three or more different versions of the same IU " + ((Match)all.get((int)0)).req + ". See bug 200380");
            }
            if (all.size() <= 1) continue;
            Set set1 = ((Match)all.get((int)0)).candidates;
            Set set2 = ((Match)all.get((int)1)).candidates;
            boolean potentialSolution = false;
            Iterator iteratorSet1 = set1.iterator();
            while (iteratorSet1.hasNext() && !potentialSolution) {
                IInstallableUnit itemSet1 = (IInstallableUnit)iteratorSet1.next();
                Iterator iteratorSet2 = set2.iterator();
                while (iteratorSet2.hasNext() && !potentialSolution) {
                    IInstallableUnit itemSet2 = (IInstallableUnit)iteratorSet2.next();
                    if (itemSet1.getId().equals(itemSet2.getId()) && (itemSet1.isSingleton() && itemSet1.isSingleton() == itemSet2.isSingleton() || itemSet1.isSingleton() != itemSet2.isSingleton())) continue;
                    potentialSolution = true;
                }
            }
            if (potentialSolution) continue;
            String msg = "Can't find a solution where both: " + all.get(0) + " and " + all.get(1) + " would be satisfied.";
            problems.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", msg));
        }
        return thingsAdded;
    }

    private Collection collectOptionalInstallableUnits(Collection optionalFor) {
        if (!this.includeOptional) {
            return new ArrayList(0);
        }
        Collection result = this.collectFlavorProviders(optionalFor);
        result.addAll(this.collectInstallableUnitFragments(optionalFor));
        return result;
    }

    private UnsatisfiedCapability[] collectUnsatisfiedDependencies(UnsatisfiedCapability[] unresolved) {
        ArrayList<UnsatisfiedCapability> reallyUnsatisfied = new ArrayList<UnsatisfiedCapability>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            List all = (List)this.must.get(new MatchKey(unresolved[i].getRequiredCapability()));
            if (all != null) {
                Iterator iterator = all.iterator();
                while (iterator.hasNext()) {
                    Match m = (Match)iterator.next();
                    if (!this.requirementEnabled(m.req) || this.oneResolved(m.candidates)) continue;
                    reallyUnsatisfied.add(unresolved[i]);
                }
            } else {
                this.must.get(new MatchKey(unresolved[i].getRequiredCapability()));
            }
            ++i;
        }
        return reallyUnsatisfied.toArray(new UnsatisfiedCapability[reallyUnsatisfied.size()]);
    }

    private List createList(Match m) {
        LinkedList<Match> result = new LinkedList<Match>();
        result.add(m);
        return result;
    }

    public IStatus expand(IProgressMonitor p) {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.director", 1, Messages.Director_Unsatisfied_Dependencies, null);
        try {
            this.algo(SubMonitor.convert((IProgressMonitor)p, (String)"Resolving", (int)10), result);
        }
        catch (IllegalStateException e) {
            return new Status(4, "org.eclipse.equinox.p2.director", 1, e.getMessage(), null);
        }
        if (result.isOK()) {
            return Status.OK_STATUS;
        }
        return result;
    }

    private void extractRequirements(Collection ius) {
        Iterator iterator = ius.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit currentUnit = (IInstallableUnit)iterator.next();
            RequiredCapability[] toAdd = currentUnit.getRequiredCapabilities();
            int i = 0;
            while (i < toAdd.length) {
                block6: {
                    RequiredCapability current = toAdd[i];
                    if (this.isApplicable(current) && !this.isMeta(current) && !current.isOptional()) {
                        MatchKey key = new MatchKey(current);
                        List match = (List)this.must.get(key);
                        if (match == null) {
                            this.must.put(key, this.createList(new Match(current, this.selectionContext)));
                        } else {
                            Iterator matches = match.iterator();
                            while (matches.hasNext()) {
                                Match currentMatch = (Match)matches.next();
                                VersionRange newRange = this.intersect(currentMatch.req.getRange(), current.getRange());
                                if (newRange == null) continue;
                                currentMatch.req = MetadataFactory.createRequiredCapability((String)current.getNamespace(), (String)current.getName(), (VersionRange)newRange, (String)current.getFilter(), (currentMatch.req.isOptional() && current.isOptional() ? 1 : 0) != 0, (boolean)false);
                                currentMatch.env = this.mergeEnvironments(currentMatch.env, current);
                                break block6;
                            }
                            match.add(new Match(current, this.selectionContext));
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void extractSolution() {
        this.solution = Collections.unmodifiableCollection(this.resolver.getAllResolved());
    }

    public Collection getAllInstallableUnits() {
        if (this.solution == null) {
            this.solution = new ArrayList(0);
        }
        return this.solution;
    }

    public Collection getNewInstallableUnits() {
        HashSet newIUs = new HashSet(this.getAllInstallableUnits());
        newIUs.removeAll(this.alreadyInstalled);
        return newIUs;
    }

    public RecommendationDescriptor getRecommendations() {
        return null;
    }

    private VersionRange intersect(VersionRange r1, VersionRange r2) {
        Version resultMin = null;
        boolean resultMinIncluded = false;
        Version resultMax = null;
        boolean resultMaxIncluded = false;
        int minCompare = r1.getMinimum().compareTo((Object)r2.getMinimum());
        if (minCompare < 0) {
            resultMin = r2.getMinimum();
            resultMinIncluded = r2.getIncludeMinimum();
        } else if (minCompare > 0) {
            resultMin = r1.getMinimum();
            resultMinIncluded = r1.getIncludeMinimum();
        } else {
            resultMin = r1.getMinimum();
            resultMinIncluded = r1.getIncludeMinimum() && r2.getIncludeMinimum();
        }
        int maxCompare = r1.getMaximum().compareTo((Object)r2.getMaximum());
        if (maxCompare > 0) {
            resultMax = r2.getMaximum();
            resultMaxIncluded = r2.getIncludeMaximum();
        } else if (maxCompare < 0) {
            resultMax = r1.getMaximum();
            resultMaxIncluded = r1.getIncludeMaximum();
        } else {
            resultMax = r1.getMaximum();
            resultMaxIncluded = r1.getIncludeMaximum() && r2.getIncludeMaximum();
        }
        int resultRangeComparison = resultMin.compareTo((Object)resultMax);
        if (resultRangeComparison < 0) {
            return new VersionRange(resultMin, resultMinIncluded, resultMax, resultMaxIncluded);
        }
        if (resultRangeComparison == 0 && resultMinIncluded == resultMaxIncluded) {
            return new VersionRange(resultMin, resultMinIncluded, resultMax, resultMaxIncluded);
        }
        return null;
    }

    private void invokeResolver(MultiStatus problems) {
        this.resolver = new ResolutionHelper(this.selectionContext, this.recommendations);
        HashSet toInstall = new HashSet(this.must.size());
        Iterator iterator = this.must.values().iterator();
        while (iterator.hasNext()) {
            List allMatches = (List)iterator.next();
            Iterator matches = allMatches.iterator();
            while (matches.hasNext()) {
                Match current = (Match)matches.next();
                toInstall.addAll(current.candidates);
            }
        }
        toInstall.removeAll(this.alreadyInstalled);
        UnsatisfiedCapability[] unsatisfied = this.collectUnsatisfiedDependencies(this.resolver.install(toInstall, this.alreadyInstalled));
        int i = 0;
        while (i < unsatisfied.length) {
            problems.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Director_Unsatisfied_Dependency, (Object)unsatisfied[i])));
            ++i;
        }
    }

    private boolean isApplicable(RequiredCapability req) {
        String filter = req.getFilter();
        if (filter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(filter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    private boolean isMeta(RequiredCapability requiredCapability) {
        String namespace = requiredCapability.getNamespace();
        return namespace.equals("org.eclipse.equinox.p2.eclipse.type") || namespace.equals("org.eclipse.equinox.p2.flavor");
    }

    private IInstallableUnit match(Collection close, IInstallableUnit picked) {
        HasMatchCollector result = new HasMatchCollector();
        new CapabilityQuery(picked.getRequiredCapabilities()).perform(close.iterator(), (Collector)result);
        if (!result.isEmpty()) {
            return picked;
        }
        return null;
    }

    private Dictionary mergeEnvironments(Dictionary context, RequiredCapability newCapability) {
        String[] newSelectors = newCapability.getSelectors();
        if (newSelectors == null || newSelectors.length == 0) {
            return context;
        }
        if (context == null) {
            context = new Hashtable<String, String>();
        }
        String trueString = Boolean.TRUE.toString();
        int i = 0;
        while (i < newSelectors.length) {
            ((Dictionary)context).put(newSelectors[i], trueString);
            ++i;
        }
        return context;
    }

    private boolean oneResolved(Collection ius) {
        Iterator iterator = ius.iterator();
        while (iterator.hasNext()) {
            if (!this.resolver.isResolved((IInstallableUnit)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean requirementEnabled(RequiredCapability req) {
        if (req.isOptional()) {
            return false;
        }
        return this.isApplicable(req);
    }

    private class Match {
        Set candidates;
        Dictionary env;
        RequiredCapability req;

        public Match(RequiredCapability range, Dictionary environment) {
            this.req = range;
            this.env = environment;
            this.candidates = new HashSet(2);
        }

        public String toString() {
            return "Match[" + this.req + ']';
        }
    }

    private class MatchKey {
        String name;
        String namespace;

        MatchKey(RequiredCapability capability) {
            this.namespace = capability.getNamespace();
            this.name = capability.getName();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MatchKey)) {
                return false;
            }
            MatchKey that = (MatchKey)object;
            return this.namespace.equals(that.namespace) && this.name.equals(that.name);
        }

        public int hashCode() {
            return 31 * this.namespace.hashCode() + this.name.hashCode();
        }

        public String toString() {
            return "MatchKey(" + this.namespace + '/' + this.name + ')';
        }
    }

    private class OptionalInstallableUnit
    implements IInstallableUnit {
        private boolean optionalReqs;
        private IInstallableUnit wrapped;

        OptionalInstallableUnit(IInstallableUnit iu, boolean generateOptionalReqs) {
            this.wrapped = iu;
            this.optionalReqs = generateOptionalReqs;
        }

        public String getFilter() {
            return this.wrapped.getFilter();
        }

        public String getId() {
            return this.wrapped.getId();
        }

        public Version getVersion() {
            return this.wrapped.getVersion();
        }

        public String getProperty(String key) {
            return this.wrapped.getProperty(key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OptionalInstallableUnit other = (OptionalInstallableUnit)obj;
            return !(this.wrapped == null ? other.wrapped != null : !this.wrapped.equals(other.wrapped));
        }

        public RequiredCapability[] getRequiredCapabilities() {
            ArrayList<RequiredCapability> result = new ArrayList<RequiredCapability>();
            ProvidedCapability[] caps = this.wrapped.getProvidedCapabilities();
            int i = 0;
            while (i < caps.length) {
                result.add(MetadataFactory.createRequiredCapability((String)caps[i].getNamespace(), (String)caps[i].getName(), (VersionRange)new VersionRange(caps[i].getVersion(), true, caps[i].getVersion(), true), (String)this.wrapped.getFilter(), (boolean)this.optionalReqs, (boolean)false));
                ++i;
            }
            result.addAll(Arrays.asList(this.wrapped.getRequiredCapabilities()));
            return result.toArray(new RequiredCapability[result.size()]);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.wrapped == null ? 0 : this.wrapped.hashCode());
            return result;
        }

        public String toString() {
            return this.wrapped.toString();
        }

        public IArtifactKey[] getArtifacts() {
            return this.wrapped.getArtifacts();
        }

        public Map getProperties() {
            return this.wrapped.getProperties();
        }

        public ProvidedCapability[] getProvidedCapabilities() {
            return this.wrapped.getProvidedCapabilities();
        }

        public TouchpointData[] getTouchpointData() {
            return this.wrapped.getTouchpointData();
        }

        public TouchpointType getTouchpointType() {
            return this.wrapped.getTouchpointType();
        }

        public boolean isFragment() {
            return this.wrapped.isFragment();
        }

        public boolean isSingleton() {
            return this.wrapped.isSingleton();
        }

        public int compareTo(Object arg) {
            return this.wrapped.compareTo(arg);
        }

        public IInstallableUnitFragment[] getFragments() {
            return null;
        }

        public boolean isResolved() {
            return false;
        }

        public IInstallableUnit unresolved() {
            return this;
        }

        public IUpdateDescriptor getUpdateDescriptor() {
            return this.wrapped.getUpdateDescriptor();
        }

        public License getLicense() {
            return this.wrapped.getLicense();
        }

        public Copyright getCopyright() {
            return this.wrapped.getCopyright();
        }
    }
}

