/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.runtime;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import org.eclipse.jdt.internal.junit.runner.MessageSender;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import pl.poznan.put.qjunit.response.DefaultDecoratedResponseProviderFactory;
import pl.poznan.put.qjunit.runtime.MutationTestExecution;
import pl.poznan.put.qjunit.runtime.interceptor.InterceptorUtil;
import pl.poznan.put.qjunit.runtime.interceptor.ResponseProviderFactory;

public class QRemoteTestRunner
extends RemoteTestRunner {
    private Socket fClientSocket;
    private PrintWriter fWriter;
    private int fPort = -1;
    private String fHost = "";
    private boolean fDebugMode = false;
    private boolean fConsoleMode = false;

    public static void main(String[] args) {
        try {
            try {
                QRemoteTestRunner testRunServer = new QRemoteTestRunner();
                testRunServer.mutationsInit(args);
                testRunServer.init(args);
                testRunServer.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        finally {
            System.exit(0);
        }
    }

    protected void mutationsInit(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].toLowerCase().equals("-mutation.port")) {
                this.fPort = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].toLowerCase().equals("-host")) {
                this.fHost = args[i + 1];
                ++i;
            } else if (args[i].toLowerCase().equals("-debugging") || args[i].toLowerCase().equals("-debug")) {
                this.fDebugMode = true;
            } else if (args[i].toLowerCase().equals("-junitconsole")) {
                this.fConsoleMode = true;
            }
            ++i;
        }
        if (this.fPort == -1) {
            throw new IllegalArgumentException("Missing argument -mutation.port");
        }
        InterceptorUtil.INSTANCE.setResponseProviderFactory((ResponseProviderFactory)new DefaultDecoratedResponseProviderFactory());
    }

    protected boolean connect() {
        if (!super.connect()) {
            return false;
        }
        if (this.fConsoleMode) {
            this.fClientSocket = null;
            this.fWriter = new PrintWriter(System.out);
            return true;
        }
        if (this.fDebugMode) {
            System.out.println("RemoteTestRunner: trying to connect" + this.fHost + ":" + this.fPort);
        }
        IOException exception = null;
        int i = 1;
        while (i < 20) {
            try {
                this.fClientSocket = new Socket(this.fHost, this.fPort);
                try {
                    this.fWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.fClientSocket.getOutputStream(), "UTF-8")), false);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.fWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.fClientSocket.getOutputStream())), false);
                }
                return true;
            }
            catch (IOException e) {
                exception = e;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        this.runFailed("Error connecting to mutation port " + this.fHost + ":" + this.fPort, exception);
        return false;
    }

    public void runTests(String[] testClassNames, String testName, TestExecution execution) {
        MutationTestExecution wrapper = new MutationTestExecution(execution, new MutationMessageSender());
        super.runTests(testClassNames, testName, (TestExecution)wrapper);
    }

    private class MutationMessageSender
    implements MessageSender {
        MutationMessageSender() {
        }

        public void flush() {
            QRemoteTestRunner.this.fWriter.flush();
        }

        public void sendMessage(String msg) {
            if (QRemoteTestRunner.this.fWriter != null) {
                QRemoteTestRunner.this.fWriter.println(msg);
            }
        }
    }
}

