/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.runtime;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.jdt.internal.junit.runner.FailedComparison;
import org.eclipse.jdt.internal.junit.runner.IClassifiesThrowables;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.IStopListener;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import org.eclipse.jdt.internal.junit.runner.TestReferenceFailure;
import org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestReference;
import pl.poznan.put.qjunit.runtime.MutationTestListener;
import pl.poznan.put.qjunit.runtime.NextGenTestResult;
import pl.poznan.put.qjunit.runtime.QJUnitIdentifier;

public class QJUnitTestReference
implements ITestReference {
    private final Test fTest;

    public static Object getField(Object object, String fieldName) {
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public QJUnitTestReference(Test test) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.fTest = test;
    }

    public int countTestCases() {
        return this.fTest.countTestCases();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QJUnitTestReference)) {
            return false;
        }
        QJUnitTestReference ref = (QJUnitTestReference)obj;
        return ref.fTest.equals(this.fTest);
    }

    public int hashCode() {
        return this.fTest.hashCode();
    }

    public String getName() {
        if (this.isJUnit4TestCaseAdapter(this.fTest)) {
            Method method = (Method)this.callJUnit4GetterMethod(this.fTest, "getTestMethod");
            return MessageFormat.format("{0}({1})", method.getName(), method.getDeclaringClass().getName());
        }
        if (this.fTest instanceof TestCase) {
            TestCase testCase = (TestCase)this.fTest;
            return MessageFormat.format("{0}({1})", testCase.getName(), this.fTest.getClass().getName());
        }
        if (this.fTest instanceof TestSuite) {
            TestSuite suite = (TestSuite)this.fTest;
            if (suite.getName() != null) {
                return suite.getName();
            }
            return suite.getClass().getName();
        }
        if (this.fTest instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)this.fTest;
            return decorator.getClass().getName();
        }
        if (this.isJUnit4TestSuiteAdapter(this.fTest)) {
            Class testClass = (Class)this.callJUnit4GetterMethod(this.fTest, "getTestClass");
            return testClass.getName();
        }
        return this.fTest.toString();
    }

    public Test getTest() {
        return this.fTest;
    }

    public void run(TestExecution execution) {
        final NextGenTestResult testResult = new NextGenTestResult();
        testResult.addListener(new MutationTestListener(execution));
        execution.addStopListener(new IStopListener(){

            public void stop() {
                testResult.stop();
            }
        });
        NextGenTestResult tr = testResult;
        this.fTest.run((TestResult)tr);
    }

    public void sendTree(IVisitsTestTrees notified) {
        if (this.fTest instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)this.fTest;
            notified.visitTreeEntry(this.getIdentifier(), true, 1);
            this.sendTreeOfChild(decorator.getTest(), notified);
        } else if (this.fTest instanceof TestSuite) {
            TestSuite suite = (TestSuite)this.fTest;
            notified.visitTreeEntry(this.getIdentifier(), true, suite.testCount());
            int i = 0;
            while (i < suite.testCount()) {
                this.sendTreeOfChild(suite.testAt(i), notified);
                ++i;
            }
        } else if (this.isJUnit4TestSuiteAdapter(this.fTest)) {
            notified.visitTreeEntry(this.getIdentifier(), true, this.fTest.countTestCases());
            List tests = (List)this.callJUnit4GetterMethod(this.fTest, "getTests");
            Iterator iter = tests.iterator();
            while (iter.hasNext()) {
                this.sendTreeOfChild((Test)iter.next(), notified);
            }
        } else {
            notified.visitTreeEntry(this.getIdentifier(), false, this.fTest.countTestCases());
        }
    }

    void sendFailure(Throwable throwable, IClassifiesThrowables classifier, String status, IListensToTestExecutions notified) {
        TestReferenceFailure failure;
        try {
            failure = new TestReferenceFailure(this.getIdentifier(), status, classifier.getTrace(throwable));
            if (classifier.isComparisonFailure(throwable)) {
                Object expected = JUnit3TestReference.getField((Object)throwable, (String)"fExpected");
                Object actual = JUnit3TestReference.getField((Object)throwable, (String)"fActual");
                if (expected != null && actual != null) {
                    failure.setComparison(new FailedComparison((String)expected, (String)actual));
                }
            }
        }
        catch (RuntimeException e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            failure = new TestReferenceFailure(this.getIdentifier(), "%FAILED ", stringWriter.getBuffer().toString(), null);
        }
        notified.notifyTestFailed(failure);
    }

    private Object callJUnit4GetterMethod(Test test, String methodName) {
        Object result;
        try {
            Method method = test.getClass().getMethod(methodName, new Class[0]);
            result = method.invoke((Object)test, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            result = null;
        }
        return result;
    }

    private boolean isJUnit4TestCaseAdapter(Test test) {
        return test.getClass().getName().equals("junit.framework.JUnit4TestCaseAdapter");
    }

    private boolean isJUnit4TestSuiteAdapter(Test test) {
        String name = test.getClass().getName();
        return name.endsWith("JUnit4TestAdapter") && name.startsWith("junit.framework");
    }

    private void sendTreeOfChild(Test test, IVisitsTestTrees notified) {
        new QJUnitTestReference(test).sendTree(notified);
    }

    public ITestIdentifier getIdentifier() {
        return new QJUnitIdentifier(this);
    }
}

