/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor limitEditor;
    private Button enablementButton;
    private Composite editArea;

    public MarkersPreferencePage() {
    }

    public MarkersPreferencePage(String title) {
        super(title);
    }

    public MarkersPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        boolean checked = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("USE_MARKER_LIMITS");
        this.enablementButton = new Button(parent, 32);
        this.enablementButton.setText(MarkerMessages.MarkerPreferences_MarkerLimits);
        this.enablementButton.setSelection(checked);
        this.editArea = new Composite(parent, 0);
        this.editArea.setLayout((Layout)new GridLayout());
        GridData editData = new GridData(1808);
        editData.horizontalIndent = 10;
        this.editArea.setLayoutData((Object)editData);
        this.limitEditor = new IntegerFieldEditor("limit", MarkerMessages.MarkerPreferences_VisibleItems, this.editArea){

            protected boolean checkState() {
                boolean state = super.checkState();
                MarkersPreferencePage.this.setValid(state);
                return state;
            }
        };
        this.limitEditor.setPreferenceStore(IDEWorkbenchPlugin.getDefault().getPreferenceStore());
        this.limitEditor.setPreferenceName("MARKER_LIMITS_VALUE");
        this.limitEditor.load();
        GridData checkedData = new GridData(4, 0, true, false);
        checkedData.horizontalSpan = this.limitEditor.getNumberOfControls();
        this.enablementButton.setLayoutData((Object)checkedData);
        this.enablementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkersPreferencePage.this.setLimitEditorEnablement(MarkersPreferencePage.this.editArea, MarkersPreferencePage.this.enablementButton.getSelection());
            }
        });
        this.setLimitEditorEnablement(this.editArea, checked);
        return parent;
    }

    private void setLimitEditorEnablement(Composite control, boolean checked) {
        this.limitEditor.setEnabled(checked, control);
    }

    public boolean performOk() {
        this.limitEditor.store();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("USE_MARKER_LIMITS", this.enablementButton.getSelection());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.limitEditor.loadDefault();
        boolean checked = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getDefaultBoolean("USE_MARKER_LIMITS");
        this.enablementButton.setSelection(checked);
        this.setLimitEditorEnablement(this.editArea, checked);
    }
}

