/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.registry.MarkerQuery;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;

public class MarkerHelpRegistry
implements IMarkerHelpRegistry {
    private Map helpQueries = new HashMap();
    private List sortedHelpQueries;
    private Map resolutionQueries = new HashMap();
    private static final String ATT_HELP = "helpContextId";
    private static final String ATT_CLASS = "class";

    public String getHelp(IMarker marker) {
        if (this.sortedHelpQueries == null) {
            Set set = this.helpQueries.keySet();
            this.sortedHelpQueries = new ArrayList(set.size());
            this.sortedHelpQueries.addAll(set);
            Collections.sort(this.sortedHelpQueries, new QueryComparator());
        }
        Iterator iter = this.sortedHelpQueries.iterator();
        while (iter.hasNext()) {
            Iterator elements;
            Map resultsTable;
            MarkerQuery query = (MarkerQuery)iter.next();
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = (Map)this.helpQueries.get(query)).containsKey(result) || !(elements = ((Collection)resultsTable.get(result)).iterator()).hasNext()) continue;
            IConfigurationElement element = (IConfigurationElement)elements.next();
            return element.getAttribute(ATT_HELP);
        }
        return null;
    }

    public boolean hasResolutions(IMarker marker) {
        Iterator iter = this.resolutionQueries.keySet().iterator();
        while (iter.hasNext()) {
            Map resultsTable;
            MarkerQuery query = (MarkerQuery)iter.next();
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = (Map)this.resolutionQueries.get(query)).containsKey(result)) continue;
            Iterator elements = ((Collection)resultsTable.get(result)).iterator();
            while (elements.hasNext()) {
                IConfigurationElement element = (IConfigurationElement)elements.next();
                if (!this.hasResolution(marker, element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasResolution(IMarker marker, IConfigurationElement element) {
        IMarkerResolutionGenerator generator = null;
        if (Platform.getBundle((String)element.getNamespace()).getState() == 32) {
            IMarkerResolution[] resolutions;
            try {
                generator = (IMarkerResolutionGenerator)element.createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException e) {
                Policy.handle(e);
            }
            return generator != null && (generator instanceof IMarkerResolutionGenerator2 ? ((IMarkerResolutionGenerator2)generator).hasResolutions(marker) : (resolutions = generator.getResolutions(marker)).length > 0);
        }
        return true;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
        Iterator iter = this.resolutionQueries.keySet().iterator();
        while (iter.hasNext()) {
            Map resultsTable;
            MarkerQuery query = (MarkerQuery)iter.next();
            MarkerQueryResult result = query.performQuery(marker);
            if (result == null || !(resultsTable = (Map)this.resolutionQueries.get(query)).containsKey(result)) continue;
            Iterator elements = ((Collection)resultsTable.get(result)).iterator();
            while (elements.hasNext()) {
                IConfigurationElement element = (IConfigurationElement)elements.next();
                IMarkerResolutionGenerator generator = null;
                try {
                    generator = (IMarkerResolutionGenerator)element.createExecutableExtension(ATT_CLASS);
                }
                catch (CoreException e) {
                    Policy.handle(e);
                }
                if (generator == null) continue;
                IMarkerResolution[] generatedResolutions = generator.getResolutions(marker);
                int i = 0;
                while (i < generatedResolutions.length) {
                    resolutions.add(generatedResolutions[i]);
                    ++i;
                }
            }
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    public void addHelpQuery(MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        this.addQuery(this.helpQueries, query, result, element);
    }

    public void addResolutionQuery(MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        this.addQuery(this.resolutionQueries, query, result, element);
    }

    private void addQuery(Map table, MarkerQuery query, MarkerQueryResult result, IConfigurationElement element) {
        HashMap results = (HashMap)table.get(query);
        if (results == null) {
            results = new HashMap();
            table.put(query, results);
        }
        if (results.containsKey(result)) {
            Collection currentElements = (Collection)results.get(result);
            currentElements.add(element);
        } else {
            HashSet<IConfigurationElement> elements = new HashSet<IConfigurationElement>();
            elements.add(element);
            results.put(result, elements);
        }
    }

    private class QueryComparator
    implements Comparator {
        private QueryComparator() {
        }

        public boolean equals(Object o) {
            return o instanceof QueryComparator;
        }

        public int compare(Object o1, Object o2) {
            int size2;
            MarkerQuery q1 = (MarkerQuery)o1;
            MarkerQuery q2 = (MarkerQuery)o2;
            int size1 = q1.getAttributes().length;
            if (size1 > (size2 = q2.getAttributes().length)) {
                return -1;
            }
            if (size1 == size2) {
                return 0;
            }
            return 1;
        }
    }
}

