/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.model.ResourceFactory;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.statushandlers.StatusManager;

public class FilteredResourcesSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private static final String SHOW_DERIVED = "ShowDerived";
    private ShowDerivedResourcesAction showDerivedResourcesAction;
    private ResourceItemLabelProvider resourceItemLabelProvider;
    private ResourceItemDetailsLabelProvider resourceItemDetailsLabelProvider;
    private WorkingSetFilterActionGroup workingSetFilterActionGroup;
    private CustomWorkingSetFilter workingSetFilter = new CustomWorkingSetFilter();
    private String title;
    private IContainer container;
    private int typeMask;
    private boolean isDerived;

    public FilteredResourcesSelectionDialog(Shell shell, boolean multi, IContainer container, int typesMask) {
        super(shell, multi);
        this.setSelectionHistory(new ResourceSelectionHistory());
        this.setTitle(IDEWorkbenchMessages.OpenResourceDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.open_resource_dialog");
        this.container = container;
        this.typeMask = typesMask;
        this.resourceItemLabelProvider = new ResourceItemLabelProvider();
        this.resourceItemDetailsLabelProvider = new ResourceItemDetailsLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.resourceItemLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)this.resourceItemDetailsLabelProvider);
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = title;
    }

    private void setSubtitle(String text) {
        if (text == null || text.length() == 0) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(String.valueOf(this.title) + " - " + text);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        settings.put(SHOW_DERIVED, this.showDerivedResourcesAction.isChecked());
        XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
        this.workingSetFilterActionGroup.saveState((IMemento)memento);
        this.workingSetFilterActionGroup.dispose();
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            settings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "", (Throwable)e));
        }
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        boolean showDerived = settings.getBoolean(SHOW_DERIVED);
        this.showDerivedResourcesAction.setChecked(showDerived);
        this.isDerived = showDerived;
        String setting = settings.get(WORKINGS_SET_SETTINGS);
        if (setting != null) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                this.workingSetFilterActionGroup.restoreState((IMemento)memento);
            }
            catch (WorkbenchException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "", (Throwable)e));
            }
        }
        this.addListFilter(this.workingSetFilter);
        this.applyFilter();
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        this.showDerivedResourcesAction = new ShowDerivedResourcesAction();
        menuManager.add((IAction)this.showDerivedResourcesAction);
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
                    if (!(workingSet == null || workingSet.isAggregateWorkingSet() && workingSet.isEmpty())) {
                        FilteredResourcesSelectionDialog.this.workingSetFilter.setWorkingSet(workingSet);
                        FilteredResourcesSelectionDialog.this.setSubtitle(workingSet.getLabel());
                    } else {
                        IWorkbenchPage page;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (workingSet = (page = window.getActivePage()).getAggregateWorkingSet()).isAggregateWorkingSet() && workingSet.isEmpty()) {
                            workingSet = null;
                        }
                        FilteredResourcesSelectionDialog.this.workingSetFilter.setWorkingSet(workingSet);
                        FilteredResourcesSelectionDialog.this.setSubtitle(null);
                    }
                    FilteredResourcesSelectionDialog.this.scheduleRefresh();
                }
            }
        });
        menuManager.add((IContributionItem)new Separator());
        this.workingSetFilterActionGroup.fillContextMenu(menuManager);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null) {
            return null;
        }
        ArrayList<Object> resultToReturn = new ArrayList<Object>();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof IResource) {
                resultToReturn.add(result[i]);
            }
            ++i;
        }
        return resultToReturn.toArray();
    }

    public int open() {
        IWorkspace workspace;
        IStatus result;
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        if (this.getInitialPattern() == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0 && (result = (workspace = ResourcesPlugin.getWorkspace()).validateName(text, 1)).isOK()) {
            this.setInitialPattern(text);
        }
        return super.open();
    }

    public String getElementName(Object item) {
        IResource resource = (IResource)item;
        return resource.getName();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, WorkbenchPlugin.PI_WORKBENCH, 0, "", null);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ResourceFilter(this.container, this.isDerived, this.typeMask);
    }

    protected void applyFilter() {
        super.applyFilter();
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                String s2;
                Collator collator = Collator.getInstance();
                IResource resource1 = (IResource)o1;
                IResource resource2 = (IResource)o2;
                String s1 = resource1.getName();
                int comparability = collator.compare(s1, s2 = resource2.getName());
                if (comparability == 0) {
                    IPath p1 = resource1.getFullPath();
                    IPath p2 = resource2.getFullPath();
                    int c1 = p1.segmentCount();
                    int c2 = p2.segmentCount();
                    int i = 0;
                    while (i < c1 && i < c2) {
                        comparability = collator.compare(p1.segment(i), p2.segment(i));
                        if (comparability != 0) {
                            return comparability;
                        }
                        ++i;
                    }
                    comparability = c2 - c1;
                }
                return comparability;
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (itemsFilter instanceof ResourceFilter) {
            this.container.accept((IResourceProxyVisitor)new ResourceProxyVisitor(contentProvider, (ResourceFilter)itemsFilter, progressMonitor), 0);
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    private class CustomWorkingSetFilter
    extends ViewerFilter {
        private ResourceWorkingSetFilter resourceWorkingSetFilter = new ResourceWorkingSetFilter();

        private CustomWorkingSetFilter() {
        }

        public IWorkingSet getWorkingSet() {
            return this.resourceWorkingSetFilter.getWorkingSet();
        }

        public void setWorkingSet(IWorkingSet workingSet) {
            this.resourceWorkingSetFilter.setWorkingSet(workingSet);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.resourceWorkingSetFilter.select(viewer, parentElement, element);
        }
    }

    protected class ResourceFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private boolean showDerived = false;
        private IContainer filterContainer;
        private int filterTypeMask;

        public ResourceFilter(IContainer container, boolean showDerived, int typeMask) {
            super((FilteredItemsSelectionDialog)FilteredResourcesSelectionDialog.this);
            this.filterContainer = container;
            this.showDerived = showDerived;
            this.filterTypeMask = typeMask;
        }

        public ResourceFilter() {
            super((FilteredItemsSelectionDialog)FilteredResourcesSelectionDialog.this);
            this.filterContainer = FilteredResourcesSelectionDialog.this.container;
            this.showDerived = FilteredResourcesSelectionDialog.this.isDerived;
            this.filterTypeMask = FilteredResourcesSelectionDialog.this.typeMask;
        }

        public boolean isConsistentItem(Object item) {
            if (!(item instanceof IResource)) {
                return false;
            }
            IResource resource = (IResource)item;
            return this.filterContainer.findMember(resource.getFullPath()) != null;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IResource)) {
                return false;
            }
            IResource resource = (IResource)item;
            if (!this.showDerived && resource.isDerived() || (this.filterTypeMask & resource.getType()) == 0) {
                return false;
            }
            return this.matches(resource.getName());
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            return filter instanceof ResourceFilter && this.showDerived == ((ResourceFilter)filter).showDerived;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
            if (!super.equalsFilter(iFilter)) {
                return false;
            }
            return iFilter instanceof ResourceFilter && this.showDerived == ((ResourceFilter)iFilter).showDerived;
        }

        public boolean isShowDerived() {
            return this.showDerived;
        }
    }

    private class ResourceItemDetailsLabelProvider
    extends ResourceItemLabelProvider {
        private ResourceItemDetailsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IContainer parent = ((IResource)element).getParent();
            Image img = this.provider.getImage((Object)parent);
            return this.decorator.decorateImage(img, (Object)parent);
        }

        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IContainer parent = ((IResource)element).getParent();
            if (parent.getType() == 8) {
                return this.decorator.decorateText(null, (Object)parent);
            }
            return this.decorator.decorateText(parent.getFullPath().makeRelative().toString(), (Object)parent);
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = ((ResourceItemLabelProvider)this).listeners.getListeners();
            int i = 0;
            while (i < ((ResourceItemLabelProvider)this).listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private class ResourceItemLabelProvider
    extends LabelProvider
    implements ILabelProviderListener {
        private ListenerList listeners = new ListenerList();
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();

        public ResourceItemLabelProvider() {
            this.provider.addListener((ILabelProviderListener)this);
            this.decorator.addListener((ILabelProviderListener)this);
        }

        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IResource res = (IResource)element;
            Image img = this.provider.getImage((Object)res);
            return this.decorator.decorateImage(img, (Object)res);
        }

        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IResource res = (IResource)element;
            String str = res.getName();
            if (FilteredResourcesSelectionDialog.this.isDuplicateElement(element)) {
                str = String.valueOf(str) + " - " + res.getParent().getFullPath().makeRelative().toString();
            }
            return this.decorator.decorateText(str, (Object)res);
        }

        public void dispose() {
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            this.decorator.removeListener((ILabelProviderListener)this);
            this.decorator.dispose();
            super.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private FilteredItemsSelectionDialog.AbstractContentProvider proxyContentProvider;
        private ResourceFilter resourceFilter;
        private IProgressMonitor progressMonitor;
        private List projects;

        public ResourceProxyVisitor(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, ResourceFilter resourceFilter, IProgressMonitor progressMonitor) throws CoreException {
            this.proxyContentProvider = contentProvider;
            this.resourceFilter = resourceFilter;
            this.progressMonitor = progressMonitor;
            IResource[] resources = FilteredResourcesSelectionDialog.this.container.members();
            this.projects = new ArrayList<IResource>(Arrays.asList(resources));
            if (progressMonitor != null) {
                progressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_searchJob_taskName, this.projects.size());
            }
        }

        public boolean visit(IResourceProxy proxy) {
            if (this.progressMonitor.isCanceled()) {
                return false;
            }
            IResource resource = proxy.requestResource();
            if (this.projects.remove(resource.getProject()) || this.projects.remove(resource)) {
                this.progressMonitor.worked(1);
            }
            this.proxyContentProvider.add((Object)resource, (FilteredItemsSelectionDialog.ItemsFilter)this.resourceFilter);
            if (resource.getType() == 2 && resource.isDerived() && !this.resourceFilter.isShowDerived()) {
                return false;
            }
            return resource.getType() != 1;
        }
    }

    private class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            ResourceFactory resourceFactory = new ResourceFactory();
            IResource resource = (IResource)resourceFactory.createElement(element);
            return resource;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            IResource resource = (IResource)item;
            ResourceFactory resourceFactory = new ResourceFactory(resource);
            resourceFactory.saveState(element);
        }
    }

    private class ShowDerivedResourcesAction
    extends Action {
        public ShowDerivedResourcesAction() {
            super(IDEWorkbenchMessages.FilteredResourcesSelectionDialog_showDerivedResourcesAction, 2);
        }

        public void run() {
            FilteredResourcesSelectionDialog.this.isDerived = this.isChecked();
            FilteredResourcesSelectionDialog.this.applyFilter();
        }
    }
}

