/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import org.eclipse.jface.internal.text.AccessorUtil;
import org.eclipse.jface.internal.text.IInformationControlReplacer;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class StickyHoverManager
extends AbstractInformationControlManager
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension,
IInformationControlReplacer {
    private static final int WIDGET_PRIORITY = -5;
    private static final int MIN_WIDTH = 80;
    private static final int MIN_HEIGHT = 50;
    private TextViewer fTextViewer;
    private boolean fIsReplacing;
    private Object fReplacableInformation;
    private boolean fDelayedInformationSet;
    private Rectangle fReplaceableArea;
    private Rectangle fContentBounds;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StickyHoverManager(TextViewer textViewer) {
        super(new DefaultInformationControlCreator());
        this.fTextViewer = textViewer;
        this.setCloser(new Closer());
        this.takesFocusWhenVisible(false);
        this.install((Control)this.fTextViewer.getTextWidget());
    }

    protected void computeInformation() {
        if (this.fIsReplacing && this.fReplacableInformation != null) {
            this.setInformation(this.fReplacableInformation, this.fReplaceableArea);
            return;
        }
        if (DEBUG) {
            System.out.println("StickyHover: no active replaceable");
        }
    }

    protected void showInformationControl(Rectangle subjectArea) {
        if (this.fTextViewer != null && this.fTextViewer.requestWidgetToken(this, -5)) {
            super.showInformationControl(subjectArea);
        } else if (DEBUG) {
            System.out.println("cancelled StickyHoverManager.showInformationControl(..): did not get widget token (with prio)");
        }
    }

    protected void hideInformationControl() {
        try {
            super.hideInformationControl();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        this.hideInformationControl();
        if (DEBUG) {
            System.out.println("StickyHoverManager gave up widget token (no prio)");
        }
        return true;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        if (this.getCurrentInformationControl2() != null) {
            if (this.getCurrentInformationControl2().isFocusControl()) {
                if (DEBUG) {
                    System.out.println("StickyHoverManager kept widget token (focused)");
                }
                return false;
            }
            if (priority > -5) {
                this.hideInformationControl();
                if (DEBUG) {
                    System.out.println("StickyHoverManager gave up widget token (prio)");
                }
                return true;
            }
            if (DEBUG) {
                System.out.println("StickyHoverManager kept widget token (prio)");
            }
            return false;
        }
        if (DEBUG) {
            System.out.println("StickyHoverManager gave up widget token (no iControl)");
        }
        return true;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        IInformationControl iControl = this.getCurrentInformationControl2();
        if (iControl instanceof IInformationControlExtension5) {
            IInformationControlExtension5 iControl5 = (IInformationControlExtension5)((Object)iControl);
            if (iControl5.isVisible()) {
                iControl.setFocus();
                return iControl.isFocusControl();
            }
            return false;
        }
        iControl.setFocus();
        return iControl.isFocusControl();
    }

    public void replaceInformationControl(IInformationControlCreator informationPresenterControlCreator, Rectangle contentBounds, Object information, Rectangle subjectArea, boolean takeFocus) {
        try {
            this.fIsReplacing = true;
            if (!this.fDelayedInformationSet) {
                this.fReplacableInformation = information;
            } else {
                takeFocus = true;
            }
            this.fContentBounds = contentBounds;
            this.fReplaceableArea = subjectArea;
            this.setCustomInformationControlCreator(informationPresenterControlCreator);
            this.takesFocusWhenVisible(takeFocus);
            this.showInformation();
        }
        finally {
            this.fIsReplacing = false;
            this.fReplacableInformation = null;
            this.fDelayedInformationSet = false;
            this.fReplaceableArea = null;
            this.setCustomInformationControlCreator(null);
        }
    }

    public void internalShowInformationControl2(Rectangle subjectArea, Object information) {
        IInformationControl informationControl = this.getInformationControl();
        Rectangle controlBounds = this.fContentBounds;
        if (informationControl instanceof IInformationControlExtension3) {
            Class<?> clazz;
            IInformationControlExtension3 iControl3 = (IInformationControlExtension3)((Object)informationControl);
            Rectangle trim = iControl3.computeTrim();
            controlBounds = Geometry.add((Rectangle)controlBounds, (Rectangle)trim);
            controlBounds.width = Math.max(controlBounds.width, 80);
            controlBounds.height = Math.max(controlBounds.height, 50);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.jface.text.AbstractInformationControlManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Rectangle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            AccessorUtil.invoke((Object)this, clazz2, "cropToClosestMonitor", clazz, controlBounds);
        }
        Point location = Geometry.getLocation((Rectangle)controlBounds);
        Point size = Geometry.getSize((Rectangle)controlBounds);
        informationControl.setSizeConstraints(size.x, size.y);
        if (informationControl instanceof IInformationControlExtension2) {
            ((IInformationControlExtension2)((Object)informationControl)).setInput(information);
        } else {
            informationControl.setInformation(information.toString());
        }
        informationControl.setLocation(location);
        informationControl.setSize(size.x, size.y);
        this.showInformationControl(subjectArea);
    }

    public void setDelayedInput(Object input) {
        this.fReplacableInformation = input;
        if (!this.isReplacing()) {
            this.fDelayedInformationSet = true;
        } else if (this.getCurrentInformationControl2() instanceof IInformationControlExtension2) {
            ((IInformationControlExtension2)((Object)this.getCurrentInformationControl2())).setInput(input);
        } else if (this.getCurrentInformationControl2() != null) {
            this.getCurrentInformationControl2().setInformation(input.toString());
        }
    }

    public int getKeepUpMargin() {
        return 15;
    }

    public boolean isReplacing() {
        return this.fIsReplacing;
    }

    public IInformationControl getCurrentInformationControl2() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.AbstractInformationControlManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInformationControl)AccessorUtil.invoke(this, clazz, "getCurrentInformationControl");
    }

    static /* synthetic */ boolean access$1() {
        return AbstractInformationControlManager.DEBUG;
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    IViewportListener,
    KeyListener,
    FocusListener,
    Listener {
        private Control fSubjectControl;
        private boolean fIsActive = false;
        private Display fDisplay;

        Closer() {
        }

        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        public void setInformationControl(IInformationControl control) {
        }

        public void start(Rectangle informationArea) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
            StickyHoverManager.this.fTextViewer.addViewportListener(this);
            IInformationControl fInformationControlToClose = StickyHoverManager.this.getCurrentInformationControl2();
            if (fInformationControlToClose != null) {
                fInformationControlToClose.addFocusListener(this);
            }
            this.fDisplay = this.fSubjectControl.getDisplay();
            if (!this.fDisplay.isDisposed()) {
                this.fDisplay.addFilter(5, (Listener)this);
                this.fDisplay.addFilter(16, (Listener)this);
            }
        }

        public void stop() {
            IInformationControl fInformationControlToClose;
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            StickyHoverManager.this.fTextViewer.removeViewportListener(this);
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
            if ((fInformationControlToClose = StickyHoverManager.this.getCurrentInformationControl2()) != null) {
                fInformationControlToClose.removeFocusListener(this);
            }
            if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                this.fDisplay.removeFilter(5, (Listener)this);
                this.fDisplay.removeFilter(16, (Listener)this);
            }
            this.fDisplay = null;
        }

        public void controlResized(ControlEvent e) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent e) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void mouseDown(MouseEvent e) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void viewportChanged(int topIndex) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void keyPressed(KeyEvent e) {
            StickyHoverManager.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (StickyHoverManager.access$1()) {
                System.out.println("StickyHoverManager.Closer.focusLost(): " + e);
            }
            Display d = this.fSubjectControl.getDisplay();
            d.asyncExec(new Runnable(this){
                final /* synthetic */ Closer this$1;
                {
                    this.this$1 = closer;
                }

                public void run() {
                    Closer.access$0(this.this$1).hideInformationControl();
                }
            });
        }

        public void handleEvent(Event event) {
            if (event.type == 5) {
                if (!(event.widget instanceof Control) || event.widget.isDisposed()) {
                    return;
                }
                IInformationControl infoControl = StickyHoverManager.this.getCurrentInformationControl2();
                if (infoControl != null && !infoControl.isFocusControl() && infoControl instanceof IInformationControlExtension3) {
                    IInformationControlExtension3 iControl3 = (IInformationControlExtension3)((Object)infoControl);
                    Rectangle controlBounds = iControl3.getBounds();
                    if (controlBounds != null) {
                        Point mouseLoc = event.display.map((Control)event.widget, null, event.x, event.y);
                        int margin = StickyHoverManager.this.getKeepUpMargin();
                        Geometry.expand((Rectangle)controlBounds, (int)margin, (int)margin, (int)margin, (int)margin);
                        if (!controlBounds.contains(mouseLoc)) {
                            StickyHoverManager.this.hideInformationControl();
                        }
                    }
                } else if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                    this.fDisplay.removeFilter(5, (Listener)this);
                }
            } else if (event.type == 16) {
                IInformationControl iControl;
                if (StickyHoverManager.access$1()) {
                    System.out.println("StickyHoverManager.Closer.handleEvent(): focusOut: " + event);
                }
                if ((iControl = StickyHoverManager.this.getCurrentInformationControl2()) != null && !iControl.isFocusControl()) {
                    StickyHoverManager.this.hideInformationControl();
                }
            }
        }

        static /* synthetic */ StickyHoverManager access$0(Closer closer) {
            return closer.StickyHoverManager.this;
        }
    }

    private static class DefaultInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        private DefaultInformationControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            return new DefaultInformationControl(shell, true);
        }
    }
}

