/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.equinox;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxLauncherData;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Log;
import org.eclipse.equinox.internal.frameworkadmin.equinox.utils.FileUtils;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;

public class EclipseLauncherParser {
    private String[] getConfigFileLines(LauncherData launcherData, File outputFile, boolean relative) {
        String[] jvmArgs;
        LinkedList<String> lines = new LinkedList<String>();
        boolean startUpFlag = false;
        String[] programArgs = launcherData.getProgramArgs();
        if (programArgs != null && programArgs.length != 0) {
            int i = 0;
            while (i < programArgs.length) {
                if (programArgs[i].equals("-startup") && (programArgs[i + 1] != null || programArgs[i + 1].length() != 0)) {
                    lines.add(programArgs[i]);
                    lines.add(programArgs[++i]);
                    startUpFlag = true;
                } else {
                    lines.add(programArgs[i]);
                }
                ++i;
            }
        }
        if (launcherData.isClean()) {
            lines.add("-clean");
        }
        File fwPersistentDataLocation = launcherData.getFwPersistentDataLocation();
        File fwConfigLocation = launcherData.getFwConfigLocation();
        if (fwPersistentDataLocation != null) {
            if (fwConfigLocation != null && !fwPersistentDataLocation.equals(fwConfigLocation)) {
                throw new IllegalStateException();
            }
            launcherData.setFwConfigLocation(fwPersistentDataLocation);
        } else if (fwConfigLocation != null) {
            launcherData.setFwPersistentDataLocation(fwConfigLocation, launcherData.isClean());
        }
        if (launcherData.getFwConfigLocation() != null) {
            lines.add("-configuration");
            lines.add(launcherData.getFwConfigLocation().getAbsolutePath());
        }
        if (!startUpFlag && launcherData.getFwJar() != null) {
            lines.add("-framework");
            String path = "";
            path = launcherData.getFwJar().getAbsolutePath();
            lines.add(path);
        }
        if (launcherData.getJvm() != null) {
            lines.add("-vm");
            lines.add(launcherData.getJvm().getAbsolutePath());
        }
        if ((jvmArgs = launcherData.getJvmArgs()) != null && jvmArgs.length != 0) {
            lines.add("-vmargs");
            int i = 0;
            while (i < jvmArgs.length) {
                lines.add(jvmArgs[i]);
                ++i;
            }
        }
        String[] ret = new String[lines.size()];
        lines.toArray(ret);
        return ret;
    }

    private void parseCmdLine(LauncherData launcherData, String[] lines) {
        String location;
        File launcherConfigFile = EquinoxManipulatorImpl.getLauncherConfigLocation(launcherData);
        boolean clean = launcherData.isClean();
        boolean needToUpdate = false;
        File fwPersistentDataLoc = launcherData.getFwPersistentDataLocation();
        File fwConfigLocation = launcherData.getFwConfigLocation();
        if (fwPersistentDataLoc == null) {
            if (fwConfigLocation == null) {
                fwConfigLocation = fwPersistentDataLoc = new File(launcherConfigFile.getParent(), "configuration");
                needToUpdate = true;
            } else {
                fwPersistentDataLoc = fwConfigLocation;
                needToUpdate = true;
            }
        } else if (fwConfigLocation == null) {
            fwConfigLocation = fwPersistentDataLoc;
            needToUpdate = true;
        }
        File fwJar = launcherData.getFwJar();
        if (fwJar == null && (location = FileUtils.getEclipsePluginFullLocation("org.eclipse.osgi", new File(launcherConfigFile.getParent(), "plugins"))) != null) {
            try {
                fwJar = new File(new URL(location).getFile());
                launcherData.setFwJar(fwJar);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        boolean vmArgsFlag = false;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            if (!line.startsWith("#") && line.length() != 0) {
                String nextLine;
                File file;
                if (tokenizer.countTokens() != 1) {
                    Log.log(2, (Object)this, "parseCmdLine(String[] lines, File inputFile)", "Illegal Format:line=" + line + "tokenizer.countTokens()=" + tokenizer.countTokens());
                }
                if (vmArgsFlag) {
                    launcherData.addJvmArg(line);
                } else if (line.equalsIgnoreCase("-vmargs")) {
                    vmArgsFlag = true;
                } else if (line.equalsIgnoreCase("-configuration")) {
                    if (!(file = new File(nextLine = lines[++i].trim())).isAbsolute()) {
                        file = new File(String.valueOf(launcherConfigFile.getParent()) + File.separator + nextLine);
                    }
                    fwPersistentDataLoc = file;
                    needToUpdate = true;
                } else if (line.equalsIgnoreCase("-clean")) {
                    clean = true;
                    needToUpdate = true;
                } else if (line.equalsIgnoreCase("-vm")) {
                    if (!(file = new File(nextLine = lines[++i].trim())).isAbsolute()) {
                        file = new File(String.valueOf(launcherConfigFile.getAbsolutePath()) + File.separator + nextLine);
                    }
                    launcherData.setJvm(file);
                } else if (line.equalsIgnoreCase("-framework")) {
                    if (!(file = new File(nextLine = lines[++i].trim())).isAbsolute()) {
                        file = new File(String.valueOf(launcherConfigFile.getAbsolutePath()) + File.separator + nextLine);
                    }
                    launcherData.setFwJar(file);
                } else {
                    launcherData.addProgramArg(lines[i]);
                }
            }
            ++i;
        }
        if (needToUpdate) {
            launcherData.setFwPersistentDataLocation(fwPersistentDataLoc, clean);
            launcherData.setFwConfigLocation(fwPersistentDataLoc);
        }
    }

    public void read(LauncherData launcherData) throws IOException {
        File launcherConfigFile = EquinoxManipulatorImpl.getLauncherConfigLocation(launcherData);
        if (launcherConfigFile == null) {
            throw new IllegalStateException("launcherData.getLauncherConfigFile() should be set in advance.");
        }
        if (!launcherConfigFile.exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(launcherConfigFile));
            LinkedList<String> list = new LinkedList<String>();
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            String[] lines = list.toArray(new String[list.size()]);
            String osgiInstallArea = this.getLauncher(lines) != null ? EquinoxManipulatorImpl.makeAbsolute(this.getLauncher(lines).getPath(), launcherData.getLauncher().getParentFile().getAbsolutePath()) : null;
            String resolveNextLine = null;
            int i = 0;
            while (i < lines.length) {
                if (resolveNextLine != null) {
                    lines[i] = EquinoxManipulatorImpl.makeAbsolute(lines[i], resolveNextLine);
                    resolveNextLine = null;
                } else {
                    resolveNextLine = this.needsPathResolution(lines[i], osgiInstallArea, String.valueOf(launcherData.getLauncher().getParentFile().getAbsolutePath()) + File.separator);
                }
                ++i;
            }
            this.parseCmdLine(launcherData, lines);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        Log.log(3, "Launcher Config file(" + launcherConfigFile.getAbsolutePath() + ") is read successfully.");
    }

    private File getLauncher(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-startup") && i + 1 < args.length && args[i + 1].charAt(1) != '-') {
                IPath parentFolder = new Path(args[i + 1]).removeLastSegments(1);
                if (parentFolder.lastSegment().equals("plugins")) {
                    return parentFolder.removeLastSegments(1).toFile();
                }
                return parentFolder.toFile();
            }
            ++i;
        }
        return null;
    }

    private String needsPathResolution(String entry, String osgiInstallArea, String launcherFolder) {
        if ("-configuration".equalsIgnoreCase(entry)) {
            return osgiInstallArea;
        }
        if ("--launcher.library".equalsIgnoreCase(entry)) {
            return launcherFolder;
        }
        if ("-startup".equalsIgnoreCase(entry)) {
            return launcherFolder;
        }
        if ("-framework".equalsIgnoreCase(entry)) {
            return osgiInstallArea != null ? osgiInstallArea : launcherFolder;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void save(EquinoxLauncherData launcherData, boolean relative, boolean backup) throws IOException {
        launcherConfigFile = EquinoxManipulatorImpl.getLauncherConfigLocation(launcherData);
        if (launcherConfigFile == null) {
            throw new IllegalStateException("launcherConfigFile cannot be set. launcher file should be set in advance.");
        }
        Utils.createParentDir((File)launcherConfigFile);
        if (backup && launcherConfigFile.exists()) {
            dest = Utils.getSimpleDataFormattedFile((File)launcherConfigFile);
            if (!launcherConfigFile.renameTo(dest)) {
                throw new IOException("Fail to rename from (" + launcherConfigFile + ") to (" + dest + ")");
            }
            Log.log(3, (Object)this, "saveConfigs()", "Succeed to rename from (" + launcherConfigFile + ") to (" + dest + ")");
        }
        bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(launcherConfigFile));
            lines = this.getConfigFileLines(launcherData, launcherConfigFile, relative);
            osgiInstallArea = this.getLauncher(lines) != null ? EquinoxManipulatorImpl.makeAbsolute(this.getLauncher(lines).getPath(), launcherData.getLauncher().getParentFile().getAbsolutePath()) : launcherData.getLauncher().getParentFile().getAbsolutePath();
            resolveNextLine = null;
            i = 0;
            while (i < lines.length) {
                block14: {
                    if (resolveNextLine == null) break block14;
                    lines[i] = EquinoxManipulatorImpl.makeRelative(lines[i], resolveNextLine);
                    resolveNextLine = null;
                    ** GOTO lbl40
                }
                resolveNextLine = this.needsPathResolution(lines[i], osgiInstallArea, String.valueOf(launcherData.getLauncher().getParentFile().getAbsolutePath()) + File.separator);
                if (!"-configuration".equalsIgnoreCase(lines[i])) ** GOTO lbl40
                resolveNextLine = null;
                if (new Path(lines[i + 1]).removeLastSegments(1).equals((Object)new Path(osgiInstallArea))) {
                    ++i;
                } else {
                    osgiPath = new Path(osgiInstallArea);
                    configLocation = new Path(lines[i + 1]);
                    commonSegments = osgiPath.matchingFirstSegments(configLocation.removeLastSegments(1));
                    if (commonSegments == configLocation.segmentCount() - 1) {
                        path = "";
                        j = osgiPath.segmentCount() - commonSegments;
                        while (j != 0) {
                            path = String.valueOf(path) + "../";
                            --j;
                        }
                        lines[i + 1] = path = String.valueOf(path) + "configuration";
                    }
lbl40:
                    // 5 sources

                    bw.write(lines[i]);
                    bw.newLine();
                }
                ++i;
            }
            bw.flush();
            Log.log(3, "Launcher Config file is saved successfully into:" + launcherConfigFile);
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (launcherData.getPreviousLauncherIni() != null) {
                launcherData.getPreviousLauncherIni().delete();
            }
        }
    }
}

