/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.P2Utils;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;

public class PluginPathFinder {
    private static final String URL_PROPERTY = "org.eclipse.update.resolution_url";
    private static final String EMPTY_STRING = "";

    private static String getSitePath(String platformHome, File linkFile, boolean features) {
        String prefix = new Path(platformHome).removeLastSegments(1).toString();
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(linkFile);
            properties.load(fis);
            fis.close();
            String path = properties.getProperty("path");
            if (path != null) {
                if (!new Path(path).isAbsolute()) {
                    path = String.valueOf(prefix) + '/' + path;
                }
                path = String.valueOf(path) + "/eclipse/";
                path = features ? String.valueOf(path) + "features" : String.valueOf(path) + "plugins";
                if (new File(path).exists()) {
                    return path;
                }
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static File[] getSites(String platformHome, boolean features) {
        File[] linkFiles;
        ArrayList<File> sites = new ArrayList<File>();
        File file = new File(platformHome, features ? "features" : "plugins");
        if (!features && !file.exists()) {
            file = new File(platformHome);
        }
        if (file.exists()) {
            sites.add(file);
        }
        if ((linkFiles = new File(String.valueOf(platformHome) + '/' + "links").listFiles()) != null) {
            int i = 0;
            while (i < linkFiles.length) {
                String path = PluginPathFinder.getSitePath(platformHome, linkFiles[i], features);
                if (path != null) {
                    sites.add(new File(path));
                }
                ++i;
            }
        }
        return sites.toArray(new File[sites.size()]);
    }

    public static File[] getFeaturePaths(String platformHome) {
        return PluginPathFinder.getPaths(platformHome, true, false);
    }

    public static File[] getPluginPaths(String platformHome, boolean filterP2Base) {
        return PluginPathFinder.getPaths(platformHome, false, filterP2Base);
    }

    public static File[] getPluginPaths(String platformHome) {
        return PluginPathFinder.getPaths(platformHome, false, false);
    }

    public static File[] getPaths(String platformHome, boolean features, boolean filterP2Base) {
        block8: {
            URL[] urls;
            if (filterP2Base && (urls = P2Utils.readBundlesTxt(platformHome)) != null) {
                return Utils.asFile(urls);
            }
            File file = new File(platformHome, "configuration/org.eclipse.update/platform.xml");
            if (file.exists()) {
                File[] fileArray;
                String value = new Path(platformHome).toFile().toURL().toExternalForm();
                System.setProperty(URL_PROPERTY, value);
                try {
                    IPlatformConfiguration config = ConfiguratorUtils.getPlatformConfiguration((URL)file.toURL());
                    fileArray = Utils.asFile(PluginPathFinder.getConfiguredSitesPaths(platformHome, config, features));
                }
                catch (Throwable throwable) {
                    try {
                        System.setProperty(URL_PROPERTY, EMPTY_STRING);
                        throw throwable;
                    }
                    catch (MalformedURLException malformedURLException) {
                        break block8;
                    }
                    catch (IOException iOException) {}
                }
                System.setProperty(URL_PROPERTY, EMPTY_STRING);
                return fileArray;
            }
        }
        return Utils.asFile(PluginPathFinder.scanLocations(PluginPathFinder.getSites(platformHome, features)));
    }

    private static URL[] getConfiguredSitesPaths(String platformHome, IPlatformConfiguration configuration, boolean features) {
        List installPlugins = PluginPathFinder.scanLocations(new File[]{new File(platformHome, features ? "features" : "plugins")});
        List extensionPlugins = PluginPathFinder.getExtensionPluginURLs(configuration, features);
        LinkedHashSet all = new LinkedHashSet();
        all.addAll(installPlugins);
        all.addAll(extensionPlugins);
        return all.toArray(new URL[all.size()]);
    }

    private static List getExtensionPluginURLs(IPlatformConfiguration config, boolean features) {
        ArrayList<URL> extensionPlugins = new ArrayList<URL>();
        IPlatformConfiguration.ISiteEntry[] sites = config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            URL url = sites[i].getURL();
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                String[] entries = features ? sites[i].getFeatures() : sites[i].getPlugins();
                int j = 0;
                while (j < entries.length) {
                    try {
                        extensionPlugins.add(new File(url.getFile(), entries[j]).toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++j;
                }
            }
            ++i;
        }
        return extensionPlugins;
    }

    private static List scanLocations(File[] sites) {
        ArrayList<URL> result = new ArrayList<URL>();
        int i = 0;
        while (i < sites.length) {
            File[] children;
            if (sites[i].exists() && (children = sites[i].listFiles()) != null) {
                int j = 0;
                while (j < children.length) {
                    try {
                        result.add(children[j].toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }
}

