/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.builder.BuildDirector;
import org.eclipse.pde.internal.build.site.P2Utils;
import org.eclipse.pde.internal.build.site.PDEState;

public class ProductGenerator
extends AbstractScriptGenerator {
    private static final String BUNDLE_EQUINOX_COMMON = "org.eclipse.equinox.common";
    private static final String BUNDLE_OSGI = "org.eclipse.osgi";
    private static final String BUNDLE_EQUINOX_LAUNCHER = "org.eclipse.equinox.launcher";
    private static final String BUNDLE_CORE_RUNTIME = "org.eclipse.core.runtime";
    private static final String BUNDLE_UPDATE_CONFIGURATOR = "org.eclipse.update.configurator";
    private static final String BUNDLE_SIMPLE_CONFIGURATOR = "org.eclipse.equinox.simpleconfigurator";
    private static final String SIMPLE_CONFIGURATOR_CONFIG_URL = "org.eclipse.equinox.simpleconfigurator.configUrl";
    private static final String START_LEVEL_1 = "@1:start";
    private static final String START_LEVEL_2 = "@2:start";
    private static final String START_LEVEL_3 = "@3:start";
    private static final String START = "@start";
    private static final byte CONFIG_STYLE_ORIGINAL = 1;
    private static final byte CONFIG_STYLE_REFACTORED = 2;
    private static final byte CONFIG_STYLE_SIMPLE = 4;
    private static final byte CONFIG_STYLE_UPDATE = 8;
    private String product = null;
    private ProductFile productFile = null;
    private String root = null;
    private Properties buildProperties;
    private BuildDirector director = null;

    public void generate() throws CoreException {
        this.initialize();
        if (this.productFile == null) {
            return;
        }
        if (this.productFile.getId() == null) {
            return;
        }
        String location = null;
        String fileList = null;
        Iterator iter = ProductGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            String custom;
            Config config = (Config)iter.next();
            location = "productRootFiles/" + config.toStringReplacingAny(".", "ANY");
            String rootLocation = String.valueOf(this.root) + location;
            File rootDir = new File(rootLocation);
            if (!rootDir.exists() && !rootDir.mkdirs() || rootDir.isFile()) continue;
            if (this.buildProperties != null) {
                fileList = this.buildProperties.getProperty("root." + config.toString("."), "");
                fileList = String.valueOf(fileList) + (fileList.length() > 0 ? String.valueOf(',') + location : location);
                this.buildProperties.put("root." + config.toString("."), fileList);
            }
            if ((custom = this.findConfigFile(config.getOs())) != null) {
                this.copyFile(custom, String.valueOf(rootLocation) + "/configuration/config.ini");
            } else {
                this.createConfigIni(config, rootLocation);
            }
            if (config.getOs().equals(Config.ANY)) continue;
            this.createEclipseProductFile(rootLocation);
            this.createLauncherIniFile(rootLocation, config.getOs());
        }
    }

    private String findConfigFile(String os) {
        String path = this.productFile.getConfigIniPath(os);
        if (path == null) {
            return null;
        }
        String result = this.findFile(path, false);
        if (result != null) {
            return result;
        }
        File f = new File(path);
        if (f.exists() && f.isFile()) {
            return f.getAbsolutePath();
        }
        f = new File(ProductGenerator.getWorkingDirectory(), path);
        if (f.exists() && f.isFile()) {
            return f.getAbsolutePath();
        }
        f = new File(String.valueOf(ProductGenerator.getWorkingDirectory()) + "/" + "plugins", path);
        if (f.exists() && f.isFile()) {
            return f.getAbsolutePath();
        }
        f = new File(new File(this.productFile.getLocation()).getParent(), path);
        if (f.exists() && f.isFile()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private void initialize() throws CoreException {
        this.productFile = this.loadProduct(this.product);
    }

    private void copyFile(String src, String dest) {
        block26: {
            File source = new File(src);
            if (!source.exists()) {
                return;
            }
            File destination = new File(dest);
            File destDir = destination.getParentFile();
            if (!destDir.exists() && !destDir.mkdirs() || destDir.isFile()) {
                return;
            }
            InputStream in = null;
            OutputStream out = null;
            try {
                try {
                    int len;
                    in = new BufferedInputStream(new FileInputStream(source));
                    out = new BufferedOutputStream(new FileOutputStream(destination));
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (IOException iOException) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private byte determineConfigStyle(Config config) throws CoreException {
        int result = 0;
        PDEState state = this.getSite(false).getRegistry();
        Collection bundles = this.director.getAssemblyData().getPlugins(config);
        BundleDescription bundle = state.getResolvedBundle(BUNDLE_SIMPLE_CONFIGURATOR);
        if (bundle != null && bundles.contains(bundle)) {
            result = (byte)(result | 4);
        } else {
            bundle = state.getResolvedBundle(BUNDLE_UPDATE_CONFIGURATOR);
            if (bundle != null && bundles.contains(bundle)) {
                result = (byte)(result | 8);
            }
        }
        bundle = state.getResolvedBundle(BUNDLE_EQUINOX_COMMON);
        if (bundle != null && bundles.contains(bundle)) {
            return (byte)(result | 2);
        }
        return (byte)(result | 1);
    }

    private List getBundlesFromProductFile() throws CoreException {
        PDEState state = this.getSite(false).getRegistry();
        List pluginList = this.productFile.getPlugins();
        ArrayList<BundleDescription> results = new ArrayList<BundleDescription>(pluginList.size());
        Iterator iter = pluginList.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            BundleDescription bundle = state.getResolvedBundle(id);
            if (bundle == null) continue;
            results.add(bundle);
        }
        return results;
    }

    private void printSimpleBundles(StringBuffer buffer, Config config, File configDir, byte style) throws CoreException {
        buffer.append("osgi.bundles=");
        buffer.append(BUNDLE_SIMPLE_CONFIGURATOR);
        buffer.append(START_LEVEL_1);
        buffer.append("\n");
        Collection plugins = null;
        plugins = this.productFile.useFeatures() ? this.director.getAssemblyData().getPlugins(config) : this.getBundlesFromProductFile();
        URL bundlesTxt = P2Utils.writeBundlesTxt(plugins, configDir, (style & 2) > 0);
        if (bundlesTxt != null) {
            buffer.append(SIMPLE_CONFIGURATOR_CONFIG_URL);
            buffer.append("=file:");
            buffer.append("org.eclipse.equinox.simpleconfigurator/bundles.info");
            buffer.append("\n");
        }
    }

    private void printUpdateBundles(StringBuffer buffer, int style) {
        buffer.append("osgi.bundles=");
        if (style == 2) {
            buffer.append(BUNDLE_EQUINOX_COMMON);
            buffer.append(START_LEVEL_2);
            buffer.append(',');
            buffer.append(BUNDLE_UPDATE_CONFIGURATOR);
            buffer.append(START_LEVEL_3);
            buffer.append(',');
            buffer.append(BUNDLE_CORE_RUNTIME);
            buffer.append(START);
            buffer.append('\n');
        } else {
            buffer.append(BUNDLE_CORE_RUNTIME);
            buffer.append(START_LEVEL_2);
            buffer.append(',');
            buffer.append(BUNDLE_UPDATE_CONFIGURATOR);
            buffer.append(START_LEVEL_3);
            buffer.append('\n');
        }
    }

    private void printAllBundles(StringBuffer buffer, Config config, byte style) throws CoreException {
        buffer.append("osgi.bundles=");
        Hashtable<String, String> environment = new Hashtable<String, String>(3);
        ((Dictionary)environment).put("osgi.os", config.getOs());
        ((Dictionary)environment).put("osgi.ws", config.getWs());
        ((Dictionary)environment).put("osgi.arch", config.getArch());
        List bundles = this.getBundlesFromProductFile();
        BundleHelper helper = BundleHelper.getDefault();
        boolean first = true;
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            String filter;
            BundleDescription bundle = (BundleDescription)iter.next();
            String id = bundle.getSymbolicName();
            if (BUNDLE_OSGI.equals(id) || BUNDLE_EQUINOX_LAUNCHER.equals(id) || (filter = bundle.getPlatformFilter()) != null && !helper.createFilter(filter).match(environment)) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append(bundle.getSymbolicName());
            if (BUNDLE_EQUINOX_COMMON.equals(id)) {
                buffer.append(START_LEVEL_2);
                continue;
            }
            if (!BUNDLE_CORE_RUNTIME.equals(id)) continue;
            if ((style & 2) > 0) {
                buffer.append(START);
                continue;
            }
            buffer.append(START_LEVEL_2);
        }
        buffer.append('\n');
    }

    private void createConfigIni(Config config, String location) throws CoreException {
        block21: {
            String application;
            File configDir = new File(String.valueOf(location) + "/configuration");
            if (!configDir.exists() && !configDir.mkdirs() || configDir.isFile()) {
                return;
            }
            byte configStyle = this.determineConfigStyle(config);
            StringBuffer buffer = new StringBuffer();
            buffer.append("#Product Runtime Configuration File\n");
            String splash = this.getSplashLocation(config);
            if (splash != null) {
                buffer.append("osgi.splashPath=" + splash + '\n');
            }
            if ((application = this.productFile.getApplication()) != null) {
                buffer.append("eclipse.application=" + application + '\n');
            }
            buffer.append("eclipse.product=" + this.productFile.getId() + '\n');
            if ((configStyle & 4) > 0) {
                this.printSimpleBundles(buffer, config, configDir, configStyle);
            } else if ((configStyle & 8) > 0) {
                this.printUpdateBundles(buffer, configStyle);
            } else {
                this.printAllBundles(buffer, config, configStyle);
            }
            buffer.append("osgi.bundles.defaultStartLevel=4\n");
            OutputStreamWriter writer = null;
            try {
                try {
                    writer = new FileWriter(new File(configDir, "config.ini"));
                    writer.write(buffer.toString());
                }
                catch (IOException iOException) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException2) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void createEclipseProductFile(String directory) throws CoreException {
        block18: {
            BundleDescription bundle;
            File dir = new File(directory);
            if (!dir.exists() && !dir.mkdirs() || dir.isFile()) {
                return;
            }
            Properties properties = new Properties();
            if (this.productFile.getProductName() != null) {
                properties.put("name", this.productFile.getProductName());
            }
            if (this.productFile.getId() != null) {
                properties.put("id", this.productFile.getId());
            }
            if ((bundle = this.getSite(false).getRegistry().getResolvedBundle(this.getBrandingPlugin())) != null) {
                properties.put("version", bundle.getVersion().toString());
            }
            OutputStream stream = null;
            try {
                try {
                    File file = new File(dir, ".eclipseproduct");
                    stream = new BufferedOutputStream(new FileOutputStream(file));
                    properties.store(stream, "Eclipse Product File");
                    stream.flush();
                }
                catch (IOException iOException) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getBrandingPlugin() {
        String id = this.productFile.getId();
        if (id == null) {
            return null;
        }
        int dot = id.lastIndexOf(46);
        return dot != -1 ? id.substring(0, dot) : null;
    }

    private String getSplashLocation(Config config) throws CoreException {
        String plugin = this.productFile.getSplashLocation();
        if (plugin == null) {
            plugin = this.getBrandingPlugin();
        }
        if (plugin == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("platform:/base/plugins/");
        buffer.append(plugin);
        Hashtable<String, String> environment = new Hashtable<String, String>(4);
        ((Dictionary)environment).put("osgi.os", config.getOs());
        ((Dictionary)environment).put("osgi.ws", config.getWs());
        ((Dictionary)environment).put("osgi.arch", config.getArch());
        PDEState state = this.getSite(false).getRegistry();
        BundleHelper helper = BundleHelper.getDefault();
        BundleDescription bundle = state.getResolvedBundle(plugin);
        if (bundle != null) {
            BundleDescription[] fragments = bundle.getFragments();
            int i = 0;
            while (i < fragments.length) {
                String fragmentId;
                String filter = fragments[i].getPlatformFilter();
                if ((filter == null || helper.createFilter(filter).match(environment)) && this.productFile.containsPlugin(fragmentId = fragments[i].getSymbolicName())) {
                    buffer.append(",platform:/base/plugins/");
                    buffer.append(fragmentId);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    private void createLauncherIniFile(String directory, String os) {
        File dir;
        String launcher = this.getLauncherName();
        if (os.equals("macosx")) {
            directory = String.valueOf(directory) + "/" + launcher + ".app/Contents/MacOS";
        }
        if (!(dir = new File(directory)).exists() && !dir.mkdirs() || dir.isFile()) {
            return;
        }
        String programArgs = this.productFile.getProgramArguments(os);
        String vmArgs = this.productFile.getVMArguments(os);
        if (!(programArgs != null && programArgs.length() != 0 || vmArgs != null && vmArgs.length() != 0)) {
            return;
        }
        String lineDelimiter = "win32".equals(os) ? "\r\n" : "\n";
        PrintWriter writer = null;
        try {
            try {
                StreamTokenizer tokenizer;
                StringReader reader;
                writer = new PrintWriter(new FileWriter(new File(dir, String.valueOf(launcher) + ".ini")));
                if (programArgs != null && programArgs.length() > 0) {
                    reader = new StringReader(programArgs);
                    tokenizer = new StreamTokenizer(reader);
                    tokenizer.resetSyntax();
                    tokenizer.whitespaceChars(0, 32);
                    tokenizer.wordChars(33, 255);
                    tokenizer.quoteChar(34);
                    tokenizer.quoteChar(39);
                    while (tokenizer.nextToken() != -1) {
                        writer.print(tokenizer.sval);
                        writer.print(lineDelimiter);
                    }
                }
                if (vmArgs != null && vmArgs.length() > 0) {
                    writer.print("-vmargs");
                    writer.print(lineDelimiter);
                    reader = new StringReader(vmArgs);
                    tokenizer = new StreamTokenizer(reader);
                    tokenizer.resetSyntax();
                    tokenizer.whitespaceChars(0, 32);
                    tokenizer.wordChars(33, 255);
                    tokenizer.quoteChar(34);
                    tokenizer.quoteChar(39);
                    while (tokenizer.nextToken() != -1) {
                        writer.print(tokenizer.sval);
                        writer.print(lineDelimiter);
                    }
                }
            }
            catch (IOException iOException) {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getLauncherName() {
        String name = this.productFile.getLauncherName();
        if (name != null && name.length() > 0) {
            if ((name = name.trim()).endsWith(".exe")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
        return "eclipse";
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setBuildProperties(Properties buildProperties) {
        this.buildProperties = buildProperties;
    }

    public void setDirector(BuildDirector director) {
        this.director = director;
    }
}

