/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.XMLWriter;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.pde.internal.build.site.PDEState;
import org.osgi.framework.Version;

public class FeatureGenerator
extends AbstractScriptGenerator {
    private static final String FEATURE_PLATFORM_LAUNCHERS = "org.eclipse.platform.launchers";
    private static final String FEATURE_EXECUTABLE = "org.eclipse.equinox.executable";
    private static final String BUNDLE_OSGI = "org.eclipse.osgi";
    private static final String BUNDLE_LAUNCHER = "org.eclipse.equinox.launcher";
    private String featureId = null;
    private String productFile = null;
    private String[] pluginList = null;
    private String[] fragmentList = null;
    private String[] featureList = null;
    private boolean includeLaunchers = true;
    private ProductFile product = null;
    private boolean verify = false;
    private Properties antProperties;
    private Properties buildProperties;

    private static Set createSet(List list) {
        String[] array = new String[list.size()];
        return FeatureGenerator.createSet(list.toArray(array));
    }

    private static Set createSet(String[] contents) {
        if (contents == null) {
            return new LinkedHashSet(0);
        }
        LinkedHashSet<Entry> result = new LinkedHashSet<Entry>(contents.length);
        int i = 0;
        while (i < contents.length) {
            if (contents[i] != null) {
                StringTokenizer tokenizer = new StringTokenizer(contents[i], ";");
                Entry entry = new Entry(tokenizer.nextToken());
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    int idx = token.indexOf(61);
                    if (idx == -1) continue;
                    String value = token.substring(idx + 1, token.length()).trim();
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    entry.addAttribute(token.substring(0, idx), value);
                }
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    public void generate() throws CoreException {
        AbstractScriptGenerator.setStaticAntProperties(this.antProperties);
        try {
            this.initialize();
            Set plugins = FeatureGenerator.createSet(this.pluginList);
            Set features = FeatureGenerator.createSet(this.featureList);
            Set fragments = FeatureGenerator.createSet(this.fragmentList);
            if (this.product != null) {
                if (this.product.useFeatures()) {
                    features.addAll(FeatureGenerator.createSet(this.product.getFeatures()));
                } else {
                    plugins.addAll(FeatureGenerator.createSet(this.product.getPlugins(false)));
                    fragments.addAll(FeatureGenerator.createSet(this.product.getFragments()));
                }
            }
            try {
                this.createFeature(this.featureId, plugins, fragments, features);
            }
            catch (FileNotFoundException e) {
                Status status = new Status(4, "org.eclipse.pde.build", 23, NLS.bind((String)Messages.error_creatingFeature, (Object)e.getLocalizedMessage()), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            AbstractScriptGenerator.setStaticAntProperties(null);
        }
    }

    public void setProductFile(String productFile) {
        this.productFile = productFile;
    }

    public void setPluginList(String[] pluginList) {
        this.pluginList = pluginList;
    }

    public void setFeatureList(String[] featureList) {
        this.featureList = featureList;
    }

    public void setFragmentList(String[] fragmentList) {
        this.fragmentList = fragmentList;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public void setIncludeLaunchers(boolean includeLaunchers) {
        this.includeLaunchers = includeLaunchers;
    }

    private void initialize() throws CoreException {
        File dir = new File(FeatureGenerator.getWorkingDirectory(), "features/" + this.featureId);
        File xml = new File(dir, "feature.xml");
        if (xml.exists()) {
            xml.delete();
        }
        if (this.productFile != null && !this.productFile.startsWith("${") && this.productFile.length() > 0) {
            String productPath = this.findFile(this.productFile, false);
            File f = null;
            if (productPath != null) {
                f = new File(productPath);
            } else {
                f = new File(this.productFile);
                if (!(f.exists() && f.isFile() || (f = new File(FeatureGenerator.getWorkingDirectory(), this.productFile)).exists() && f.isFile())) {
                    f = new File(String.valueOf(FeatureGenerator.getWorkingDirectory()) + "/" + "plugins", this.productFile);
                }
            }
            if (f.exists() && f.isFile()) {
                this.product = new ProductFile(f.getAbsolutePath(), null);
            } else {
                Status error = new Status(4, "org.eclipse.pde.build", 24, NLS.bind((String)Messages.exception_missingElement, (Object)this.productFile), null);
                throw new CoreException((IStatus)error);
            }
        }
    }

    private void addLauncher(PDEState state, Set plugins, Set fragments, Set features) {
        BundleDescription bundle = state.getResolvedBundle(BUNDLE_OSGI);
        if (bundle == null) {
            return;
        }
        Version version = bundle.getVersion();
        if (version.compareTo((Object)new Version("3.3")) < 0) {
            if (!features.contains(FEATURE_PLATFORM_LAUNCHERS)) {
                features.add(new Entry(FEATURE_PLATFORM_LAUNCHERS));
            }
        } else {
            BuildTimeFeature executableFeature = null;
            try {
                executableFeature = this.getSite(false).findFeature(FEATURE_EXECUTABLE, null, false);
            }
            catch (CoreException coreException) {}
            if (executableFeature != null) {
                if (!features.contains(FEATURE_EXECUTABLE)) {
                    features.add(new Entry(FEATURE_EXECUTABLE));
                }
            } else {
                plugins.add(new Entry(BUNDLE_LAUNCHER));
                List configs = FeatureGenerator.getConfigInfos();
                Iterator iterator = configs.iterator();
                while (iterator.hasNext()) {
                    Config config = (Config)iterator.next();
                    String fragment = "org.eclipse.equinox.launcher." + config.getWs() + '.' + config.getOs();
                    if (config.getOs().compareToIgnoreCase("macosx") != 0) {
                        fragment = String.valueOf(fragment) + '.' + config.getArch();
                    }
                    if (fragments.contains(fragment)) continue;
                    Entry entry = new Entry(fragment);
                    entry.addAttribute("unpack", "true");
                    fragments.add(entry);
                }
            }
        }
    }

    protected void createFeature(String feature, Set plugins, Set fragments, Set features) throws CoreException, FileNotFoundException {
        String location = "features/" + feature;
        File directory = new File(FeatureGenerator.getWorkingDirectory(), location);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        PDEState state = this.verify ? this.getSite(false).getRegistry() : null;
        BundleHelper helper = BundleHelper.getDefault();
        if (this.verify && this.includeLaunchers) {
            this.addLauncher(state, plugins, fragments, features);
        }
        File file = new File(directory, "feature.xml");
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(output);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        try {
            String name;
            Entry entry;
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            Hashtable<String, String> environment = new Hashtable<String, String>(3);
            parameters.put("id", feature);
            parameters.put("version", "1.0.0");
            writer.startTag("feature", parameters, true);
            boolean fragment = false;
            List configs = FeatureGenerator.getConfigInfos();
            configs.remove(Config.genericConfig());
            Iterator configIterator = configs.iterator();
            Iterator listIter = plugins.iterator();
            if (!listIter.hasNext()) {
                fragment = true;
                listIter = fragments.iterator();
            }
            Config currentConfig = Config.genericConfig();
            while (currentConfig != null) {
                ((Dictionary)environment).put("osgi.os", currentConfig.getOs());
                ((Dictionary)environment).put("osgi.ws", currentConfig.getWs());
                ((Dictionary)environment).put("osgi.arch", currentConfig.getArch());
                while (listIter.hasNext()) {
                    boolean writeBundle;
                    entry = (Entry)listIter.next();
                    name = entry.getId();
                    boolean guessedUnpack = true;
                    boolean bl = writeBundle = !this.verify;
                    if (this.verify) {
                        BundleDescription bundle = state.getResolvedBundle(name);
                        if (bundle != null) {
                            String filterSpec = bundle.getPlatformFilter();
                            if (filterSpec == null || helper.createFilter(filterSpec).match(environment)) {
                                writeBundle = true;
                                guessedUnpack = this.guessUnpack(bundle, (String[])state.getExtraData().get(new Long(bundle.getBundleId())));
                                if (currentConfig.equals(Config.genericConfig())) {
                                    listIter.remove();
                                }
                            }
                        } else {
                            BundleDescription[] bundles = state.getState().getBundles(name);
                            boolean error = true;
                            if (bundles != null && bundles.length > 0) {
                                ResolverError[] errors = state.getState().getResolverErrors(bundles[0]);
                                int i = 0;
                                while (i < errors.length) {
                                    if ((errors[i].getType() & 0x2000) != 0) {
                                        error = false;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (error) {
                                String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)name);
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
                            }
                        }
                    }
                    if (writeBundle) {
                        parameters.clear();
                        parameters.put("id", name);
                        parameters.put("version", "0.0.0");
                        parameters.put("unpack", guessedUnpack ? "true" : "false");
                        if (!currentConfig.equals(Config.genericConfig())) {
                            parameters.put("os", currentConfig.getOs());
                            parameters.put("ws", currentConfig.getWs());
                            parameters.put("arch", currentConfig.getArch());
                        }
                        if (fragment) {
                            parameters.put("fragment", "true");
                        }
                        parameters.putAll(entry.getAttributes());
                        writer.printTag("plugin", parameters, true, true, true);
                    }
                    if (fragment || listIter.hasNext() || fragments.size() <= 0) continue;
                    fragment = true;
                    listIter = fragments.iterator();
                }
                if (!this.verify || !configIterator.hasNext()) break;
                if (plugins.size() > 0) {
                    fragment = false;
                    listIter = plugins.iterator();
                } else {
                    listIter = fragments.iterator();
                }
                currentConfig = (Config)configIterator.next();
            }
            Iterator iter = features.iterator();
            while (iter.hasNext()) {
                entry = (Entry)iter.next();
                name = entry.getId();
                if (this.verify) {
                    this.getSite(false).findFeature(name, null, true);
                }
                parameters.clear();
                parameters.put("id", name);
                parameters.put("version", "0.0.0");
                parameters.putAll(entry.getAttributes());
                writer.printTag("includes", parameters, true, true, true);
            }
            writer.endTag("feature");
        }
        finally {
            writer.close();
        }
        this.createBuildProperties(directory);
    }

    protected void createBuildProperties(File directory) {
        block15: {
            File file = new File(directory, "build.properties");
            if (this.buildProperties == null) {
                this.buildProperties = new Properties();
                this.buildProperties.put("pde", "marker");
            }
            OutputStream stream = null;
            try {
                try {
                    stream = new BufferedOutputStream(new FileOutputStream(file));
                    this.buildProperties.store(stream, "");
                    stream.flush();
                }
                catch (IOException iOException) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setBuildProperties(String file) {
        this.buildProperties = new Properties();
        File propertiesFile = new File(file);
        if (propertiesFile.exists()) {
            try {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    this.buildProperties.load(input);
                }
                finally {
                    ((InputStream)input).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setBuildProperties(Properties properties) {
        this.buildProperties = properties;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
        this.reportResolutionErrors = verify;
    }

    public boolean guessUnpack(BundleDescription bundle, String[] classpath) {
        if (bundle == null) {
            return true;
        }
        if (bundle.getHost() != null && bundle.getName().startsWith(BUNDLE_LAUNCHER)) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        if (classpath.length == 0) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            if (classpath[i].equals(".")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setImmutableAntProperties(Properties properties) {
        this.antProperties = properties;
    }

    private static class Entry {
        private String id;
        private Map attributes;

        public Entry(String id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.id.equals(((Entry)obj).id);
            }
            return this.id.equals(obj);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public Map getAttributes() {
            if (this.attributes != null) {
                return this.attributes;
            }
            return Collections.EMPTY_MAP;
        }

        public void addAttribute(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap();
            }
            this.attributes.put(key, value);
        }

        public String getId() {
            return this.id;
        }
    }
}

