/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.pde.internal.build.BundleHelper;
import org.osgi.framework.Bundle;

public class BuildApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Platform.endSplash();
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.ant.core.antRunner");
        if (extension == null) {
            return null;
        }
        IConfigurationElement element = extension.getConfigurationElements()[0];
        Object ee = element.createExecutableExtension("run");
        Object args = context.getArguments().get("application.args");
        args = this.updateArgs((String[])args);
        if (ee instanceof IApplication) {
            HashMap arguments = new HashMap(context.getArguments());
            arguments.put("application.args", args);
            ApplicationContext appContext = new ApplicationContext(context, arguments);
            return ((IApplication)ee).start((IApplicationContext)appContext);
        }
        return this.doPlatformRunnable(ee, args);
    }

    private Object doPlatformRunnable(Object ee, Object args) throws Exception {
        if (ee instanceof IPlatformRunnable) {
            return ((IPlatformRunnable)ee).run(args);
        }
        return null;
    }

    private Object updateArgs(String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            String string = args[i];
            if (string.equals("-f") || string.equals("-buildfile")) {
                return args;
            }
            ++i;
        }
        int length = args.length;
        String[] result = new String[length + 2];
        System.arraycopy(args, 0, result, 0, length);
        result[length] = "-f";
        URL buildURL = BundleHelper.getDefault().find((IPath)new Path("/scripts/build.xml"));
        result[length + 1] = FileLocator.toFileURL((URL)buildURL).getFile();
        return result;
    }

    public void stop() {
    }

    class ApplicationContext
    implements IApplicationContext {
        IApplicationContext parent;
        Map arguments;

        ApplicationContext(IApplicationContext parent, Map arguments) {
            this.parent = parent;
            this.arguments = arguments;
        }

        public void applicationRunning() {
            this.parent.applicationRunning();
        }

        public Map getArguments() {
            return this.arguments;
        }

        public String getBrandingApplication() {
            return this.parent.getBrandingApplication();
        }

        public Bundle getBrandingBundle() {
            return this.parent.getBrandingBundle();
        }

        public String getBrandingDescription() {
            return this.parent.getBrandingDescription();
        }

        public String getBrandingId() {
            return this.parent.getBrandingId();
        }

        public String getBrandingName() {
            return this.parent.getBrandingName();
        }

        public String getBrandingProperty(String key) {
            return this.parent.getBrandingProperty(key);
        }
    }
}

