/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorDecoratingLabelProvider;
import org.eclipse.ui.internal.navigator.NavigatorPipelineService;
import org.eclipse.ui.navigator.CommonDragAdapter;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class CommonViewer
extends TreeViewer {
    private final NavigatorContentService contentService;
    private ISelection cachedSelection;

    public CommonViewer(String aViewerId, Composite aParent, int aStyle) {
        super(aParent, aStyle);
        this.contentService = new NavigatorContentService(aViewerId, (StructuredViewer)this);
        this.init();
    }

    protected void init() {
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)this.contentService.createCommonContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new NavigatorDecoratingLabelProvider(this.contentService.createCommonLabelProvider()));
        this.initDragAndDrop();
    }

    protected void removeWithoutRefresh(Object[] elements) {
        super.remove(elements);
    }

    protected void initDragAndDrop() {
        int operations = 3;
        CommonDragAdapter dragAdapter = new CommonDragAdapter(this.contentService, (ISelectionProvider)this);
        this.addDragSupport(operations, dragAdapter.getSupportedDragTransfers(), (DragSourceListener)dragAdapter);
        CommonDropAdapter dropAdapter = new CommonDropAdapter(this.contentService, (StructuredViewer)this);
        this.addDropSupport(operations, dropAdapter.getSupportedDropTransfers(), (DropTargetListener)dropAdapter);
    }

    protected void createTreeItem(Widget parent, Object element, int index) {
        try {
            super.createTreeItem(parent, element, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object[] changed = event.getElements();
        if (changed != null) {
            List<Object> others = Arrays.asList(changed);
            Iterator<Object> iter = others.iterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        }
        super.handleLabelProviderChanged(event);
    }

    protected void handleDispose(DisposeEvent event) {
        this.dispose();
        super.handleDispose(event);
    }

    public void dispose() {
        if (this.contentService != null) {
            this.contentService.dispose();
        }
        this.clearSelectionCache();
    }

    public void setSorter(ViewerSorter sorter) {
        if (sorter != null && sorter instanceof CommonViewerSorter) {
            ((CommonViewerSorter)sorter).setContentService(this.contentService);
        }
        super.setSorter(sorter);
    }

    public INavigatorContentService getNavigatorContentService() {
        return this.contentService;
    }

    public void add(Object parentElement, Object[] childElements) {
        NavigatorPipelineService pipeDream = (NavigatorPipelineService)this.contentService.getPipelineService();
        PipelinedShapeModification modification = new PipelinedShapeModification(parentElement, new ContributorTrackingSet(this.contentService, childElements));
        pipeDream.interceptAdd(modification);
        Object parent = parentElement == this.getInput() ? this.getInput() : modification.getParent();
        super.add(parent, modification.getChildren().toArray());
    }

    public void remove(Object[] elements) {
        NavigatorPipelineService pipeDream = (NavigatorPipelineService)this.contentService.getPipelineService();
        PipelinedShapeModification modification = new PipelinedShapeModification(null, new ContributorTrackingSet(this.contentService, elements));
        pipeDream.interceptRemove(modification);
        super.remove(modification.getChildren().toArray());
    }

    public void refresh(Object element, boolean updateLabels) {
        if (element != this.getInput()) {
            INavigatorPipelineService pipeDream = this.contentService.getPipelineService();
            PipelinedViewerUpdate update = new PipelinedViewerUpdate();
            update.getRefreshTargets().add(element);
            update.setUpdateLabels(updateLabels);
            if (pipeDream.interceptRefresh(update)) {
                boolean toUpdateLabels = update.isUpdateLabels();
                Iterator iter = update.getRefreshTargets().iterator();
                while (iter.hasNext()) {
                    super.refresh(iter.next(), toUpdateLabels);
                }
            } else {
                super.refresh(element, updateLabels);
            }
        } else {
            super.refresh(element, updateLabels);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            INavigatorPipelineService pipeDream = this.contentService.getPipelineService();
            PipelinedViewerUpdate update = new PipelinedViewerUpdate();
            update.getRefreshTargets().addAll(sSelection.toList());
            update.setUpdateLabels(false);
            if (pipeDream.interceptRefresh(update)) {
                super.setSelection((ISelection)new StructuredSelection(update.getRefreshTargets().toArray()), reveal);
            } else {
                super.setSelection(selection, reveal);
            }
        }
    }

    protected void setSelectionToWidget(List v, boolean reveal) {
        this.clearSelectionCache();
        super.setSelectionToWidget(v, reveal);
    }

    protected void handleDoubleSelect(SelectionEvent event) {
        this.clearSelectionCache();
        super.handleDoubleSelect(event);
    }

    protected void handleOpen(SelectionEvent event) {
        this.clearSelectionCache();
        super.handleOpen(event);
    }

    protected void handlePostSelect(SelectionEvent e) {
        this.clearSelectionCache();
        super.handlePostSelect(e);
    }

    protected void handleSelect(SelectionEvent event) {
        this.clearSelectionCache();
        super.handleSelect(event);
    }

    private void clearSelectionCache() {
        this.cachedSelection = null;
    }

    public ISelection getSelection() {
        if (this.cachedSelection == null) {
            this.cachedSelection = super.getSelection();
        }
        return this.cachedSelection;
    }

    public void refresh(Object element) {
        this.refresh(element, true);
    }

    public void update(Object element, String[] properties) {
        if (element != this.getInput()) {
            INavigatorPipelineService pipeDream = this.contentService.getPipelineService();
            PipelinedViewerUpdate update = new PipelinedViewerUpdate();
            update.getRefreshTargets().add(element);
            update.setUpdateLabels(true);
            if (pipeDream.interceptUpdate(update)) {
                Iterator iter = update.getRefreshTargets().iterator();
                while (iter.hasNext()) {
                    super.update(iter.next(), properties);
                }
            } else {
                super.update(element, properties);
            }
        } else {
            super.update(element, properties);
        }
    }

    public String toString() {
        return String.valueOf(this.contentService.toString()) + " Viewer";
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (element == null && this.getRoot() == null) {
            return;
        }
        super.internalRefresh(element, updateLabels);
    }
}

