/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.ILinkHelperExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperDescriptor;
import org.eclipse.ui.internal.navigator.extensions.RegistryReader;
import org.eclipse.ui.navigator.INavigatorContentService;

public class LinkHelperManager {
    private static final LinkHelperManager instance = new LinkHelperManager();
    private static final LinkHelperDescriptor[] NO_DESCRIPTORS = new LinkHelperDescriptor[0];
    private List descriptors;

    public static LinkHelperManager getInstance() {
        return instance;
    }

    private LinkHelperManager() {
        new LinkHelperRegistry().readRegistry();
    }

    public LinkHelperDescriptor[] getLinkHelpersFor(Object anObject, INavigatorContentService aContentService) {
        ArrayList<LinkHelperDescriptor> helpersList = new ArrayList<LinkHelperDescriptor>();
        LinkHelperDescriptor descriptor = null;
        Iterator itr = this.getDescriptors().iterator();
        while (itr.hasNext()) {
            descriptor = (LinkHelperDescriptor)itr.next();
            if (!aContentService.isVisible(descriptor.getId()) || !descriptor.isEnabledFor(anObject)) continue;
            helpersList.add(descriptor);
        }
        if (helpersList.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return helpersList.toArray(new LinkHelperDescriptor[helpersList.size()]);
    }

    public LinkHelperDescriptor[] getLinkHelpersFor(IEditorInput anInput, INavigatorContentService aContentService) {
        ArrayList<LinkHelperDescriptor> helpersList = new ArrayList<LinkHelperDescriptor>();
        LinkHelperDescriptor descriptor = null;
        Iterator itr = this.getDescriptors().iterator();
        while (itr.hasNext()) {
            descriptor = (LinkHelperDescriptor)itr.next();
            if (!aContentService.isVisible(descriptor.getId()) || !descriptor.isEnabledFor(anInput)) continue;
            helpersList.add(descriptor);
        }
        if (helpersList.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return helpersList.toArray(new LinkHelperDescriptor[helpersList.size()]);
    }

    protected List getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList();
        }
        return this.descriptors;
    }

    private class LinkHelperRegistry
    extends RegistryReader
    implements ILinkHelperExtPtConstants {
        private LinkHelperRegistry() {
            super(NavigatorPlugin.PLUGIN_ID, "linkHelper");
        }

        public boolean readElement(IConfigurationElement element) {
            if ("linkHelper".equals(element.getName())) {
                try {
                    LinkHelperManager.this.getDescriptors().add(new LinkHelperDescriptor(element));
                }
                catch (Throwable e) {
                    String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                    NavigatorPlugin.logError(0, msg, e);
                }
                return true;
            }
            return false;
        }
    }
}

