/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite.metadata;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteCategory;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteFeature;
import org.eclipse.equinox.internal.p2.metadata.generator.features.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.BundleDescriptionFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.FeatureEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.MetadataGeneratorHelper;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.URLEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.AbstractMetadataRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class UpdateSiteMetadataRepository
extends AbstractMetadataRepository {
    private final IMetadataRepository metadataRepository;
    private static final String FEATURE_VERSION_SEPARATOR = "_";
    private static final String PROP_SITE_CHECKSUM = "site.checksum";
    static /* synthetic */ Class class$0;

    public UpdateSiteMetadataRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        super("update site: " + location.toExternalForm(), null, null, location, null, null, null);
        URL localRepositoryURL;
        UpdateSite updateSite = UpdateSite.load(location, null);
        this.broadcastAssociateSites(updateSite);
        BundleContext context = Activator.getBundleContext();
        String stateDirName = Integer.toString(location.toExternalForm().hashCode());
        File bundleData = context.getDataFile(null);
        File stateDir = new File(bundleData, stateDirName);
        try {
            localRepositoryURL = stateDir.toURL();
        }
        catch (MalformedURLException e) {
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, Messages.ErrorCreatingRepository, (Throwable)e));
        }
        this.metadataRepository = this.initializeMetadataRepository(context, localRepositoryURL, "update site implementation - " + location.toExternalForm());
        String savedChecksum = (String)this.metadataRepository.getProperties().get(PROP_SITE_CHECKSUM);
        if (savedChecksum != null && savedChecksum.equals(updateSite.getChecksum())) {
            return;
        }
        this.metadataRepository.removeAll();
        this.generateMetadata(updateSite);
        this.metadataRepository.setProperty(PROP_SITE_CHECKSUM, updateSite.getChecksum());
    }

    private void broadcastAssociateSites(UpdateSite baseSite) {
        if (baseSite == null) {
            return;
        }
        URLEntry[] sites = baseSite.getSite().getAssociatedSites();
        if (sites == null || sites.length == 0) {
            return;
        }
        IProvisioningEventBus bus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), (String)IProvisioningEventBus.SERVICE_NAME);
        if (bus == null) {
            return;
        }
        int i = 0;
        while (i < sites.length) {
            try {
                URL siteLocation = new URL(sites[i].getURL());
                bus.publishEvent((EventObject)new RepositoryEvent(siteLocation, 0, 4, true));
                bus.publishEvent((EventObject)new RepositoryEvent(siteLocation, 1, 4, true));
            }
            catch (MalformedURLException e) {
                LogHelper.log((IStatus)new Status(2, Activator.ID, "Site has invalid associate site: " + baseSite.getLocation(), (Throwable)e));
            }
            ++i;
        }
    }

    private void generateMetadata(UpdateSite updateSite) throws ProvisionException {
        SiteModel siteModel = updateSite.getSite();
        Feature[] features = updateSite.loadFeatures();
        SiteCategory[] siteCategories = siteModel.getCategories();
        HashMap categoryNameToFeatureIUs = new HashMap();
        int i = 0;
        while (i < siteCategories.length) {
            categoryNameToFeatureIUs.put(siteCategories[i].getName(), new HashSet());
            ++i;
        }
        SiteFeature[] siteFeatures = siteModel.getFeatures();
        HashMap<String, String[]> featureKeyToCategoryNames = new HashMap<String, String[]>();
        int i2 = 0;
        while (i2 < siteFeatures.length) {
            SiteFeature siteFeature = siteFeatures[i2];
            String featureKey = String.valueOf(siteFeature.getFeatureIdentifier()) + FEATURE_VERSION_SEPARATOR + siteFeature.getFeatureVersion();
            featureKeyToCategoryNames.put(featureKey, siteFeature.getCategoryNames());
            ++i2;
        }
        Properties extraProperties = new Properties();
        extraProperties.put("org.eclipse.equinox.p2.partial.iu", Boolean.TRUE.toString());
        HashSet<IInstallableUnit> allSiteIUs = new HashSet<IInstallableUnit>();
        BundleDescriptionFactory bundleDesciptionFactory = this.initializeBundleDescriptionFactory(Activator.getBundleContext());
        int i3 = 0;
        while (i3 < features.length) {
            Feature feature = features[i3];
            FeatureEntry[] featureEntries = feature.getEntries();
            int j = 0;
            while (j < featureEntries.length) {
                FeatureEntry entry = featureEntries[j];
                if (entry.isPlugin() && !entry.isRequires()) {
                    Properties mockManifest = new Properties();
                    ((Dictionary)mockManifest).put("Manifest-Version", "1.0");
                    ((Dictionary)mockManifest).put("Bundle-ManifestVersion", "2");
                    ((Dictionary)mockManifest).put("Bundle-SymbolicName", entry.getId());
                    ((Dictionary)mockManifest).put("Bundle-Version", entry.getVersion());
                    BundleDescription bundleDescription = bundleDesciptionFactory.getBundleDescription((Dictionary)mockManifest, null);
                    IArtifactKey key = MetadataGeneratorHelper.createBundleArtifactKey((String)entry.getId(), (String)entry.getVersion());
                    IInstallableUnit[] bundleIUs = MetadataGeneratorHelper.createEclipseIU((BundleDescription)bundleDescription, null, (boolean)entry.isUnpack(), (IArtifactKey)key, (Properties)extraProperties);
                    int n = 0;
                    while (n < bundleIUs.length) {
                        allSiteIUs.add(bundleIUs[n]);
                        ++n;
                    }
                }
                ++j;
            }
            IInstallableUnit featureIU = MetadataGeneratorHelper.createFeatureJarIU((Feature)feature, (boolean)true);
            IInstallableUnit groupIU = MetadataGeneratorHelper.createGroupIU((Feature)feature, (IInstallableUnit)featureIU);
            String featureKey = String.valueOf(feature.getId()) + FEATURE_VERSION_SEPARATOR + feature.getVersion();
            String[] categoryNames = (String[])featureKeyToCategoryNames.get(featureKey);
            if (categoryNames != null) {
                int j2 = 0;
                while (j2 < categoryNames.length) {
                    Set featureIUList = (Set)categoryNameToFeatureIUs.get(categoryNames[j2]);
                    if (featureIUList != null) {
                        featureIUList.add(groupIU);
                    }
                    ++j2;
                }
            }
            allSiteIUs.add(featureIU);
            allSiteIUs.add(groupIU);
            ++i3;
        }
        i3 = 0;
        while (i3 < siteCategories.length) {
            SiteCategory category = siteCategories[i3];
            Set featureIUs = (Set)categoryNameToFeatureIUs.get(category.getName());
            IInstallableUnit categoryIU = MetadataGeneratorHelper.createCategoryIU((SiteCategory)category, (Set)featureIUs, null);
            allSiteIUs.add(categoryIU);
            ++i3;
        }
        IInstallableUnit[] ius = allSiteIUs.toArray(new IInstallableUnit[allSiteIUs.size()]);
        this.metadataRepository.addInstallableUnits(ius);
    }

    public static void validate(URL url, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite.validate(url, monitor);
    }

    private IMetadataRepository initializeMetadataRepository(BundleContext context, URL stateDirURL, String repositoryName) {
        SimpleMetadataRepositoryFactory factory = new SimpleMetadataRepositoryFactory();
        try {
            return factory.load(stateDirURL, null);
        }
        catch (ProvisionException provisionException) {
            return factory.create(stateDirURL, repositoryName, null, null);
        }
    }

    private BundleDescriptionFactory initializeBundleDescriptionFactory(BundleContext context) {
        ServiceReference reference;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = context.getServiceReference(clazz.getName())) == null) {
            throw new IllegalStateException(Messages.PlatformAdminNotRegistered);
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)context.getService(reference);
        if (platformAdmin == null) {
            throw new IllegalStateException(Messages.PlatformAdminNotRegistered);
        }
        try {
            StateObjectFactory stateObjectFactory = platformAdmin.getFactory();
            BundleDescriptionFactory bundleDescriptionFactory = new BundleDescriptionFactory(stateObjectFactory, null);
            return bundleDescriptionFactory;
        }
        finally {
            context.ungetService(reference);
        }
    }

    public Map getProperties() {
        HashMap result = new HashMap(this.metadataRepository.getProperties());
        result.remove("p2.system");
        return result;
    }

    public String setProperty(String key, String value) {
        return this.metadataRepository.setProperty(key, value);
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        return this.metadataRepository.query(query, collector, monitor);
    }

    public void removeAll() {
        this.metadataRepository.removeAll();
    }

    public void addInstallableUnits(IInstallableUnit[] installableUnits) {
        this.metadataRepository.addInstallableUnits(installableUnits);
    }

    public boolean removeInstallableUnits(Query query, IProgressMonitor monitor) {
        return this.metadataRepository.removeInstallableUnits(query, monitor);
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
    }
}

