/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite.artifact;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.FeatureEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.MetadataGeneratorHelper;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.core.repository.AbstractRepository;
import org.osgi.framework.BundleContext;

public class UpdateSiteArtifactRepository
extends AbstractRepository
implements IArtifactRepository {
    private static final String PROP_ARTIFACT_REFERENCE = "artifact.reference";
    private static final String PROP_FORCE_THREADING = "eclipse.p2.force.threading";
    private static final String PROP_SITE_CHECKSUM = "site.checksum";
    private static final String PROTOCOL_FILE = "file";
    private final IArtifactRepository artifactRepository;

    public UpdateSiteArtifactRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        super("update site: " + location.toExternalForm(), null, null, location, null, null, null);
        UpdateSite updateSite = UpdateSite.load(location, null);
        BundleContext context = Activator.getBundleContext();
        URL localRepositoryURL = null;
        try {
            String stateDirName = Integer.toString(location.toExternalForm().hashCode());
            File bundleData = context.getDataFile(null);
            File stateDir = new File(bundleData, stateDirName);
            localRepositoryURL = stateDir.toURL();
        }
        catch (MalformedURLException e) {
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, Messages.ErrorCreatingRepository, (Throwable)e));
        }
        this.artifactRepository = this.initializeArtifactRepository(context, localRepositoryURL, "update site implementation - " + location.toExternalForm());
        String savedChecksum = (String)this.artifactRepository.getProperties().get(PROP_SITE_CHECKSUM);
        if (savedChecksum != null && savedChecksum.equals(updateSite.getChecksum())) {
            return;
        }
        if (!location.getProtocol().equals(PROTOCOL_FILE)) {
            this.artifactRepository.setProperty(PROP_FORCE_THREADING, "true");
        }
        this.artifactRepository.removeAll();
        this.generateArtifacts(updateSite);
        this.artifactRepository.setProperty(PROP_SITE_CHECKSUM, updateSite.getChecksum());
    }

    private void generateArtifacts(UpdateSite updateSite) throws ProvisionException {
        Feature[] features = updateSite.loadFeatures();
        HashSet<ArtifactDescriptor> allSiteArtifacts = new HashSet<ArtifactDescriptor>();
        int i = 0;
        while (i < features.length) {
            Feature feature = features[i];
            IArtifactKey featureKey = MetadataGeneratorHelper.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion());
            ArtifactDescriptor featureArtifactDescriptor = new ArtifactDescriptor(featureKey);
            URL featureURL = updateSite.getFeatureURL(null, feature.getId(), feature.getVersion());
            featureArtifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, featureURL.toExternalForm());
            allSiteArtifacts.add(featureArtifactDescriptor);
            FeatureEntry[] featureEntries = feature.getEntries();
            int j = 0;
            while (j < featureEntries.length) {
                FeatureEntry entry = featureEntries[j];
                if (entry.isPlugin() && !entry.isRequires()) {
                    IArtifactKey key = MetadataGeneratorHelper.createBundleArtifactKey((String)entry.getId(), (String)entry.getVersion());
                    ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor(key);
                    URL pluginURL = updateSite.getPluginURL(entry);
                    artifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, pluginURL.toExternalForm());
                    allSiteArtifacts.add(artifactDescriptor);
                }
                ++j;
            }
            ++i;
        }
        IArtifactDescriptor[] descriptors = allSiteArtifacts.toArray(new IArtifactDescriptor[allSiteArtifacts.size()]);
        this.artifactRepository.addDescriptors(descriptors);
    }

    public static void validate(URL url, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite.validate(url, monitor);
    }

    private IArtifactRepository initializeArtifactRepository(BundleContext context, URL stateDirURL, String repositoryName) {
        SimpleArtifactRepositoryFactory factory = new SimpleArtifactRepositoryFactory();
        try {
            return factory.load(stateDirURL, null);
        }
        catch (ProvisionException provisionException) {
            return factory.create(stateDirURL, repositoryName, null, null);
        }
    }

    public Map getProperties() {
        HashMap result = new HashMap(this.artifactRepository.getProperties());
        result.remove("p2.system");
        return result;
    }

    public String setProperty(String key, String value) {
        return this.artifactRepository.setProperty(key, value);
    }

    public void addDescriptor(IArtifactDescriptor descriptor) {
        this.artifactRepository.addDescriptor(descriptor);
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        return this.artifactRepository.contains(descriptor);
    }

    public boolean contains(IArtifactKey key) {
        return this.artifactRepository.contains(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.artifactRepository.getArtifact(descriptor, destination, monitor);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        return this.artifactRepository.getArtifactDescriptors(key);
    }

    public IArtifactKey[] getArtifactKeys() {
        return this.artifactRepository.getArtifactKeys();
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        return this.artifactRepository.getArtifacts(requests, monitor);
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        return this.artifactRepository.getOutputStream(descriptor);
    }

    public void removeAll() {
        this.artifactRepository.removeAll();
    }

    public void removeDescriptor(IArtifactDescriptor descriptor) {
        this.artifactRepository.removeDescriptor(descriptor);
    }

    public void removeDescriptor(IArtifactKey key) {
        this.artifactRepository.removeDescriptor(key);
    }

    public void addDescriptors(IArtifactDescriptor[] descriptors) {
        this.artifactRepository.addDescriptors(descriptors);
    }
}

