/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.IOException;
import java.io.Writer;

public class PDEPerfTesterUtil {
    private String fTag;
    private long fDuration;
    private long fStart;
    private long fEnd;
    private long fIteration;
    private long fTotalDuration;
    private long fAverageDuration;
    private static final long F_SECOND_IN_MS = 1000L;
    private static final long F_MINUTE_IN_MS = 60000L;
    private static final long F_HOUR_IN_MS = 3600000L;

    public PDEPerfTesterUtil(String tag) {
        this.fTag = tag;
        this.reset();
    }

    public void reset() {
        this.fDuration = 0L;
        this.fStart = 0L;
        this.fEnd = 0L;
        this.fIteration = 0L;
        this.fTotalDuration = 0L;
        this.fAverageDuration = 0L;
    }

    public void start() {
        ++this.fIteration;
        this.fStart = System.currentTimeMillis();
    }

    public void stop() {
        this.fEnd = System.currentTimeMillis();
        this.calculateDuration();
    }

    private void calculateDuration() {
        this.fDuration = this.fEnd - this.fStart;
        this.fTotalDuration += this.fDuration;
        if (this.fIteration > 0L) {
            this.fAverageDuration = this.fTotalDuration / this.fIteration;
        }
    }

    private String formatDuration(long duration) {
        String output = null;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        long milliseconds = 0L;
        long timeDifference = duration;
        hours = (int)Math.rint(timeDifference / 3600000L);
        if (hours > 0) {
            timeDifference -= (long)hours * 3600000L;
        }
        if ((minutes = (int)Math.rint(timeDifference / 60000L)) > 0) {
            timeDifference -= (long)minutes * 60000L;
        }
        if ((seconds = (int)Math.rint(timeDifference / 1000L)) > 0) {
            timeDifference -= (long)seconds * 1000L;
        }
        milliseconds = timeDifference;
        output = String.valueOf(hours) + " h " + minutes + " m " + seconds + " s " + milliseconds + " ms";
        return output;
    }

    public void printDuration(Writer writer) {
        String output = String.valueOf(this.formatTag()) + "(" + this.fIteration + "): " + this.formatDuration(this.fDuration) + "\n";
        try {
            writer.write(output);
            writer.flush();
        }
        catch (IOException iOException) {}
    }

    public void printTotalDuration(Writer writer) {
        String output = String.valueOf(this.formatTag()) + "(TOTAL " + this.fIteration + "): " + this.formatDuration(this.fTotalDuration) + "\n";
        try {
            writer.write(output);
            writer.flush();
        }
        catch (IOException iOException) {}
    }

    public void printAverageDuration(Writer writer) {
        String output = String.valueOf(this.formatTag()) + "(AVERAGE " + this.fIteration + "): " + this.formatDuration(this.fAverageDuration) + "\n";
        try {
            writer.write(output);
            writer.flush();
        }
        catch (IOException iOException) {}
    }

    private String formatTag() {
        return "[" + this.fTag + "]: ";
    }
}

