/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.cheatsheet.simple;

import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.NodeDocumentHandler;
import org.eclipse.pde.internal.core.text.cheatsheet.simple.SimpleCSModel;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleCSDocumentHandler
extends NodeDocumentHandler {
    private SimpleCSModel fModel;
    private String fCollapsibleParentName;

    public SimpleCSDocumentHandler(SimpleCSModel model, boolean reconciling) {
        super(reconciling, model.getFactory());
        this.fModel = model;
        this.fCollapsibleParentName = null;
    }

    protected IDocument getDocument() {
        return this.fModel.getDocument();
    }

    protected IDocumentElementNode getRootNode() {
        return this.fModel.getSimpleCS();
    }

    private void setCollapsibleParentName(String tagName) {
        this.fCollapsibleParentName = tagName;
    }

    private String getCollapsibleParentName() {
        return this.fCollapsibleParentName;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        IDocumentElementNode parent = this.getLastParsedDocumentNode();
        if (parent != null && parent.isContentCollapsed()) {
            this.setCollapsibleParentName(parent.getXMLTagName());
            this.processCollapsedStartElement(name, attributes, parent);
        } else {
            super.startElement(uri, localName, name, attributes);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.getCollapsibleParentName() != null && this.getCollapsibleParentName().equals(name)) {
            this.setCollapsibleParentName(null);
        }
        if (this.getCollapsibleParentName() != null) {
            IDocumentElementNode parent = this.getLastParsedDocumentNode();
            this.processCollapsedEndElement(name, parent);
        } else {
            super.endElement(uri, localName, name);
        }
    }

    private void processCollapsedEndElement(String name, IDocumentElementNode parent) {
        IDocumentElementNode node = this.getDocumentNode(name, parent);
        boolean terminate = node.canTerminateStartTag();
        if (terminate) {
            return;
        }
        StringBuffer endElementString = new StringBuffer();
        endElementString.append('<');
        endElementString.append('/');
        endElementString.append(name);
        endElementString.append('>');
        this.getDocumentTextNode(endElementString.toString(), parent);
    }

    private void processCollapsedStartElement(String name, Attributes attributes, IDocumentElementNode parent) {
        IDocumentElementNode node = this.getDocumentNode(name, parent);
        int i = 0;
        while (i < attributes.getLength()) {
            String attValue;
            String attName = attributes.getQName(i);
            IDocumentAttributeNode attribute = this.getDocumentAttribute(attName, attValue = attributes.getValue(i), node);
            if (attribute != null) {
                node.setXMLAttribute(attribute);
            }
            ++i;
        }
        boolean terminate = node.canTerminateStartTag();
        String startElementString = node.writeShallow(terminate);
        this.getDocumentTextNode(startElementString, parent);
    }
}

