/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.AbstractFeatureModel;
import org.eclipse.pde.internal.core.feature.Feature;

public class WorkspaceFeatureModel
extends AbstractFeatureModel
implements IEditableModel {
    private static final long serialVersionUID = 1L;
    private boolean dirty;
    private IFile file;
    private boolean editable = true;

    public WorkspaceFeatureModel() {
    }

    public WorkspaceFeatureModel(IFile file) {
        this.setFile(file);
    }

    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(event.getChangeType() != 99);
        super.fireModelChanged(event);
    }

    protected NLResourceHelper createNLResourceHelper() {
        block4: {
            try {
                if (this.file != null && this.file.getLocation() != null) break block4;
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        IPath path = this.file.getLocation().removeLastSegments(1);
        String installLocation = path.toOSString();
        if (!installLocation.startsWith("file:")) {
            installLocation = "file:" + installLocation;
        }
        URL url = new URL(String.valueOf(installLocation) + "/");
        String name = "feature";
        NLResourceHelper helper = new NLResourceHelper(name, new URL[]{url});
        return helper;
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.setLoaded(true);
        this.save(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {}
        return swriter.toString();
    }

    public IFile getFile() {
        return this.file;
    }

    public String getInstallLocation() {
        IPath path = this.file.getParent().getLocation();
        return path == null ? null : path.toOSString();
    }

    public IResource getUnderlyingResource() {
        return this.file;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isInSync() {
        return this.isInSync(this.file.getLocation().toFile());
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.file.getLocation().toFile());
    }

    public void load() {
        block23: {
            if (this.file == null) {
                return;
            }
            if (this.file.exists()) {
                InputStream stream = null;
                try {
                    stream = new BufferedInputStream(this.file.getContents(true));
                    if (stream.available() > 0) {
                        this.load(stream, false);
                    } else {
                        this.setLoaded(true);
                    }
                }
                catch (CoreException coreException) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block23;
                    }
                    catch (IOException iOException) {}
                    break block23;
                }
                catch (IOException e) {
                    try {
                        PDECore.logException(e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block23;
                    }
                    catch (IOException iOException) {}
                    break block23;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            } else {
                this.feature = new Feature();
                this.feature.model = this;
                this.setLoaded(true);
            }
        }
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            String contents = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (this.file.exists()) {
                this.file.setContents((InputStream)stream, false, false, null);
            } else {
                this.file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {}
    }

    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.feature.write("", writer);
        }
        this.setDirty(false);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void setFile(IFile newFile) {
        this.file = newFile;
    }
}

