/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.ErrorReporter;
import org.eclipse.pde.internal.core.builders.PDEBuilderHelper;
import org.eclipse.pde.internal.core.ibundle.IBundleFragmentModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.PatternConstructor;

public class BuildErrorReporter
extends ErrorReporter
implements IBuildPropertiesConstants {
    private static final String DEF_SOURCE_ENTRY = "source..";
    private ArrayList fProblemList = new ArrayList();
    private int fBuildSeverity;
    private int fClasspathSeverity;

    public BuildErrorReporter(IFile buildFile) {
        super(buildFile);
    }

    public void validate(IProgressMonitor monitor) {
        this.fBuildSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.build");
        this.fClasspathSeverity = CompilerFlags.getFlag(this.fFile.getProject(), "compilers.p.unresolved-import");
        if (this.fBuildSeverity == 2 && this.fClasspathSeverity == 2) {
            return;
        }
        WorkspaceBuildModel wbm = new WorkspaceBuildModel(this.fFile);
        wbm.load();
        if (!wbm.isLoaded()) {
            return;
        }
        this.validateBuild(wbm.getBuild(true));
        if (this.fProblemList.size() > 0) {
            this.reportErrors(this.prepareTextBuildModel(monitor));
        }
    }

    private void validateBuild(IBuild build) {
        IBuildEntry binIncludes = null;
        IBuildEntry binExcludes = null;
        IBuildEntry srcIncludes = null;
        IBuildEntry srcExcludes = null;
        IBuildEntry jarsExtra = null;
        IBuildEntry bundleList = null;
        ArrayList<IBuildEntry> sourceEntries = new ArrayList<IBuildEntry>();
        ArrayList<String> sourceEntryKeys = new ArrayList<String>();
        IBuildEntry[] entries = build.getBuildEntries();
        int i = 0;
        while (i < entries.length) {
            String[] tokens;
            String name = entries[i].getName();
            if (entries[i].getTokens().length == 0) {
                this.prepareError(name, null, PDECoreMessages.BuildErrorReporter_emptyEntry, 8197, "fatal");
            } else if (name.equals("bin.includes")) {
                binIncludes = entries[i];
            } else if (name.equals("bin.excludes")) {
                binExcludes = entries[i];
            } else if (name.equals("src.includes")) {
                srcIncludes = entries[i];
            } else if (name.equals("src.excludes")) {
                srcExcludes = entries[i];
            } else if (name.startsWith("source.")) {
                sourceEntries.add(entries[i]);
            } else if (name.equals("jars.extra.classpath")) {
                jarsExtra = entries[i];
            } else if (name.equals("additional.bundles")) {
                bundleList = entries[i];
            } else if (name.equals("custom") && (tokens = entries[i].getTokens()).length == 1 && tokens[0].equalsIgnoreCase("true")) {
                return;
            }
            if (name.startsWith("source.")) {
                sourceEntryKeys.add(entries[i].getName());
            }
            ++i;
        }
        if (this.fClasspathSeverity != 2) {
            if (jarsExtra != null) {
                this.validateJarsExtraClasspath(jarsExtra);
            }
            if (bundleList != null) {
                this.validateDependencyManagement(bundleList);
            }
        }
        if (this.fBuildSeverity == 2) {
            return;
        }
        this.validateIncludes(binIncludes, sourceEntryKeys);
        this.validateIncludes(binExcludes, sourceEntryKeys);
        this.validateIncludes(srcIncludes, sourceEntryKeys);
        this.validateIncludes(srcExcludes, sourceEntryKeys);
        try {
            if (this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jp = JavaCore.create((IProject)this.fProject);
                IClasspathEntry[] cpes = jp.getRawClasspath();
                this.validateMissingLibraries(sourceEntryKeys, cpes);
                this.validateSourceEntries(sourceEntries, cpes);
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        this.validateSourceEntries(sourceEntries);
        this.validateMissingSourceInBinIncludes(binIncludes, sourceEntryKeys, build);
        this.validateBinIncludes(binIncludes);
    }

    private void validateBinIncludes(IBuildEntry binIncludes) {
        IPluginModelBase model;
        if (this.fProject.exists(ICoreConstants.MANIFEST_PATH)) {
            this.validateBinIncludes(binIncludes, "META-INF/");
        }
        if (this.fProject.exists(ICoreConstants.OSGI_INF_PATH)) {
            try {
                IFolder folder = this.fProject.getFolder(ICoreConstants.OSGI_INF_PATH);
                if (folder.members().length > 0) {
                    this.validateBinIncludes(binIncludes, "OSGI-INF/");
                }
            }
            catch (CoreException coreException) {}
        }
        if (this.fProject.exists(ICoreConstants.FRAGMENT_PATH)) {
            this.validateBinIncludes(binIncludes, "fragment.xml");
        }
        if (this.fProject.exists(ICoreConstants.PLUGIN_PATH)) {
            this.validateBinIncludes(binIncludes, "plugin.xml");
        }
        if ((model = PluginRegistry.findModel(this.fProject)) == null) {
            return;
        }
        if (model instanceof IBundlePluginModelBase && !(model instanceof IBundleFragmentModel)) {
            IBundleModel bm = ((IBundlePluginModelBase)model).getBundleModel();
            IManifestHeader mh = bm.getBundle().getManifestHeader("Bundle-Localization");
            if (mh == null || mh.getValue() == null) {
                Path path = new Path("OSGI-INF/l10n/bundle");
                if (this.fProject.exists((IPath)path)) {
                    this.validateBinIncludes(binIncludes, "OSGI-INF/l10n/bundle");
                }
            } else {
                String localization = mh.getValue();
                int index = localization.lastIndexOf(47);
                if (index != -1) {
                    String folder = localization.substring(0, index + 1);
                    Path path = new Path(folder);
                    if (this.fProject.exists((IPath)path)) {
                        this.validateBinIncludes(binIncludes, folder);
                    }
                } else {
                    String location = mh.getValue().concat(".properties");
                    Path path = new Path(location);
                    if (this.fProject.exists((IPath)path)) {
                        this.validateBinIncludes(binIncludes, location);
                    }
                }
            }
        }
    }

    private void validateBinIncludes(IBuildEntry binIncludes, String key) {
        if (binIncludes == null) {
            return;
        }
        String[] tokens = binIncludes.getTokens();
        boolean exists = false;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].startsWith(key)) {
                exists = true;
                break;
            }
            IPath project = this.fFile.getProject().getLocation();
            if (project != null && tokens[i] != null) {
                File file = project.toFile();
                File[] files = file.listFiles(new WildcardFilenameFilter(tokens[i]));
                int j = 0;
                while (j < files.length) {
                    if (files[j].toString().endsWith(key)) {
                        exists = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!exists) {
            this.prepareError("bin.includes", key, NLS.bind((String)PDECoreMessages.BuildErrorReporter_binIncludesMissing, (Object)key), 8195, "fatal");
        }
    }

    private void validateJarsExtraClasspath(IBuildEntry javaExtra) {
        String platform = "platform:/plugin/";
        String[] tokens = javaExtra.getTokens();
        IPath projectPath = javaExtra.getModel().getUnderlyingResource().getProject().getLocation();
        int i = 0;
        while (i < tokens.length) {
            boolean exists = true;
            if (tokens[i].startsWith(platform)) {
                String path = tokens[i].substring(platform.length());
                int sep = path.indexOf(47);
                if (sep > -1) {
                    IPluginModelBase model = PluginRegistry.findModel(path.substring(0, sep));
                    if (model == null) {
                        exists = false;
                    } else {
                        IResource resource = model.getUnderlyingResource();
                        path = path.substring(sep + 1);
                        if (resource == null) {
                            String location = model.getInstallLocation();
                            File external = new File(location);
                            if (external.isDirectory()) {
                                IPath p = new Path(location).addTrailingSeparator().append(path);
                                exists = new File(p.toOSString()).exists();
                            } else {
                                exists = false;
                            }
                        } else {
                            exists = resource.getProject().findMember(path) != null;
                        }
                    }
                }
            } else {
                exists = projectPath.append(tokens[i]).toFile().exists();
            }
            if (!exists && !this.startsWithAntVariable(tokens[i])) {
                this.prepareError("jars.extra.classpath", tokens[i], NLS.bind((String)PDECoreMessages.BuildErrorReporter_cannotFindJar, (Object)tokens[i]), -1, this.fClasspathSeverity, "");
            }
            ++i;
        }
    }

    private void validateMissingSourceInBinIncludes(IBuildEntry binIncludes, ArrayList sourceEntryKeys, IBuild build) {
        if (binIncludes == null) {
            return;
        }
        int i = 0;
        while (i < sourceEntryKeys.size()) {
            IBuildEntry entry;
            String[] tokens;
            String key = (String)sourceEntryKeys.get(i);
            if (!DEF_SOURCE_ENTRY.equals(key) || (tokens = (entry = build.getEntry(DEF_SOURCE_ENTRY)).getTokens()).length != 1 || !tokens[0].equals(".")) {
                key = key.substring("source.".length());
                boolean found = false;
                String[] binIncludesTokens = binIncludes.getTokens();
                int j = 0;
                while (j < binIncludesTokens.length) {
                    Pattern pattern = PatternConstructor.createPattern(binIncludesTokens[j], false);
                    if (pattern.matcher(key).matches()) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    this.prepareError("bin.includes", key, NLS.bind((String)PDECoreMessages.BuildErrorReporter_binIncludesMissing, (Object)key), 8195, "fatal");
                }
            }
            ++i;
        }
    }

    private void validateSourceEntries(ArrayList sourceEntries) {
        int i = 0;
        while (i < sourceEntries.size()) {
            String name = ((IBuildEntry)sourceEntries.get(i)).getName();
            String[] tokens = ((IBuildEntry)sourceEntries.get(i)).getTokens();
            int j = 0;
            while (j < tokens.length) {
                IResource folderEntry;
                if (!(".".equals(tokens[j]) || (folderEntry = this.fProject.findMember(tokens[j])) != null && folderEntry.exists() && folderEntry instanceof IFolder)) {
                    this.prepareError(name, tokens[j], NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)tokens[j]), 8197, "");
                }
                ++j;
            }
            ++i;
        }
    }

    private void validateMissingLibraries(ArrayList sourceEntryKeys, IClasspathEntry[] cpes) {
        IBundleModel bm;
        IManifestHeader mh;
        IPluginModelBase model = PluginRegistry.findModel(this.fProject);
        if (model == null) {
            return;
        }
        if (model instanceof IBundlePluginModelBase && !(model instanceof IBundleFragmentModel) && ((mh = (bm = ((IBundlePluginModelBase)model).getBundleModel()).getBundle().getManifestHeader("Bundle-ClassPath")) == null || mh.getValue() == null)) {
            int i = 0;
            while (i < cpes.length) {
                if (cpes[i].getEntryKind() == 3) {
                    if (sourceEntryKeys.contains(DEF_SOURCE_ENTRY)) break;
                    this.prepareError(DEF_SOURCE_ENTRY, null, PDECoreMessages.BuildErrorReporter_sourceMissing, -1, "");
                    break;
                }
                ++i;
            }
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            String sourceEntryKey;
            String libname = libraries[i].getName();
            if (libname.equals(".")) {
                int j = 0;
                while (j < cpes.length) {
                    if (cpes[j].getEntryKind() == 3) {
                        if (!sourceEntryKeys.contains(DEF_SOURCE_ENTRY)) {
                            this.prepareError(DEF_SOURCE_ENTRY, null, PDECoreMessages.BuildErrorReporter_sourceMissing, -1, "");
                        }
                        break;
                    }
                    ++j;
                }
            } else if (this.fProject.findMember(libname) == null && !sourceEntryKeys.contains(sourceEntryKey = "source." + libname) && !this.containedInFragment(model.getBundleDescription(), libname)) {
                this.prepareError(sourceEntryKey, null, NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingEntry, (Object)sourceEntryKey), 8196, "");
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containedInFragment(BundleDescription description, String libname) {
        if (description == null) {
            return false;
        }
        fragments = description.getFragments();
        if (fragments == null) {
            return false;
        }
        j = 0;
        while (j < fragments.length) {
            fragmentModel = PluginRegistry.findModel(fragments[j]);
            if (fragmentModel != null && fragmentModel.getUnderlyingResource() != null) {
                project = fragmentModel.getUnderlyingResource().getProject();
                if (project.findMember(libname) != null) {
                    return true;
                }
                try {
                    build = ClasspathUtilCore.getBuild(fragmentModel);
                    if (build == null) ** GOTO lbl34
                    entries = build.getBuildEntries();
                    i = 0;
                    while (true) {
                        if (i >= entries.length) {
                            return false;
                        }
                        if (entries[i].getName().equals("source." + libname)) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (CoreException v0) {}
            } else {
                location = fragments[j].getLocation();
                external = new File(location);
                if (external.exists()) {
                    if (external.isDirectory()) {
                        p = new Path(location).addTrailingSeparator().append(libname);
                        return new File(p.toOSString()).exists();
                    }
                    return CoreUtility.jarContainsResource(external, libname, false);
                }
            }
lbl34:
            // 4 sources

            ++j;
        }
        return false;
    }

    private void validateSourceEntries(ArrayList sourceEntries, IClasspathEntry[] cpes) {
        String[] unlisted = PDEBuilderHelper.getUnlistedClasspaths(sourceEntries, this.fProject, cpes);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < unlisted.length) {
            if (unlisted[i] == null) break;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(unlisted[i]);
            ++i;
        }
        String unlistedEntries = sb.toString();
        if (sb.length() == 0) {
            return;
        }
        if (sourceEntries.size() == 1) {
            String name = ((IBuildEntry)sourceEntries.get(0)).getName();
            this.prepareError(name, null, NLS.bind((String)PDECoreMessages.BuildErrorReporter_classpathEntryMissing1, (Object)unlistedEntries, (Object)name), 8196, "");
        } else {
            this.prepareError(DEF_SOURCE_ENTRY, null, NLS.bind((String)PDECoreMessages.BuildErrorReporter_classpathEntryMissing, (Object)unlistedEntries), 8196, "");
        }
    }

    private void validateIncludes(IBuildEntry includes, ArrayList sourceIncludes) {
        if (includes == null) {
            return;
        }
        String[] tokens = includes.getTokens();
        int i = 0;
        while (i < tokens.length) {
            block6: {
                int fixId;
                String message;
                String token;
                block8: {
                    IResource member;
                    block7: {
                        token = tokens[i].trim();
                        if (token.indexOf("*") != -1 || token.equals(".") || this.startsWithAntVariable(token)) break block6;
                        member = this.fProject.findMember(token);
                        message = null;
                        fixId = -1;
                        if (member != null) break block7;
                        if (sourceIncludes.contains("source." + token)) break block6;
                        message = token.endsWith("/") ? NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)token) : NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFile, (Object)token);
                        fixId = 8197;
                        break block8;
                    }
                    if (token.endsWith("/") && !(member instanceof IFolder)) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_entiresMustRefDirs, (Object)token);
                        fixId = 8194;
                    } else if (!token.endsWith("/") && !(member instanceof IFile)) {
                        message = NLS.bind((String)PDECoreMessages.BuildErrorReporter_dirsMustEndSlash, (Object)token);
                        fixId = 8193;
                    }
                }
                if (message != null) {
                    this.prepareError(includes.getName(), token, message, fixId, "");
                }
            }
            ++i;
        }
    }

    private boolean startsWithAntVariable(String token) {
        int varStart = token.indexOf("${");
        return varStart != -1 && varStart < token.indexOf("}");
    }

    private void validateDependencyManagement(IBuildEntry bundleList) {
        String[] bundles = bundleList.getTokens();
        int i = 0;
        while (i < bundles.length) {
            if (PluginRegistry.findModel(bundles[i]) == null) {
                this.prepareError("additional.bundles", bundles[i], NLS.bind((String)PDECoreMessages.BuildErrorReporter_cannotFindBundle, (Object)bundles[i]), -1, this.fClasspathSeverity, "");
            }
            ++i;
        }
    }

    private BuildModel prepareTextBuildModel(IProgressMonitor monitor) {
        BuildModel bm;
        block5: {
            IDocument doc;
            block4: {
                try {
                    doc = this.createDocument(this.fFile);
                    if (doc != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    PDECore.log(e);
                    return null;
                }
            }
            bm = new BuildModel(doc, true);
            bm.load();
            if (bm.isLoaded()) break block5;
            return null;
        }
        return bm;
    }

    private void reportErrors(BuildModel bm) {
        if (bm == null) {
            return;
        }
        int i = 0;
        while (i < this.fProblemList.size()) {
            BuildProblem bp = (BuildProblem)this.fProblemList.get(i);
            IBuildEntry buildEntry = bm.getBuild().getEntry(bp.fEntryName);
            int lineNum = buildEntry == null || bp.fEntryName == null ? 1 : this.getLineNumber(buildEntry, bp.fEntryToken);
            if (lineNum > 0) {
                this.report(bp.fMessage, lineNum, bp.fFixId, bp.fEntryName, bp.fEntryToken, bp.fSeverity, bp.fCategory);
            }
            ++i;
        }
    }

    private int getLineNumber(IBuildEntry ibe, String tokenString) {
        if (!(ibe instanceof BuildEntry)) {
            return 0;
        }
        BuildEntry be = (BuildEntry)ibe;
        IDocument doc = ((BuildModel)be.getModel()).getDocument();
        try {
            int buildEntryLineNumber = doc.getLineOfOffset(be.getOffset()) + 1;
            if (tokenString == null) {
                return buildEntryLineNumber;
            }
            String entry = doc.get(be.getOffset(), be.getLength());
            int valueIndex = entry.indexOf(61) + 1;
            if (valueIndex == 0 || valueIndex == entry.length()) {
                return buildEntryLineNumber;
            }
            int entryTokenOffset = (entry = entry.substring(valueIndex)).indexOf(tokenString);
            if (entryTokenOffset == -1) {
                return buildEntryLineNumber;
            }
            entry = entry.substring(entryTokenOffset);
            int currOffset = be.getOffset() + valueIndex + entryTokenOffset;
            while (true) {
                int cci;
                if (entry.charAt(0) == '\\') {
                    ++currOffset;
                    entry = entry.substring(1);
                }
                if ((cci = entry.indexOf(44)) == -1) {
                    if (entry.trim().equals(tokenString)) {
                        return doc.getLineOfOffset(currOffset + entry.indexOf(tokenString)) + 1;
                    }
                    return buildEntryLineNumber;
                }
                String ct = entry.substring(0, cci).trim();
                if (ct.equals(tokenString)) {
                    return doc.getLineOfOffset(currOffset) + 1;
                }
                entry = entry.substring(++cci);
                currOffset += cci;
            }
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private void prepareError(String name, String token, String message, int fixId, String category) {
        this.prepareError(name, token, message, fixId, this.fBuildSeverity, category);
    }

    private void prepareError(String name, String token, String message, int fixId, int severity, String category) {
        BuildProblem bp = new BuildProblem(name, token, message, fixId, severity, category);
        int i = 0;
        while (i < this.fProblemList.size()) {
            BuildProblem listed = (BuildProblem)this.fProblemList.get(i);
            if (listed.equals(bp)) {
                return;
            }
            ++i;
        }
        this.fProblemList.add(bp);
    }

    private void report(String message, int line, int problemID, String buildEntry, String buildToken, int severity, String category) {
        IMarker marker = this.report(message, line, severity, problemID, category);
        if (marker == null) {
            return;
        }
        try {
            marker.setAttribute("buildEntry.key", (Object)buildEntry);
            marker.setAttribute("buildEntry.tokenValue", (Object)buildToken);
        }
        catch (CoreException coreException) {}
    }

    private class BuildProblem {
        String fEntryToken;
        String fEntryName;
        String fMessage;
        String fCategory;
        int fFixId;
        int fSeverity;

        BuildProblem(String name, String token, String message, int fixId, int severity, String category) {
            this.fEntryName = name;
            this.fEntryToken = token;
            this.fMessage = message;
            this.fFixId = fixId;
            this.fSeverity = severity;
            this.fCategory = category;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BuildProblem)) {
                return false;
            }
            BuildProblem bp = (BuildProblem)obj;
            if (!this.fEntryName.equals(bp.fEntryName)) {
                return false;
            }
            if (this.fEntryToken != null && !this.fEntryToken.equals(bp.fEntryToken)) {
                return false;
            }
            return this.fFixId == bp.fFixId;
        }
    }

    class WildcardFilenameFilter
    implements FilenameFilter {
        private Pattern pattern;

        public WildcardFilenameFilter(String file) {
            this.pattern = PatternConstructor.createPattern(file, false);
        }

        public boolean accept(File dir, String name) {
            Matcher matcher = this.pattern.matcher(name);
            return matcher.matches();
        }
    }
}

