/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.net;

import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.net.Activator;
import org.eclipse.ui.internal.net.NetUIMessages;
import org.eclipse.ui.internal.net.NonProxyHostsComposite;

public class ProxyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PROXY_PREFERENCE_PAGE_CONTEXT_ID = "org.eclipse.ui.net.proxy_preference_page_context";
    Entry[] entryList;
    Button directConnectionToButton;
    Button manualProxyConfigurationButton;
    Button useSameProxyButton;
    private Label nonHostLabel;
    private NonProxyHostsComposite nonHostComposite;
    Button enableProxyAuth;
    private Label useridLabel;
    private Label passwordLabel;
    Text userid;
    Text password;
    private IProxyService proxyService;
    Button systemProxyConfigurationButton;

    public ProxyPreferencePage() {
        super(NetUIMessages.ProxyPreferencePage_2);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.proxyService = Activator.getDefault().getProxyService();
        if (this.proxyService == null) {
            Label l = new Label(parent, 0);
            l.setText(NetUIMessages.ProxyPreferencePage_40);
            return l;
        }
        IProxyData[] proxyData = this.proxyService.getProxyData();
        this.entryList = new Entry[proxyData.length];
        int i = 0;
        while (i < proxyData.length) {
            IProxyData pd = proxyData[i];
            this.entryList[i] = new Entry(pd);
            ++i;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.systemProxyConfigurationButton = new Button(composite, 16);
        this.systemProxyConfigurationButton.setLayoutData((Object)new GridData());
        this.systemProxyConfigurationButton.setText(NetUIMessages.ProxyPreferencePage_44);
        this.systemProxyConfigurationButton.setToolTipText(NetUIMessages.ProxyPreferencePage_45);
        this.systemProxyConfigurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProxyPreferencePage.this.systemProxyConfigurationButton.getSelection()) {
                    ProxyPreferencePage.this.enableControls(false);
                }
            }
        });
        this.directConnectionToButton = new Button(composite, 16);
        this.directConnectionToButton.setLayoutData((Object)new GridData());
        this.directConnectionToButton.setText(NetUIMessages.ProxyPreferencePage_3);
        this.directConnectionToButton.setToolTipText(NetUIMessages.ProxyPreferencePage_1);
        this.directConnectionToButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProxyPreferencePage.this.directConnectionToButton.getSelection()) {
                    ProxyPreferencePage.this.enableControls(false);
                }
            }
        });
        this.manualProxyConfigurationButton = new Button(composite, 16);
        this.manualProxyConfigurationButton.setText(NetUIMessages.ProxyPreferencePage_4);
        this.manualProxyConfigurationButton.setToolTipText(NetUIMessages.ProxyPreferencePage_0);
        this.manualProxyConfigurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProxyPreferencePage.this.manualProxyConfigurationButton.getSelection()) {
                    ProxyPreferencePage.this.enableControls(true);
                }
            }
        });
        Composite manualProxyConfigurationComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 4;
        manualProxyConfigurationComposite.setLayout((Layout)gridLayout);
        GridData gridData_2 = new GridData(1808);
        gridData_2.horizontalIndent = 17;
        manualProxyConfigurationComposite.setLayoutData((Object)gridData_2);
        this.entryList[0].addProtocolEntry(manualProxyConfigurationComposite);
        new Label(manualProxyConfigurationComposite, 0);
        this.useSameProxyButton = new Button(manualProxyConfigurationComposite, 32);
        this.useSameProxyButton.setText(NetUIMessages.ProxyPreferencePage_5);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.useSameProxyButton.setLayoutData((Object)gridData);
        this.useSameProxyButton.setToolTipText(NetUIMessages.ProxyPreferencePage_23);
        this.useSameProxyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyPreferencePage.this.toggleUseSameProtocol();
            }
        });
        int index = 1;
        while (index < this.entryList.length) {
            this.entryList[index].addProtocolEntry(manualProxyConfigurationComposite);
            ++index;
        }
        Label separator = new Label(manualProxyConfigurationComposite, 258);
        separator.setLayoutData((Object)this.newGridData(4, 5, true, false));
        this.nonHostLabel = new Label(manualProxyConfigurationComposite, 0);
        this.nonHostLabel.setText(NetUIMessages.ProxyPreferencePage_6);
        this.nonHostLabel.setToolTipText(NetUIMessages.ProxyPreferencePage_24);
        this.nonHostLabel.setLayoutData((Object)this.newGridData(4, 5, true, false));
        this.nonHostComposite = new NonProxyHostsComposite(manualProxyConfigurationComposite, 0);
        this.nonHostComposite.setLayoutData(this.newGridData(4, -1, true, true));
        Label separator2 = new Label(manualProxyConfigurationComposite, 258);
        separator2.setLayoutData((Object)this.newGridData(4, 5, true, false));
        this.enableProxyAuth = new Button(manualProxyConfigurationComposite, 32);
        this.enableProxyAuth.setText(NetUIMessages.ProxyPreferencePage_7);
        this.enableProxyAuth.setLayoutData((Object)this.newGridData(4, 5, true, false));
        this.enableProxyAuth.setToolTipText(NetUIMessages.ProxyPreferencePage_25);
        this.enableProxyAuth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyPreferencePage.this.enableUseridPassword(ProxyPreferencePage.this.enableProxyAuth.getSelection());
            }
        });
        Composite userIdPassword = new Composite(manualProxyConfigurationComposite, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        userIdPassword.setLayoutData((Object)this.newGridData(4, -1, true, false));
        userIdPassword.setLayout((Layout)layout2);
        this.useridLabel = new Label(userIdPassword, 0);
        this.useridLabel.setText(NetUIMessages.ProxyPreferencePage_8);
        this.userid = new Text(userIdPassword, 2048);
        this.passwordLabel = new Label(userIdPassword, 0);
        this.passwordLabel.setText(NetUIMessages.ProxyPreferencePage_9);
        this.password = new Text(userIdPassword, 2048);
        this.userid.setLayoutData((Object)new GridData(768));
        this.userid.setToolTipText(NetUIMessages.ProxyPreferencePage_26);
        this.password.setLayoutData((Object)new GridData(768));
        this.password.setToolTipText(NetUIMessages.ProxyPreferencePage_27);
        this.password.setEchoChar('*');
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProxyPreferencePage.this.useSameProxyButton.getSelection()) {
                    int index = 1;
                    while (index < ProxyPreferencePage.this.entryList.length) {
                        ProxyPreferencePage.this.entryList[index].copyValuesFrom(ProxyPreferencePage.this.entryList[0]);
                        ++index;
                    }
                }
            }
        };
        this.entryList[0].hostname.addModifyListener(modifyListener);
        this.entryList[0].port.addModifyListener(modifyListener);
        this.initializeValues(this.proxyService.isProxiesEnabled(), this.proxyService.isSystemProxiesEnabled());
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), PROXY_PREFERENCE_PAGE_CONTEXT_ID);
        return composite;
    }

    protected void performApply() {
        if (this.proxyService == null) {
            return;
        }
        boolean manualProxiesEnabled = this.manualProxyConfigurationButton.getSelection();
        boolean systemProxiesEnabled = this.systemProxyConfigurationButton.getSelection();
        IProxyData[] proxyData = new IProxyData[this.entryList.length];
        int index = 0;
        while (index < this.entryList.length) {
            this.entryList[index].applyValues();
            proxyData[index] = this.entryList[index].getProxy();
            ++index;
        }
        this.proxyService.setProxiesEnabled(manualProxiesEnabled || systemProxiesEnabled);
        if (manualProxiesEnabled) {
            try {
                this.proxyService.setNonProxiedHosts(this.nonHostComposite.getList());
                this.proxyService.setProxyData(proxyData);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
            }
        }
        this.proxyService.setSystemProxiesEnabled(systemProxiesEnabled);
        Activator.getDefault().savePluginPreferences();
    }

    protected void performDefaults() {
        this.directConnectionToButton.setSelection(true);
        this.systemProxyConfigurationButton.setSelection(false);
        this.manualProxyConfigurationButton.setSelection(false);
        this.useSameProxyButton.setSelection(false);
        this.enableProxyAuth.setSelection(false);
        int index = 0;
        while (index < this.entryList.length) {
            this.entryList[index].reset();
            ++index;
        }
        this.nonHostComposite.setList(new String[]{"localhost", "127.0.0.1"});
        this.userid.setText("");
        this.password.setText("");
        this.enableControls(false);
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    private void initializeValues(boolean proxiesEnabled, boolean systemProxiesEnabled) {
        Entry entry;
        int i;
        String[] stringArray;
        this.directConnectionToButton.setSelection(!proxiesEnabled);
        this.manualProxyConfigurationButton.setSelection(proxiesEnabled && !systemProxiesEnabled);
        this.systemProxyConfigurationButton.setSelection(proxiesEnabled && systemProxiesEnabled);
        String[] nonHostLists = null;
        if (this.proxyService != null) {
            nonHostLists = this.proxyService.getNonProxiedHosts();
        }
        if (nonHostLists == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "localhost";
            stringArray = stringArray2;
            stringArray2[1] = "127.0.0.1";
        } else {
            stringArray = nonHostLists;
        }
        this.nonHostComposite.setList(stringArray);
        if (proxiesEnabled && !systemProxiesEnabled) {
            this.useSameProxyButton.setSelection(false);
            this.enableProxyAuth.setSelection(false);
            this.userid.setText("");
            this.password.setText("");
        } else {
            IProxyData data = null;
            i = 0;
            while (i < this.entryList.length) {
                IProxyData idata = this.entryList[i].getProxy();
                if (idata.isRequiresAuthentication()) {
                    data = idata;
                    break;
                }
                ++i;
            }
            if (data == null) {
                data = this.entryList[0].getProxy();
            }
            this.enableProxyAuth.setSelection(data.isRequiresAuthentication());
            this.userid.setText(data.getUserId() == null ? "" : data.getUserId());
            this.password.setText(data.getPassword() == null ? "" : data.getPassword());
        }
        boolean useSameProtocol = true;
        i = 1;
        while (i < this.entryList.length) {
            entry = this.entryList[i];
            if (!entry.isUseSameProtocol(this.entryList[0])) {
                useSameProtocol = false;
                break;
            }
            ++i;
        }
        this.useSameProxyButton.setSelection(useSameProtocol);
        int index = 1;
        while (index < this.entryList.length) {
            entry = this.entryList[index];
            entry.loadPreviousValues();
            entry.updateEnablement(proxiesEnabled && !systemProxiesEnabled, useSameProtocol);
            ++index;
        }
        this.enableControls(proxiesEnabled && !systemProxiesEnabled);
    }

    void enableControls(boolean enabled) {
        int index = 0;
        while (index < this.entryList.length) {
            this.entryList[index].updateEnablement(enabled, this.useSameProxyButton.getSelection());
            ++index;
        }
        this.useSameProxyButton.setEnabled(enabled);
        this.nonHostLabel.setEnabled(enabled);
        this.nonHostComposite.setEnabled(enabled);
        this.enableProxyAuth.setEnabled(enabled);
        this.enableUseridPassword(this.enableProxyAuth.getSelection() && enabled);
    }

    void enableUseridPassword(boolean enabled) {
        this.useridLabel.setEnabled(enabled);
        this.userid.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.password.setEnabled(enabled);
    }

    protected void toggleUseSameProtocol() {
        boolean useSameProtocol = this.useSameProxyButton.getSelection();
        int index = 1;
        while (index < this.entryList.length) {
            this.entryList[index].setUseSameProtocol(useSameProtocol, this.entryList[0]);
            ++index;
        }
    }

    public void updateErrorMessage() {
        int index = 0;
        while (index < this.entryList.length) {
            String message = this.entryList[index].getErrorMessage();
            if (message != null) {
                this.setErrorMessage(message);
                return;
            }
            ++index;
        }
        this.setErrorMessage(null);
    }

    private GridData newGridData(int span, int verticalIndent, boolean horizontal, boolean vertical) {
        int style = 0;
        style |= horizontal ? 768 : 0;
        GridData gridData = new GridData(style |= vertical ? 1040 : 0);
        if (span != -1) {
            gridData.horizontalSpan = span;
        }
        if (verticalIndent != -1) {
            gridData.verticalIndent = verticalIndent;
        }
        return gridData;
    }

    private class Entry {
        Label nameLabel;
        Text hostname;
        Label portLabel;
        Text port;
        String prevHostname;
        int prevPort;
        private final IProxyData proxyData;
        private String errorMessage;

        public Entry(IProxyData proxyData) {
            this.proxyData = proxyData;
        }

        public void updateEnablement(boolean proxiesEnabled, boolean useSameProtocol) {
            if (this.isHttpProxy()) {
                this.setEnabled(proxiesEnabled);
            } else if (proxiesEnabled) {
                this.setUseSameProtocol(useSameProtocol);
            } else {
                this.setEnabled(false);
            }
            this.updateMessage();
        }

        public void setUseSameProtocol(boolean useSameProtocol, Entry httpEntry) {
            this.setUseSameProtocol(useSameProtocol);
            if (this.isSocksProxy() || this.isHttpProxy()) {
                return;
            }
            if (useSameProtocol) {
                this.recordPreviousValues();
                this.copyValuesFrom(ProxyPreferencePage.this.entryList[0]);
            } else {
                this.restorePreviousValues();
            }
        }

        public void setUseSameProtocol(boolean useSameProtocol) {
            if (this.isSocksProxy()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(!useSameProtocol);
            }
        }

        public void loadPreviousValues() {
            IProxyData proxy = this.getProxy();
            this.prevHostname = proxy.getHost();
            this.prevPort = proxy.getPort();
        }

        public void restorePreviousValues() {
            this.hostname.setText(this.prevHostname);
            this.port.setText(this.prevPort == -1 ? "" : String.valueOf(this.prevPort));
        }

        public void recordPreviousValues() {
            this.prevHostname = this.hostname.getText();
            try {
                this.prevPort = Integer.parseInt(this.port.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.prevPort = -1;
            }
        }

        public void copyValuesFrom(Entry entry) {
            if (!this.isSocksProxy()) {
                this.hostname.setText(entry.hostname.getText());
                this.port.setText(entry.port.getText());
            }
        }

        public boolean isUseSameProtocol(Entry entry) {
            if (this.isSocksProxy()) {
                return true;
            }
            return this.hostsEqual(this.proxyData.getHost(), entry.getProxy().getHost()) && this.portsEqual(this.proxyData.getPort(), entry.getProxy().getPort());
        }

        private boolean portsEqual(int port1, int port2) {
            return port1 == port2;
        }

        private boolean hostsEqual(String host1, String host2) {
            if (host1 == host2) {
                return false;
            }
            if (host1 == null || host2 == null) {
                return false;
            }
            return host1.equals(host2);
        }

        boolean isSocksProxy() {
            return this.getProxy().getType().equals("SOCKS");
        }

        boolean isHttpProxy() {
            return this.getProxy().getType().equals("HTTP");
        }

        boolean isHttpsProxy() {
            return this.getProxy().getType().equals("HTTPS");
        }

        public IProxyData getProxy() {
            return this.proxyData;
        }

        public boolean updateMessage() {
            if (this.hostname.isEnabled() && (this.isSocksProxy() || this.isHttpProxy() || !ProxyPreferencePage.this.useSameProxyButton.getSelection())) {
                String hostString = this.hostname.getText();
                if (hostString.startsWith(" ") || hostString.endsWith(" ")) {
                    this.setErrorMessage(NetUIMessages.ProxyPreferencePage_41);
                    return false;
                }
                String portString = this.port.getText();
                if (portString.length() > 0) {
                    try {
                        int port = Integer.valueOf(portString);
                        if (port < 0) {
                            this.setErrorMessage(NetUIMessages.ProxyPreferencePage_42);
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setErrorMessage(NetUIMessages.ProxyPreferencePage_43);
                        return false;
                    }
                }
            }
            this.setErrorMessage(null);
            return true;
        }

        private void setErrorMessage(String message) {
            this.errorMessage = message;
            ProxyPreferencePage.this.updateErrorMessage();
        }

        public void applyValues() {
            String portString;
            String hostString;
            IProxyData proxy = this.getProxy();
            boolean enableAuth = ProxyPreferencePage.this.enableProxyAuth.getSelection();
            if (ProxyPreferencePage.this.useSameProxyButton.getSelection() && !this.isSocksProxy()) {
                hostString = ProxyPreferencePage.this.entryList[0].hostname.getText();
                portString = ProxyPreferencePage.this.entryList[0].port.getText();
            } else {
                hostString = this.hostname.getText();
                portString = this.port.getText();
            }
            proxy.setHost(hostString);
            try {
                int port = Integer.valueOf(portString);
                proxy.setPort(port);
            }
            catch (NumberFormatException numberFormatException) {
                proxy.setPort(-1);
            }
            proxy.setUserid(enableAuth ? ProxyPreferencePage.this.userid.getText() : null);
            proxy.setPassword(enableAuth ? ProxyPreferencePage.this.password.getText() : null);
        }

        public void addProtocolEntry(Composite parent) {
            IProxyData proxy = this.getProxy();
            this.nameLabel = new Label(parent, 0);
            this.nameLabel.setText(this.getLabel(proxy));
            this.hostname = new Text(parent, 2048);
            GridData gridData = new GridData(768);
            gridData.widthHint = 120;
            this.hostname.setLayoutData((Object)gridData);
            this.hostname.setText(this.getHostName(proxy));
            this.hostname.addModifyListener(new ModifyListener(this){
                final /* synthetic */ Entry this$1;
                {
                    this.this$1 = entry;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateMessage();
                }
            });
            this.portLabel = new Label(parent, 0);
            this.portLabel.setText(NetUIMessages.ProxyPreferencePage_22);
            this.port = new Text(parent, 2048);
            gridData = new GridData();
            gridData.widthHint = 50;
            this.port.setLayoutData((Object)gridData);
            this.port.setText(this.getPortString(proxy));
            this.port.addModifyListener(new ModifyListener(this){
                final /* synthetic */ Entry this$1;
                {
                    this.this$1 = entry;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateMessage();
                }
            });
        }

        private String getLabel(IProxyData data) {
            if (data.getType().equals("HTTP")) {
                return NetUIMessages.ProxyPreferencePage_37;
            }
            if (data.getType().equals("HTTPS")) {
                return NetUIMessages.ProxyPreferencePage_38;
            }
            if (data.getType().equals("SOCKS")) {
                return NetUIMessages.ProxyPreferencePage_39;
            }
            return "";
        }

        private String getPortString(IProxyData proxy) {
            int portInt = proxy.getPort();
            String portString = portInt == -1 ? "" : String.valueOf(portInt);
            return portString;
        }

        private String getHostName(IProxyData proxy) {
            String hostnameString = proxy.getHost();
            if (hostnameString == null) {
                hostnameString = "";
            }
            return hostnameString;
        }

        public void reset() {
            this.hostname.setText("");
            this.port.setText("");
            this.prevHostname = "";
            this.prevPort = -1;
        }

        private void setEnabled(boolean enabled) {
            this.hostname.setEnabled(enabled);
            this.nameLabel.setEnabled(enabled);
            this.portLabel.setEnabled(enabled);
            this.port.setEnabled(enabled);
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

