/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.runtime.interceptor;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.lang.reflect.SourceLocation;
import pl.poznan.put.qjunit.runtime.interceptor.ResponseProvider;
import pl.poznan.put.qjunit.runtime.interceptor.ResponseProviderFactory;

public class InterceptorUtil {
    public static InterceptorUtil INSTANCE = new InterceptorUtil();
    private boolean isLearning;
    private Map joinPoints = new HashMap();
    private ResponseProvider current = null;
    private ResponseProviderFactory factory;

    private InterceptorUtil() {
    }

    public void setResponseProviderFactory(ResponseProviderFactory factory) {
        this.factory = factory;
    }

    public void learn(JoinPoint.StaticPart joinPoint, boolean origResponse) {
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createBooleanResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public void learn(JoinPoint.StaticPart joinPoint, char origResponse) {
        this.joinPoints.put(joinPoint, this.factory.createCharResponseProvider(joinPoint));
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createFloatResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public void learn(JoinPoint.StaticPart joinPoint, byte origResponse) {
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createByteResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public void learn(JoinPoint.StaticPart joinPoint, int origResponse) {
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createIntResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public void learn(JoinPoint.StaticPart joinPoint, float origResponse) {
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createFloatResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public void learn(JoinPoint.StaticPart joinPoint, double origResponse) {
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createDoubleResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public void learn(JoinPoint.StaticPart joinPoint, long origResponse) {
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createLongResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public void learn(JoinPoint.StaticPart joinPoint, short origResponse) {
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createShortResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public void learn(JoinPoint.StaticPart joinPoint, Object origResponse) {
        ResponseProvider rp = (ResponseProvider)this.joinPoints.get(joinPoint);
        if (rp == null) {
            rp = this.factory.createObjectResponseProvider(joinPoint);
            this.joinPoints.put(joinPoint, rp);
        }
        rp.add(origResponse);
    }

    public JoinPointInfo getJoinPointInfo(ResponseProvider provider) {
        for (JoinPoint.StaticPart key : this.joinPoints.keySet()) {
            if (!provider.equals(this.joinPoints.get(key))) continue;
            JoinPointInfo info = new JoinPointInfo();
            SourceLocation sourceLocation = key.getSourceLocation();
            info.fileName = sourceLocation.getFileName();
            info.line = sourceLocation.getLine();
            info.signature = ((MethodSignature)key.getSignature()).toString();
            return info;
        }
        return null;
    }

    public ResponseProvider getResponses(JoinPoint.StaticPart staticPart) {
        return (ResponseProvider)this.joinPoints.get(staticPart);
    }

    public ResponseProvider[] getResponseProviders() {
        return this.joinPoints.values().toArray(new ResponseProvider[this.joinPoints.values().size()]);
    }

    public void learn() {
        this.joinPoints.clear();
        this.isLearning = true;
    }

    public void mock() {
        this.isLearning = false;
    }

    public boolean isLearning() {
        return this.isLearning;
    }

    public void setCurrentProvider(ResponseProvider provider) {
        this.current = provider;
    }

    public boolean isCurrent(ResponseProvider provider) {
        return this.current == provider;
    }

    public static class JoinPointInfo {
        public String fileName;
        public int line;
        public String signature;
    }
}

