/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.provisional.p2.metadata.Copyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.License;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointType;
import org.osgi.framework.Version;

public class InstallableUnit
implements IInstallableUnit {
    private static final OrderedProperties NO_PROPERTIES = new OrderedProperties();
    private static final ProvidedCapability[] NO_PROVIDES = new ProvidedCapability[0];
    private static final RequiredCapability[] NO_REQUIRES = new RequiredCapability[0];
    private static final TouchpointData[] NO_TOUCHPOINT_DATA = new TouchpointData[0];
    String applicabilityFilter;
    private IArtifactKey[] artifacts;
    private String filter;
    private String id;
    private OrderedProperties properties;
    ProvidedCapability[] providedCapabilities = NO_PROVIDES;
    private RequiredCapability[] requires;
    private boolean singleton;
    private ArrayList touchpointData = null;
    private TouchpointType touchpointType;
    private Version version;
    private IUpdateDescriptor updateInfo;
    private License license;
    private Copyright copyright;

    public void addProperties(Map newProperties) {
        if (this.properties == null) {
            this.properties = new OrderedProperties(newProperties.size());
        }
        this.properties.putAll(newProperties);
    }

    protected void addProvidedCapability(ProvidedCapability capability) {
        if (this.providedCapabilities != null && this.providedCapabilities.length > 0) {
            ProvidedCapability[] result = new ProvidedCapability[this.providedCapabilities.length + 1];
            result[0] = capability;
            System.arraycopy(this.providedCapabilities, 0, result, 1, this.providedCapabilities.length);
            this.providedCapabilities = result;
        } else {
            this.providedCapabilities = new ProvidedCapability[]{capability};
        }
    }

    public void addTouchpointData(TouchpointData newData) {
        this.ensureTouchpointDataCapacity(1);
        this.touchpointData.add(newData);
    }

    public int compareTo(Object toCompareTo) {
        if (!(toCompareTo instanceof IInstallableUnit)) {
            return -1;
        }
        IInstallableUnit other = (IInstallableUnit)toCompareTo;
        if (this.getId().compareTo(other.getId()) == 0) {
            return this.getVersion().compareTo((Object)other.getVersion());
        }
        return this.getId().compareTo(other.getId());
    }

    private void ensureTouchpointDataCapacity(int size) {
        if (this.touchpointData != null) {
            this.touchpointData.ensureCapacity(size);
        } else {
            this.touchpointData = new ArrayList(size);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IInstallableUnit)) {
            return false;
        }
        IInstallableUnit other = (IInstallableUnit)obj;
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        return !(this.getVersion() == null ? other.getVersion() != null : !this.getVersion().equals((Object)other.getVersion()));
    }

    public String getApplicabilityFilter() {
        return this.applicabilityFilter;
    }

    public IArtifactKey[] getArtifacts() {
        return this.artifacts;
    }

    public String getFilter() {
        return this.filter;
    }

    public IInstallableUnitFragment[] getFragments() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public Map getProperties() {
        return OrderedProperties.unmodifiableProperties((Map)this.properties());
    }

    public String getProperty(String key) {
        return this.properties().getProperty(key);
    }

    public ProvidedCapability[] getProvidedCapabilities() {
        return this.providedCapabilities != null ? this.providedCapabilities : NO_PROVIDES;
    }

    public RequiredCapability[] getRequiredCapabilities() {
        return this.requires != null ? this.requires : NO_REQUIRES;
    }

    public TouchpointData[] getTouchpointData() {
        return this.touchpointData == null ? NO_TOUCHPOINT_DATA : this.touchpointData.toArray(new TouchpointData[this.touchpointData.size()]);
    }

    public TouchpointType getTouchpointType() {
        return this.touchpointType != null ? this.touchpointType : TouchpointType.NONE;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return result;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean isResolved() {
        return false;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    private OrderedProperties properties() {
        return this.properties != null ? this.properties : NO_PROPERTIES;
    }

    public void setApplicabilityFilter(String ldapFilter) {
        this.applicabilityFilter = ldapFilter;
    }

    public void setArtifacts(IArtifactKey[] value) {
        this.artifacts = value;
    }

    public void setCapabilities(ProvidedCapability[] exportedCapabilities) {
        this.providedCapabilities = exportedCapabilities;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setImmutableTouchpointData(TouchpointData immutableData) {
        this.ensureTouchpointDataCapacity(4);
        this.touchpointData.add(immutableData);
    }

    public String setProperty(String key, String value) {
        if (value == null) {
            return this.properties != null ? (String)this.properties.remove((Object)key) : null;
        }
        if (this.properties == null) {
            this.properties = new OrderedProperties();
        }
        return (String)this.properties.setProperty(key, value);
    }

    public void setRequiredCapabilities(RequiredCapability[] capabilities) {
        this.requires = capabilities == NO_REQUIRES ? null : (RequiredCapability[])capabilities.clone();
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setTouchpointType(TouchpointType type) {
        this.touchpointType = type != TouchpointType.NONE ? type : null;
    }

    public void setVersion(Version newVersion) {
        this.version = newVersion != null ? newVersion : Version.emptyVersion;
    }

    public String toString() {
        return String.valueOf(this.id) + ' ' + this.getVersion();
    }

    public IInstallableUnit unresolved() {
        return this;
    }

    public IUpdateDescriptor getUpdateDescriptor() {
        return this.updateInfo;
    }

    public void setUpdateDescriptor(IUpdateDescriptor updateInfo) {
        this.updateInfo = updateInfo;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public License getLicense() {
        return this.license;
    }

    public void setCopyright(Copyright copyright) {
        this.copyright = copyright;
    }

    public Copyright getCopyright() {
        return this.copyright;
    }
}

