/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator.features;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.Activator;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.FeatureEntry;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser
extends DefaultHandler {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private Feature result;
    private URL url;
    private StringBuffer characters = null;
    private Properties messages = null;

    public FeatureParser() {
        this(true);
    }

    protected FeatureParser(boolean createParser) {
        if (!createParser) {
            return;
        }
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.characters == null) {
            return;
        }
        this.characters.append(ch, start, length);
    }

    protected Feature createFeature(String id, String version) {
        return new Feature(id, version);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.characters == null) {
            return;
        }
        if ("description".equals(localName)) {
            this.result.setDescription(this.localize(this.characters.toString().trim()));
        } else if ("license".equals(localName)) {
            this.result.setLicense(this.localize(this.characters.toString().trim()));
        } else if ("copyright".equals(localName)) {
            this.result.setCopyright(this.localize(this.characters.toString().trim()));
        }
        this.characters = null;
    }

    public Feature getResult() {
        return this.result;
    }

    private Properties loadProperties(File directory) {
        Properties properties;
        block7: {
            File file = new File(directory, "feature.properties");
            if (!file.exists()) {
                return null;
            }
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                Properties result = new Properties();
                result.load(input);
                properties = result;
                if (input == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((InputStream)input).close();
        }
        return properties;
    }

    private Properties loadProperties(JarFile jar) {
        Properties properties;
        block7: {
            JarEntry entry = jar.getJarEntry("feature.properties");
            if (entry == null) {
                return null;
            }
            BufferedInputStream input = new BufferedInputStream(jar.getInputStream(entry));
            try {
                Properties result = new Properties();
                result.load(input);
                properties = result;
                if (input == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((InputStream)input).close();
        }
        return properties;
    }

    private String localize(String value) {
        if (this.messages == null || value == null) {
            return value;
        }
        if (!value.startsWith("%")) {
            return value;
        }
        return this.messages.getProperty(value.substring(1), value);
    }

    /*
     * Loose catch block
     */
    public Feature parse(File location) {
        block30: {
            if (!location.exists()) {
                return null;
            }
            if (location.isDirectory()) {
                File file = new File(location, "feature.xml");
                if (!file.exists()) {
                    return null;
                }
                Properties properties2 = this.loadProperties(location);
                try {
                    BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                    return this.parse(input, properties2);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else if (location.getName().endsWith(".jar")) {
                JarEntry entry;
                Properties properties;
                JarFile jar;
                block29: {
                    jar = null;
                    jar = new JarFile(location);
                    properties = this.loadProperties(jar);
                    entry = jar.getJarEntry("feature.xml");
                    if (entry != null) break block29;
                    try {
                        if (jar != null) {
                            jar.close();
                        }
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                BufferedInputStream input = new BufferedInputStream(jar.getInputStream(entry));
                Feature feature = this.parse(input, properties);
                try {
                    if (jar != null) {
                        jar.close();
                    }
                }
                catch (IOException iOException) {}
                return feature;
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (jar != null) {
                            jar.close();
                        }
                        break block30;
                    }
                    catch (IOException iOException) {}
                    break block30;
                }
                catch (SecurityException e2) {
                    LogHelper.log((IStatus)new Status(2, Activator.ID, "Exception parsing feature: " + location.getAbsolutePath(), (Throwable)e2));
                    {
                        catch (Throwable throwable) {
                            try {
                                if (jar != null) {
                                    jar.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                    try {
                        if (jar != null) {
                            jar.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public Feature parse(InputStream in, Properties messages) {
        block14: {
            this.messages = messages;
            this.result = null;
            try {
                this.parser.parse(new InputSource(in), (DefaultHandler)this);
            }
            catch (SAXException e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                break block14;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                break block14;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return this.result;
    }

    private void processCopyright(Attributes attributes) {
        this.result.setCopyrightURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    private void processDescription(Attributes attributes) {
        this.result.setDescriptionURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    private void processDiscoverySite(Attributes attributes) {
        if ("web".equals(attributes.getValue("type"))) {
            return;
        }
        this.result.addDiscoverySite(attributes.getValue("label"), attributes.getValue("url"));
    }

    protected void processFeature(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id != null && !id.trim().equals("") && ver != null && !ver.trim().equals("")) {
            this.result = this.createFeature(id, ver);
            String os = attributes.getValue("os");
            String ws = attributes.getValue("ws");
            String nl = attributes.getValue("nl");
            String arch = attributes.getValue("arch");
            this.result.setEnvironment(os, ws, arch, nl);
            if (this.url != null && "file".equals(this.url.getProtocol())) {
                File f = new File(this.url.getFile().replace('/', File.separatorChar));
                this.result.setURL("features/" + f.getParentFile().getName() + "/");
            }
            this.result.setProviderName(this.localize(attributes.getValue("provider-name")));
            this.result.setLabel(this.localize(attributes.getValue("label")));
            this.result.setImage(attributes.getValue("image"));
        }
    }

    private void processImport(Attributes attributes) {
        String id = attributes.getValue("feature");
        FeatureEntry entry = null;
        if (id != null) {
            if ("true".equalsIgnoreCase(attributes.getValue("patch"))) {
                entry = FeatureEntry.createRequires(id, attributes.getValue("version"), "perfect", attributes.getValue("filter"), false);
                entry.setPatch(true);
            } else {
                entry = FeatureEntry.createRequires(id, attributes.getValue("version"), attributes.getValue("match"), attributes.getValue("filter"), false);
            }
        } else {
            id = attributes.getValue("plugin");
            entry = FeatureEntry.createRequires(id, attributes.getValue("version"), attributes.getValue("match"), attributes.getValue("filter"), true);
        }
        this.result.addEntry(entry);
    }

    private void processIncludes(Attributes attributes) {
        FeatureEntry entry = new FeatureEntry(attributes.getValue("id"), attributes.getValue("version"), false);
        String flag = attributes.getValue("optional");
        if (flag != null) {
            entry.setOptional(Boolean.valueOf(flag));
        }
        this.setEnvironment(attributes, entry);
        this.result.addEntry(entry);
    }

    private void processInstallHandler(Attributes attributes) {
        this.result.setInstallHandler(attributes.getValue("handler"));
        this.result.setInstallHandlerLibrary(attributes.getValue("library"));
        this.result.setInstallHandlerURL(attributes.getValue("url"));
    }

    private void processLicense(Attributes attributes) {
        this.result.setLicenseURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    private void processPlugin(Attributes attributes) {
        String id = attributes.getValue("id");
        String version = attributes.getValue("version");
        if (id == null || id.trim().equals("") || version == null || version.trim().equals("")) {
            System.out.println(NLS.bind((String)"FeatureParser#processPlugin, ID {0} or version {1} invalid", (Object[])new String[]{id, version}));
        } else {
            String filter;
            String fragment;
            FeatureEntry plugin = new FeatureEntry(id, version, true);
            this.setEnvironment(attributes, plugin);
            String unpack = attributes.getValue("unpack");
            if (unpack != null) {
                plugin.setUnpack(Boolean.valueOf(unpack));
            }
            if ((fragment = attributes.getValue("fragment")) != null) {
                plugin.setFragment(Boolean.valueOf(fragment));
            }
            if ((filter = attributes.getValue("filter")) != null) {
                plugin.setFilter(filter);
            }
            this.result.addEntry(plugin);
        }
    }

    private void processUpdateSite(Attributes attributes) {
        this.result.setUpdateSiteLabel(attributes.getValue("label"));
        this.result.setUpdateSiteURL(attributes.getValue("url"));
    }

    private void setEnvironment(Attributes attributes, FeatureEntry entry) {
        String os = attributes.getValue("os");
        String ws = attributes.getValue("ws");
        String nl = attributes.getValue("nl");
        String arch = attributes.getValue("arch");
        entry.setEnvironment(os, ws, arch, nl);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("plugin".equals(localName)) {
            this.processPlugin(attributes);
        } else if ("description".equals(localName)) {
            this.processDescription(attributes);
        } else if ("license".equals(localName)) {
            this.processLicense(attributes);
        } else if ("copyright".equals(localName)) {
            this.processCopyright(attributes);
        } else if ("feature".equals(localName)) {
            this.processFeature(attributes);
        } else if ("import".equals(localName)) {
            this.processImport(attributes);
        } else if ("includes".equals(localName)) {
            this.processIncludes(attributes);
        } else if ("install-handler".equals(localName)) {
            this.processInstallHandler(attributes);
        } else if ("update".equals(localName)) {
            this.processUpdateSite(attributes);
        } else if ("discovery".equals(localName)) {
            this.processDiscoverySite(attributes);
        }
    }
}

