/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.core.ProvisioningEventBus;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.Activator;
import org.eclipse.equinox.internal.p2.metadata.generator.Messages;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.EclipseInstallGeneratorInfoProvider;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Generator;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class EclipseGeneratorApplication
implements IApplication {
    private static final String[][] INPLACE_MAPPING_RULES = new String[][]{{"(& (classifier=osgi.bundle) (format=packed)", "${repoUrl}/features/${id}_${version}.jar.pack.gz"}, {"(& (classifier=org.eclipse.update.feature))", "${repoUrl}/features/${id}_${version}.jar"}, {"(& (classifier=osgi.bundle))", "${repoUrl}/plugins/${id}_${version}.jar"}, {"(& (classifier=binary))", "${repoUrl}/binary/${id}_${version}"}};
    public static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private ArtifactRepositoryManager defaultArtifactManager;
    private ServiceRegistration registrationDefaultArtifactManager;
    private MetadataRepositoryManager defaultMetadataManager;
    private ServiceRegistration registrationDefaultMetadataManager;
    private IProvisioningEventBus bus;
    private ServiceRegistration registrationBus;
    private Generator.GeneratorResult incrementalResult = null;
    private boolean generateRootIU = true;
    private String metadataLocation;
    private String metadataRepoName;
    private String artifactLocation;
    private String artifactRepoName;
    private String operation;
    private String argument;
    private String features;
    private String bundles;
    private String base;
    private String compress = "false";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private File getExecutableName(String base, EclipseInstallGeneratorInfoProvider provider) {
        File location = provider.getExecutableLocation();
        if (location == null) {
            return new File(base, EclipseInstallGeneratorInfoProvider.getDefaultExecutableName(null));
        }
        if (location.isAbsolute()) {
            return location;
        }
        return new File(base, location.getPath());
    }

    private void initialize(EclipseInstallGeneratorInfoProvider provider) throws ProvisionException {
        if ("-source".equalsIgnoreCase(this.operation)) {
            provider.initialize(new File(this.argument));
        } else if ("-inplace".equalsIgnoreCase(this.operation)) {
            provider.initialize(new File(this.argument));
            this.initializeForInplace(provider);
        } else if ("-config".equalsIgnoreCase(this.operation)) {
            provider.initialize(new File(this.argument), new File(this.argument, "configuration"), this.getExecutableName(this.argument, provider), null, null);
        } else if ("-updateSite".equalsIgnoreCase(this.operation)) {
            provider.setAddDefaultIUs(false);
            provider.initialize(new File(this.argument), null, null, new File[]{new File(this.argument, "plugins")}, new File(this.argument, "features"));
            this.initializeForInplace(provider);
        } else if (this.base != null && this.bundles != null && this.features != null) {
            provider.initialize(new File(this.base), null, null, new File[]{new File(this.bundles)}, new File(this.features));
        }
        this.initializeRepositories(provider);
    }

    private void initializeArtifactRepository(EclipseInstallGeneratorInfoProvider provider) throws ProvisionException {
        URL location;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)Activator.context, (String)clazz.getName());
        try {
            location = new URL(this.artifactLocation);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.exception_artifactRepoLocationURL, (Object)this.artifactLocation));
        }
        String repositoryName = this.artifactRepoName != null ? this.artifactRepoName : String.valueOf(this.artifactLocation) + " - artifacts";
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("p2.compressed", this.compress);
        if (provider.reuseExistingPack200Files()) {
            properties.put(PUBLISH_PACK_FILES_AS_SIBLINGS, Boolean.TRUE.toString());
        }
        IArtifactRepository result = null;
        try {
            result = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            provider.setArtifactRepository(result);
            if (this.artifactRepoName != null) {
                result.setName(this.artifactRepoName);
            }
            return;
        }
        catch (ProvisionException provisionException) {
            IArtifactRepository repository = manager.loadRepository(location, null);
            if (!repository.isModifiable()) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.exception_artifactRepoNotWritable, (Object)location));
            }
            provider.setArtifactRepository(repository);
            if (provider.reuseExistingPack200Files()) {
                repository.setProperty(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
            }
            if (!provider.append()) {
                repository.removeAll();
            }
            return;
        }
    }

    public void initializeForInplace(EclipseInstallGeneratorInfoProvider provider) {
        File location = provider.getBaseLocation();
        if (location == null) {
            location = provider.getBundleLocations()[0];
        }
        try {
            this.metadataLocation = location.toURL().toExternalForm();
            this.artifactLocation = location.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {}
        provider.setPublishArtifactRepository(true);
        provider.setPublishArtifacts(false);
        provider.setMappingRules(INPLACE_MAPPING_RULES);
    }

    private void initializeMetadataRepository(EclipseInstallGeneratorInfoProvider provider) throws ProvisionException {
        URL location;
        try {
            location = new URL(this.metadataLocation);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.exception_metadataRepoLocationURL, (Object)this.artifactLocation));
        }
        String repositoryName = this.metadataRepoName == null ? String.valueOf(this.metadataLocation) + " - metadata" : this.metadataRepoName;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("p2.compressed", this.compress);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)Activator.context, (String)clazz.getName());
        try {
            IMetadataRepository result = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            manager.addRepository(result.getLocation());
            if (this.metadataRepoName != null) {
                result.setName(this.metadataRepoName);
            }
            provider.setMetadataRepository(result);
            return;
        }
        catch (ProvisionException provisionException) {
            IMetadataRepository repository = manager.loadRepository(location, null);
            if (repository != null) {
                if (!repository.isModifiable()) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.exception_metadataRepoNotWritable, (Object)location));
                }
                provider.setMetadataRepository(repository);
                if (!provider.append()) {
                    repository.removeAll();
                }
                return;
            }
            return;
        }
    }

    private void initializeRepositories(EclipseInstallGeneratorInfoProvider provider) throws ProvisionException {
        this.initializeArtifactRepository(provider);
        this.initializeMetadataRepository(provider);
    }

    public void setCompress(String value) {
        if (Boolean.valueOf(value).booleanValue()) {
            this.compress = "true";
        }
    }

    public void processCommandLineArguments(String[] args, EclipseInstallGeneratorInfoProvider provider) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-publishArtifacts") || args[i].equalsIgnoreCase("-pa")) {
                provider.setPublishArtifacts(true);
            }
            if (args[i].equalsIgnoreCase("-publishArtifactRepository") || args[i].equalsIgnoreCase("-par")) {
                provider.setPublishArtifactRepository(true);
            }
            if (args[i].equalsIgnoreCase("-append")) {
                provider.setAppend(true);
            }
            if (args[i].equalsIgnoreCase("-noDefaultIUs")) {
                provider.setAddDefaultIUs(false);
            }
            if (args[i].equalsIgnoreCase("-compress")) {
                this.compress = "true";
            }
            if (args[i].equalsIgnoreCase("-reusePack200Files")) {
                provider.reuseExistingPack200Files(true);
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-source")) {
                    this.operation = args[i - 1];
                    this.argument = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-inplace")) {
                    this.operation = args[i - 1];
                    this.argument = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-config")) {
                    this.operation = args[i - 1];
                    this.argument = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-updateSite")) {
                    this.operation = args[i - 1];
                    this.argument = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-exe")) {
                    provider.setExecutableLocation(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-launcherConfig")) {
                    provider.setLauncherConfig(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-metadataRepository") || args[i - 1].equalsIgnoreCase("-mr")) {
                    this.metadataLocation = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-metadataRepositoryName")) {
                    this.metadataRepoName = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-artifactRepository") | args[i - 1].equalsIgnoreCase("-ar")) {
                    this.artifactLocation = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-artifactRepositoryName")) {
                    this.artifactRepoName = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-flavor")) {
                    provider.setFlavor(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-productFile")) {
                    provider.setProductFile(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-features")) {
                    this.features = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-bundles")) {
                    this.bundles = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-base")) {
                    this.base = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-root")) {
                    provider.setRootId(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-rootVersion")) {
                    provider.setRootVersion(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-p2.os")) {
                    provider.setOS(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-site")) {
                    provider.setSiteLocation(new URL(arg));
                }
            }
            ++i;
        }
    }

    private void registerDefaultArtifactRepoManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName()) == null) {
            this.defaultArtifactManager = new ArtifactRepositoryManager();
            BundleContext bundleContext2 = Activator.getContext();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.registrationDefaultArtifactManager = bundleContext2.registerService(clazz2.getName(), (Object)this.defaultArtifactManager, null);
        }
    }

    private void registerDefaultMetadataRepoManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName()) == null) {
            this.defaultMetadataManager = new MetadataRepositoryManager();
            BundleContext bundleContext2 = Activator.getContext();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.registrationDefaultMetadataManager = bundleContext2.registerService(clazz2.getName(), (Object)this.defaultMetadataManager, null);
        }
    }

    private void registerEventBus() {
        if (ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME) == null) {
            this.bus = new ProvisioningEventBus();
            this.registrationBus = Activator.getContext().registerService(IProvisioningEventBus.SERVICE_NAME, (Object)this.bus, null);
        }
    }

    public Object run(String[] args) throws Exception {
        EclipseInstallGeneratorInfoProvider provider = new EclipseInstallGeneratorInfoProvider();
        this.processCommandLineArguments(args, provider);
        Object result = this.run(provider);
        if (result != IApplication.EXIT_OK) {
            int i = 0;
            while (i < args.length) {
                System.out.println(args[i]);
                ++i;
            }
        }
        return result;
    }

    public Object run(EclipseInstallGeneratorInfoProvider provider) throws Exception {
        this.registerEventBus();
        this.registerDefaultMetadataRepoManager();
        this.registerDefaultArtifactRepoManager();
        this.initialize(provider);
        if (provider.getBaseLocation() == null && provider.getProductFile() == null && !this.generateRootIU) {
            System.out.println(Messages.exception_baseLocationNotSpecified);
            return new Integer(-1);
        }
        System.out.println(NLS.bind((String)Messages.message_generatingMetadata, (Object)provider.getBaseLocation()));
        long before = System.currentTimeMillis();
        Generator generator = new Generator(provider);
        if (this.incrementalResult != null) {
            generator.setIncrementalResult(this.incrementalResult);
        }
        generator.setGenerateRootIU(this.generateRootIU);
        IStatus result = generator.generate();
        this.incrementalResult = null;
        long after = System.currentTimeMillis();
        if (result.isOK()) {
            System.out.println(NLS.bind((String)Messages.message_generationCompleted, (Object)String.valueOf((after - before) / 1000L)));
            return IApplication.EXIT_OK;
        }
        System.out.println(result);
        return new Integer(1);
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run((String[])context.getArguments().get("application.args"));
    }

    public void stop() {
        if (this.registrationDefaultMetadataManager != null) {
            this.registrationDefaultMetadataManager.unregister();
            this.registrationDefaultMetadataManager = null;
        }
        if (this.registrationDefaultArtifactManager != null) {
            this.registrationDefaultArtifactManager.unregister();
            this.registrationDefaultArtifactManager = null;
        }
        if (this.registrationBus != null) {
            this.registrationBus.unregister();
            this.registrationBus = null;
        }
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setArtifactLocation(String location) {
        this.artifactLocation = location;
    }

    public void setBundles(String bundles) {
        this.bundles = bundles;
    }

    public void setOperation(String operation, String argument) {
        this.operation = operation;
        this.argument = argument;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public void setMetadataLocation(String location) {
        this.metadataLocation = location;
    }

    public void setIncrementalResult(Generator.GeneratorResult ius) {
        this.incrementalResult = ius;
    }

    public void setGeneratorRootIU(boolean b) {
        this.generateRootIU = b;
    }
}

