/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.console;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.console.Activator;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class ProvisioningHelper {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public static IMetadataRepository addMetadataRepository(URL location) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        try {
            return manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = location + " - metadata";
            try {
                IMetadataRepository repository = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
                manager.addRepository(repository.getLocation());
                return repository;
            }
            catch (ProvisionException provisionException2) {
                return null;
            }
        }
    }

    public static IMetadataRepository getMetadataRepository(URL location) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        try {
            return manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            return null;
        }
    }

    public static void removeMetadataRepository(URL location) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        manager.removeRepository(location);
    }

    public static IArtifactRepository addArtifactRepository(URL location) {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return null;
        }
        try {
            return manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = location + " - artifacts";
            try {
                IArtifactRepository repository = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
                manager.addRepository(repository.getLocation());
                return repository;
            }
            catch (ProvisionException provisionException2) {
                return null;
            }
        }
    }

    public static void removeArtifactRepository(URL location) {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return;
        }
        manager.removeRepository(location);
    }

    public static IProfile addProfile(String profileId, Properties properties) {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return null;
        }
        IProfile profile = profileRegistry.getProfile(profileId);
        if (profile != null) {
            return profile;
        }
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        Iterator<Object> it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            profileProperties.put(key, properties.getProperty(key));
        }
        if (profileProperties.get("org.eclipse.equinox.p2.environments") == null) {
            EnvironmentInfo info;
            BundleContext bundleContext2 = Activator.getContext();
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName())) != null) {
                profileProperties.put("org.eclipse.equinox.p2.environments", "osgi.os=" + info.getOS() + ",osgi.ws=" + info.getWS() + ",osgi.arch=" + info.getOSArch());
            } else {
                profileProperties.put("org.eclipse.equinox.p2.environments", "");
            }
        }
        return profileRegistry.addProfile(profileId, profileProperties);
    }

    public static void removeProfile(String profileId) {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return;
        }
        profileRegistry.removeProfile(profileId);
    }

    public static IProfile[] getProfiles() {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return new IProfile[0];
        }
        return profileRegistry.getProfiles();
    }

    public static IProfile getProfile(String id) {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return null;
        }
        return profileRegistry.getProfile(id);
    }

    public static Collector getInstallableUnits(URL location, Query query, IProgressMonitor monitor) {
        IMetadataRepository queryable = null;
        if (location == null) {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            queryable = (IQueryable)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        } else {
            queryable = ProvisioningHelper.getMetadataRepository(location);
        }
        return queryable.query(query, new Collector(), null);
    }

    public static URL[] getMetadataRepositories() {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return null;
        }
        URL[] repos = manager.getKnownRepositories(0);
        if (repos.length > 0) {
            return repos;
        }
        return null;
    }

    public static IStatus install(String unitId, String version, IProfile profile, IProgressMonitor progress) throws ProvisionException {
        IPlanner planner;
        if (profile == null) {
            return null;
        }
        Collector units = ProvisioningHelper.getInstallableUnits(null, (Query)new InstallableUnitQuery(unitId, new Version(version)), progress);
        if (units.isEmpty()) {
            StringBuffer error = new StringBuffer();
            error.append("Installable unit not found: " + unitId + ' ' + version + '\n');
            error.append("Repositories searched:\n");
            URL[] repos = ProvisioningHelper.getMetadataRepositories();
            if (repos != null) {
                int i = 0;
                while (i < repos.length) {
                    error.append(repos[i] + "\n");
                    ++i;
                }
            }
            throw new ProvisionException(error.toString());
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((planner = (IPlanner)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException("No planner service found.");
        }
        IEngine engine = (IEngine)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new ProvisionException("No director service found.");
        }
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IInstallableUnit[] toInstall = (IInstallableUnit[])units.toArray((Class)clazz2);
        ProvisioningContext context = new ProvisioningContext();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstall);
        ProvisioningPlan result = planner.getProvisioningPlan(request, context, progress);
        if (!result.getStatus().isOK()) {
            return result.getStatus();
        }
        return engine.perform(profile, (PhaseSet)new DefaultPhaseSet(), result.getOperands(), context, progress);
    }

    public static IStatus uninstall(String unitId, String version, IProfile profile, IProgressMonitor progress) throws ProvisionException {
        IDirector director;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IDirector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((director = (IDirector)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException("No director service found.");
        }
        return null;
    }

    public static void kick(String profileId) {
        Configurator configurator;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.equinox.internal.provisional.configurator.Configurator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((configurator = (Configurator)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return;
        }
        if (profileId == null) {
            try {
                configurator.applyConfiguration();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static URL[] getArtifactRepositories() {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return null;
        }
        URL[] repos = manager.getKnownRepositories(0);
        if (repos.length > 0) {
            return repos;
        }
        return null;
    }

    public static IArtifactRepository getArtifactRepository(URL repoURL) {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        try {
            if (manager != null) {
                return manager.loadRepository(repoURL, null);
            }
        }
        catch (ProvisionException provisionException) {}
        return null;
    }
}

